
package org.mule.modules.google.dfp.config;

import com.google.api.ads.dfp.axis.v201411.holders.DateExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.ReportJobExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.ReportQueryExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.StatementExpressionHolder;
import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.google.dfp.processors.DownloadReportMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2015-05-21T11:09:02-07:00", comments = "Build UNNAMED.2405.44720b7")
public class DownloadReportDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(DownloadReportDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(DownloadReportMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [download-report] within the connector [google-dfp] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [download-report] within the connector [google-dfp] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("downloadReport");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        if (!hasAttribute(element, "config-ref")) {
            throw new BeanDefinitionParsingException(new Problem("It seems that the config-ref for @Processor [download-report] within the connector [google-dfp] is null or missing. Please, fill the value with the correct global element.", new Location(parserContext.getReaderContext().getResource()), null));
        }
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "report-job", "reportJob", "#[payload]")) {
            BeanDefinitionBuilder reportJobBuilder = BeanDefinitionBuilder.rootBeanDefinition(ReportJobExpressionHolder.class.getName());
            Element reportJobChildElement = DomUtils.getChildElementByTagName(element, "report-job");
            if (reportJobChildElement!= null) {
                parseProperty(reportJobBuilder, reportJobChildElement, "id", "id");
                if (!parseObjectRef(reportJobChildElement, reportJobBuilder, "report-query", "reportQuery")) {
                    BeanDefinitionBuilder _reportQueryBuilder = BeanDefinitionBuilder.rootBeanDefinition(ReportQueryExpressionHolder.class.getName());
                    Element _reportQueryChildElement = DomUtils.getChildElementByTagName(reportJobChildElement, "report-query");
                    if (_reportQueryChildElement!= null) {
                        if (hasAttribute(_reportQueryChildElement, "dimensions-ref")) {
                            if (_reportQueryChildElement.getAttribute("dimensions-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("dimensions", _reportQueryChildElement.getAttribute("dimensions-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("dimensions", (("#[registry:"+ _reportQueryChildElement.getAttribute("dimensions-ref"))+"]"));
                            }
                        }
                        if (hasAttribute(_reportQueryChildElement, "adUnitView-ref")) {
                            if (_reportQueryChildElement.getAttribute("adUnitView-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("adUnitView", _reportQueryChildElement.getAttribute("adUnitView-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("adUnitView", (("#[registry:"+ _reportQueryChildElement.getAttribute("adUnitView-ref"))+"]"));
                            }
                        }
                        if (hasAttribute(_reportQueryChildElement, "columns-ref")) {
                            if (_reportQueryChildElement.getAttribute("columns-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("columns", _reportQueryChildElement.getAttribute("columns-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("columns", (("#[registry:"+ _reportQueryChildElement.getAttribute("columns-ref"))+"]"));
                            }
                        }
                        if (hasAttribute(_reportQueryChildElement, "dimensionAttributes-ref")) {
                            if (_reportQueryChildElement.getAttribute("dimensionAttributes-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("dimensionAttributes", _reportQueryChildElement.getAttribute("dimensionAttributes-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("dimensionAttributes", (("#[registry:"+ _reportQueryChildElement.getAttribute("dimensionAttributes-ref"))+"]"));
                            }
                        }
                        if (hasAttribute(_reportQueryChildElement, "customFieldIds-ref")) {
                            if (_reportQueryChildElement.getAttribute("customFieldIds-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("customFieldIds", _reportQueryChildElement.getAttribute("customFieldIds-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("customFieldIds", (("#[registry:"+ _reportQueryChildElement.getAttribute("customFieldIds-ref"))+"]"));
                            }
                        }
                        if (hasAttribute(_reportQueryChildElement, "contentMetadataKeyHierarchyCustomTargetingKeyIds-ref")) {
                            if (_reportQueryChildElement.getAttribute("contentMetadataKeyHierarchyCustomTargetingKeyIds-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("contentMetadataKeyHierarchyCustomTargetingKeyIds", _reportQueryChildElement.getAttribute("contentMetadataKeyHierarchyCustomTargetingKeyIds-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("contentMetadataKeyHierarchyCustomTargetingKeyIds", (("#[registry:"+ _reportQueryChildElement.getAttribute("contentMetadataKeyHierarchyCustomTargetingKeyIds-ref"))+"]"));
                            }
                        }
                        if (!parseObjectRef(_reportQueryChildElement, _reportQueryBuilder, "start-date", "startDate")) {
                            BeanDefinitionBuilder __startDateBuilder = BeanDefinitionBuilder.rootBeanDefinition(DateExpressionHolder.class.getName());
                            Element __startDateChildElement = DomUtils.getChildElementByTagName(_reportQueryChildElement, "start-date");
                            if (__startDateChildElement!= null) {
                                parseProperty(__startDateBuilder, __startDateChildElement, "year", "year");
                                parseProperty(__startDateBuilder, __startDateChildElement, "month", "month");
                                parseProperty(__startDateBuilder, __startDateChildElement, "day", "day");
                                _reportQueryBuilder.addPropertyValue("startDate", __startDateBuilder.getBeanDefinition());
                            }
                        }
                        if (!parseObjectRef(_reportQueryChildElement, _reportQueryBuilder, "end-date", "endDate")) {
                            BeanDefinitionBuilder __endDateBuilder = BeanDefinitionBuilder.rootBeanDefinition(DateExpressionHolder.class.getName());
                            Element __endDateChildElement = DomUtils.getChildElementByTagName(_reportQueryChildElement, "end-date");
                            if (__endDateChildElement!= null) {
                                parseProperty(__endDateBuilder, __endDateChildElement, "year", "year");
                                parseProperty(__endDateBuilder, __endDateChildElement, "month", "month");
                                parseProperty(__endDateBuilder, __endDateChildElement, "day", "day");
                                _reportQueryBuilder.addPropertyValue("endDate", __endDateBuilder.getBeanDefinition());
                            }
                        }
                        if (hasAttribute(_reportQueryChildElement, "dateRangeType-ref")) {
                            if (_reportQueryChildElement.getAttribute("dateRangeType-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("dateRangeType", _reportQueryChildElement.getAttribute("dateRangeType-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("dateRangeType", (("#[registry:"+ _reportQueryChildElement.getAttribute("dateRangeType-ref"))+"]"));
                            }
                        }
                        if (hasAttribute(_reportQueryChildElement, "dimensionFilters-ref")) {
                            if (_reportQueryChildElement.getAttribute("dimensionFilters-ref").startsWith("#")) {
                                _reportQueryBuilder.addPropertyValue("dimensionFilters", _reportQueryChildElement.getAttribute("dimensionFilters-ref"));
                            } else {
                                _reportQueryBuilder.addPropertyValue("dimensionFilters", (("#[registry:"+ _reportQueryChildElement.getAttribute("dimensionFilters-ref"))+"]"));
                            }
                        }
                        if (!parseObjectRef(_reportQueryChildElement, _reportQueryBuilder, "statement", "statement")) {
                            BeanDefinitionBuilder __statementBuilder = BeanDefinitionBuilder.rootBeanDefinition(StatementExpressionHolder.class.getName());
                            Element __statementChildElement = DomUtils.getChildElementByTagName(_reportQueryChildElement, "statement");
                            if (__statementChildElement!= null) {
                                parseProperty(__statementBuilder, __statementChildElement, "query", "query");
                                if (hasAttribute(__statementChildElement, "values-ref")) {
                                    if (__statementChildElement.getAttribute("values-ref").startsWith("#")) {
                                        __statementBuilder.addPropertyValue("values", __statementChildElement.getAttribute("values-ref"));
                                    } else {
                                        __statementBuilder.addPropertyValue("values", (("#[registry:"+ __statementChildElement.getAttribute("values-ref"))+"]"));
                                    }
                                }
                                _reportQueryBuilder.addPropertyValue("statement", __statementBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(_reportQueryBuilder, _reportQueryChildElement, "timeZone", "timeZone");
                        reportJobBuilder.addPropertyValue("reportQuery", _reportQueryBuilder.getBeanDefinition());
                    }
                }
                if (hasAttribute(reportJobChildElement, "reportJobStatus-ref")) {
                    if (reportJobChildElement.getAttribute("reportJobStatus-ref").startsWith("#")) {
                        reportJobBuilder.addPropertyValue("reportJobStatus", reportJobChildElement.getAttribute("reportJobStatus-ref"));
                    } else {
                        reportJobBuilder.addPropertyValue("reportJobStatus", (("#[registry:"+ reportJobChildElement.getAttribute("reportJobStatus-ref"))+"]"));
                    }
                }
                builder.addPropertyValue("reportJob", reportJobBuilder.getBeanDefinition());
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
