
package org.mule.modules.google.dfp.config;

import com.google.api.ads.dfp.axis.v201411.holders.DateExpressionHolder;
import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.google.dfp.processors.CreateReportMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2015-05-21T11:09:02-07:00", comments = "Build UNNAMED.2405.44720b7")
public class CreateReportDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(CreateReportDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateReportMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [create-report] within the connector [google-dfp] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [create-report] within the connector [google-dfp] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createReport");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        if (!hasAttribute(element, "config-ref")) {
            throw new BeanDefinitionParsingException(new Problem("It seems that the config-ref for @Processor [create-report] within the connector [google-dfp] is null or missing. Please, fill the value with the correct global element.", new Location(parserContext.getReaderContext().getResource()), null));
        }
        parseConfigRef(element, builder);
        if (!parseObjectRef(element, builder, "start-date", "startDate")) {
            BeanDefinitionBuilder startDateBuilder = BeanDefinitionBuilder.rootBeanDefinition(DateExpressionHolder.class.getName());
            Element startDateChildElement = DomUtils.getChildElementByTagName(element, "start-date");
            if (startDateChildElement!= null) {
                parseProperty(startDateBuilder, startDateChildElement, "year", "year");
                parseProperty(startDateBuilder, startDateChildElement, "month", "month");
                parseProperty(startDateBuilder, startDateChildElement, "day", "day");
                builder.addPropertyValue("startDate", startDateBuilder.getBeanDefinition());
            }
        }
        if (!parseObjectRef(element, builder, "end-date", "endDate")) {
            BeanDefinitionBuilder endDateBuilder = BeanDefinitionBuilder.rootBeanDefinition(DateExpressionHolder.class.getName());
            Element endDateChildElement = DomUtils.getChildElementByTagName(element, "end-date");
            if (endDateChildElement!= null) {
                parseProperty(endDateBuilder, endDateChildElement, "year", "year");
                parseProperty(endDateBuilder, endDateChildElement, "month", "month");
                parseProperty(endDateBuilder, endDateChildElement, "day", "day");
                builder.addPropertyValue("endDate", endDateBuilder.getBeanDefinition());
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
