
package org.mule.modules.google.dfp.config;

import com.google.api.ads.dfp.axis.v201411.holders.CompanyExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.DateExpressionHolder;
import com.google.api.ads.dfp.axis.v201411.holders.DateTimeExpressionHolder;
import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.mule.modules.google.dfp.processors.CreateCompanyMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2015-05-21T11:09:02-07:00", comments = "Build UNNAMED.2405.44720b7")
public class CreateCompanyDefinitionParser
    extends AbstractDevkitBasedDefinitionParser
{

    private static Logger logger = LoggerFactory.getLogger(CreateCompanyDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition(CreateCompanyMessageProcessor.class.getName());
        } catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            } catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error(("Cannot launch the mule app, the @Processor [create-company] within the connector [google-dfp] is not supported in mule "+ muleVersion));
            throw new BeanDefinitionParsingException(new Problem(("Cannot launch the mule app, the @Processor [create-company] within the connector [google-dfp] is not supported in mule "+ muleVersion), new Location(parserContext.getReaderContext().getResource()), null, noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue("createCompany");
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        if (!hasAttribute(element, "config-ref")) {
            throw new BeanDefinitionParsingException(new Problem("It seems that the config-ref for @Processor [create-company] within the connector [google-dfp] is null or missing. Please, fill the value with the correct global element.", new Location(parserContext.getReaderContext().getResource()), null));
        }
        parseConfigRef(element, builder);
        if (!parseObjectRefWithDefault(element, builder, "company", "company", "#[payload]")) {
            BeanDefinitionBuilder companyBuilder = BeanDefinitionBuilder.rootBeanDefinition(CompanyExpressionHolder.class.getName());
            Element companyChildElement = DomUtils.getChildElementByTagName(element, "company");
            if (companyChildElement!= null) {
                parseProperty(companyBuilder, companyChildElement, "id", "id");
                parseProperty(companyBuilder, companyChildElement, "name", "name");
                if (hasAttribute(companyChildElement, "type-ref")) {
                    if (companyChildElement.getAttribute("type-ref").startsWith("#")) {
                        companyBuilder.addPropertyValue("type", companyChildElement.getAttribute("type-ref"));
                    } else {
                        companyBuilder.addPropertyValue("type", (("#[registry:"+ companyChildElement.getAttribute("type-ref"))+"]"));
                    }
                }
                parseProperty(companyBuilder, companyChildElement, "address", "address");
                parseProperty(companyBuilder, companyChildElement, "email", "email");
                parseProperty(companyBuilder, companyChildElement, "faxPhone", "faxPhone");
                parseProperty(companyBuilder, companyChildElement, "primaryPhone", "primaryPhone");
                parseProperty(companyBuilder, companyChildElement, "externalId", "externalId");
                parseProperty(companyBuilder, companyChildElement, "comment", "comment");
                if (hasAttribute(companyChildElement, "creditStatus-ref")) {
                    if (companyChildElement.getAttribute("creditStatus-ref").startsWith("#")) {
                        companyBuilder.addPropertyValue("creditStatus", companyChildElement.getAttribute("creditStatus-ref"));
                    } else {
                        companyBuilder.addPropertyValue("creditStatus", (("#[registry:"+ companyChildElement.getAttribute("creditStatus-ref"))+"]"));
                    }
                }
                if (hasAttribute(companyChildElement, "appliedLabels-ref")) {
                    if (companyChildElement.getAttribute("appliedLabels-ref").startsWith("#")) {
                        companyBuilder.addPropertyValue("appliedLabels", companyChildElement.getAttribute("appliedLabels-ref"));
                    } else {
                        companyBuilder.addPropertyValue("appliedLabels", (("#[registry:"+ companyChildElement.getAttribute("appliedLabels-ref"))+"]"));
                    }
                }
                parseProperty(companyBuilder, companyChildElement, "enableSameAdvertiserCompetitiveExclusion", "enableSameAdvertiserCompetitiveExclusion");
                parseProperty(companyBuilder, companyChildElement, "primaryContactId", "primaryContactId");
                if (hasAttribute(companyChildElement, "appliedTeamIds-ref")) {
                    if (companyChildElement.getAttribute("appliedTeamIds-ref").startsWith("#")) {
                        companyBuilder.addPropertyValue("appliedTeamIds", companyChildElement.getAttribute("appliedTeamIds-ref"));
                    } else {
                        companyBuilder.addPropertyValue("appliedTeamIds", (("#[registry:"+ companyChildElement.getAttribute("appliedTeamIds-ref"))+"]"));
                    }
                }
                parseProperty(companyBuilder, companyChildElement, "thirdPartyCompanyId", "thirdPartyCompanyId");
                if (!parseObjectRef(companyChildElement, companyBuilder, "last-modified-date-time", "lastModifiedDateTime")) {
                    BeanDefinitionBuilder _lastModifiedDateTimeBuilder = BeanDefinitionBuilder.rootBeanDefinition(DateTimeExpressionHolder.class.getName());
                    Element _lastModifiedDateTimeChildElement = DomUtils.getChildElementByTagName(companyChildElement, "last-modified-date-time");
                    if (_lastModifiedDateTimeChildElement!= null) {
                        if (!parseObjectRef(_lastModifiedDateTimeChildElement, _lastModifiedDateTimeBuilder, "date", "date")) {
                            BeanDefinitionBuilder __dateBuilder = BeanDefinitionBuilder.rootBeanDefinition(DateExpressionHolder.class.getName());
                            Element __dateChildElement = DomUtils.getChildElementByTagName(_lastModifiedDateTimeChildElement, "date");
                            if (__dateChildElement!= null) {
                                parseProperty(__dateBuilder, __dateChildElement, "year", "year");
                                parseProperty(__dateBuilder, __dateChildElement, "month", "month");
                                parseProperty(__dateBuilder, __dateChildElement, "day", "day");
                                _lastModifiedDateTimeBuilder.addPropertyValue("date", __dateBuilder.getBeanDefinition());
                            }
                        }
                        parseProperty(_lastModifiedDateTimeBuilder, _lastModifiedDateTimeChildElement, "hour", "hour");
                        parseProperty(_lastModifiedDateTimeBuilder, _lastModifiedDateTimeChildElement, "minute", "minute");
                        parseProperty(_lastModifiedDateTimeBuilder, _lastModifiedDateTimeChildElement, "second", "second");
                        parseProperty(_lastModifiedDateTimeBuilder, _lastModifiedDateTimeChildElement, "timeZoneID", "timeZoneID");
                        companyBuilder.addPropertyValue("lastModifiedDateTime", _lastModifiedDateTimeBuilder.getBeanDefinition());
                    }
                }
                builder.addPropertyValue("company", companyBuilder.getBeanDefinition());
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }

}
