
package com.google.api.ads.dfp.axis.v201411.transformers;

import com.google.api.ads.dfp.axis.v201411.AppliedLabel;
import com.google.api.ads.dfp.axis.v201411.Company;
import com.google.api.ads.dfp.axis.v201411.CompanyCreditStatus;
import com.google.api.ads.dfp.axis.v201411.CompanyType;
import com.google.api.ads.dfp.axis.v201411.DateTime;
import com.google.api.ads.dfp.axis.v201411.holders.CompanyExpressionHolder;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Generated;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.transformer.types.DataTypeFactory;

@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.6.1", date = "2015-05-21T11:09:02-07:00", comments = "Build UNNAMED.2405.44720b7")
public class CompanyExpressionHolderTransformer
    extends ExpressionEvaluatorSupport
    implements DiscoverableTransformer, MessageTransformer
{

    private int weighting = DiscoverableTransformer.DEFAULT_PRIORITY_WEIGHTING;
    private ImmutableEndpoint endpoint;
    private MuleContext muleContext;
    private String name;

    public int getPriorityWeighting() {
        return weighting;
    }

    public void setPriorityWeighting(int weighting) {
        this.weighting = weighting;
    }

    public boolean isSourceTypeSupported(Class<?> aClass) {
        return (aClass == CompanyExpressionHolder.class);
    }

    public boolean isSourceDataTypeSupported(DataType<?> dataType) {
        return (dataType.getType() == CompanyExpressionHolder.class);
    }

    public List<Class<?>> getSourceTypes() {
        return Arrays.asList(new Class<?> [] {CompanyExpressionHolder.class });
    }

    public List<DataType<?>> getSourceDataTypes() {
        return Arrays.asList(new DataType<?> [] {DataTypeFactory.create(CompanyExpressionHolder.class)});
    }

    public boolean isAcceptNull() {
        return false;
    }

    public boolean isIgnoreBadInput() {
        return false;
    }

    public Object transform(Object src)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public Object transform(Object src, String encoding)
        throws TransformerException
    {
        throw new UnsupportedOperationException();
    }

    public void setReturnClass(Class<?> theClass) {
        throw new UnsupportedOperationException();
    }

    public Class<?> getReturnClass() {
        return Company.class;
    }

    public void setReturnDataType(DataType<?> type) {
        throw new UnsupportedOperationException();
    }

    public DataType<?> getReturnDataType() {
        return DataTypeFactory.create(Company.class);
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        endpoint = ep;
    }

    public ImmutableEndpoint getEndpoint() {
        return endpoint;
    }

    public void dispose() {
    }

    public void initialise()
        throws InitialisationException
    {
    }

    public void setMuleContext(MuleContext context) {
        muleContext = context;
    }

    public void setName(String newName) {
        name = newName;
    }

    public String getName() {
        return name;
    }

    public Object transform(Object src, MuleEvent event)
        throws TransformerMessagingException
    {
        return transform(src, null, event);
    }

    public Object transform(Object src, String encoding, MuleEvent event)
        throws TransformerMessagingException
    {
        if (src == null) {
            return null;
        }
        CompanyExpressionHolder holder = ((CompanyExpressionHolder) src);
        Company result = new Company();
        try {
            final Long _transformedId = ((Long) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_idType").getGenericType(), null, holder.getId()));
            result.setId(_transformedId);
            final String _transformedName = ((String) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_nameType").getGenericType(), null, holder.getName()));
            result.setName(_transformedName);
            final CompanyType _transformedType = ((CompanyType) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_typeType").getGenericType(), null, holder.getType()));
            result.setType(_transformedType);
            final String _transformedAddress = ((String) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_addressType").getGenericType(), null, holder.getAddress()));
            result.setAddress(_transformedAddress);
            final String _transformedEmail = ((String) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_emailType").getGenericType(), null, holder.getEmail()));
            result.setEmail(_transformedEmail);
            final String _transformedFaxPhone = ((String) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_faxPhoneType").getGenericType(), null, holder.getFaxPhone()));
            result.setFaxPhone(_transformedFaxPhone);
            final String _transformedPrimaryPhone = ((String) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_primaryPhoneType").getGenericType(), null, holder.getPrimaryPhone()));
            result.setPrimaryPhone(_transformedPrimaryPhone);
            final String _transformedExternalId = ((String) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_externalIdType").getGenericType(), null, holder.getExternalId()));
            result.setExternalId(_transformedExternalId);
            final String _transformedComment = ((String) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_commentType").getGenericType(), null, holder.getComment()));
            result.setComment(_transformedComment);
            final CompanyCreditStatus _transformedCreditStatus = ((CompanyCreditStatus) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_creditStatusType").getGenericType(), null, holder.getCreditStatus()));
            result.setCreditStatus(_transformedCreditStatus);
            final AppliedLabel[] _transformedAppliedLabels = ((AppliedLabel[]) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_appliedLabelsType").getGenericType(), null, holder.getAppliedLabels()));
            result.setAppliedLabels(_transformedAppliedLabels);
            final Boolean _transformedEnableSameAdvertiserCompetitiveExclusion = ((Boolean) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_enableSameAdvertiserCompetitiveExclusionType").getGenericType(), null, holder.getEnableSameAdvertiserCompetitiveExclusion()));
            result.setEnableSameAdvertiserCompetitiveExclusion(_transformedEnableSameAdvertiserCompetitiveExclusion);
            final Long _transformedPrimaryContactId = ((Long) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_primaryContactIdType").getGenericType(), null, holder.getPrimaryContactId()));
            result.setPrimaryContactId(_transformedPrimaryContactId);
            final long[] _transformedAppliedTeamIds = ((long[]) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_appliedTeamIdsType").getGenericType(), null, holder.getAppliedTeamIds()));
            result.setAppliedTeamIds(_transformedAppliedTeamIds);
            final Integer _transformedThirdPartyCompanyId = ((Integer) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_thirdPartyCompanyIdType").getGenericType(), null, holder.getThirdPartyCompanyId()));
            result.setThirdPartyCompanyId(_transformedThirdPartyCompanyId);
            final DateTime _transformedLastModifiedDateTime = ((DateTime) evaluateAndTransform(this.muleContext, event, CompanyExpressionHolder.class.getDeclaredField("_lastModifiedDateTimeType").getGenericType(), null, holder.getLastModifiedDateTime()));
            result.setLastModifiedDateTime(_transformedLastModifiedDateTime);
        } catch (NoSuchFieldException e) {
            throw new TransformerMessagingException(CoreMessages.createStaticMessage("internal error"), event, this, e);
        } catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        return result;
    }

    public MuleEvent process(MuleEvent event) {
        return null;
    }

    public String getMimeType() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public MuleContext getMuleContext() {
        return muleContext;
    }

}
