/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.soap;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.mule.modules.soap.ServiceDefinition;
import org.mule.modules.soap.Services;
import org.mule.runtime.extension.api.soap.SoapServiceProvider;
import org.mule.runtime.extension.api.soap.WebServiceDefinition;
import org.mule.runtime.extension.api.soap.security.SecurityStrategy;

public class BasicServiceProvider
implements SoapServiceProvider {
    public List<WebServiceDefinition> getWebServiceDefinitions() {
        ArrayList result = Lists.newArrayList();
        for (ServiceDefinition service : this.generateServicesDefinitions()) {
            URL resource = this.getClass().getClassLoader().getResource("wsdl/" + service.getId() + ".wsdl");
            result.add(WebServiceDefinition.builder().withId(service.getId()).withFriendlyName(service.getDisplayName()).withWsdlUrl(resource).withAddress("http://fruta.com").withService(service.getService()).withPort(service.getPort()).build());
        }
        return result;
    }

    public List<SecurityStrategy> getSecurities() {
        return new ArrayList<SecurityStrategy>();
    }

    protected List<ServiceDefinition> generateServicesDefinitions() {
        ArrayList availableServices = Lists.newArrayList();
        for (Services service : Services.values()) {
            availableServices.add(new ServiceDefinition(service.getName()));
        }
        return availableServices;
    }
}

