/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.edifact;

import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdifactAcknowledgment;
import com.anypoint.df.edi.schema.EdifactEnvelopeHandler;
import com.anypoint.df.edi.schema.EdifactInterchangeException;
import com.anypoint.df.edi.schema.EdifactParserConfig;
import com.anypoint.df.edi.schema.EdifactSchemaDefs;
import com.anypoint.df.edi.schema.EdifactStructureConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.modules.edi.BaseEnvelopeHandler;
import org.mule.modules.edi.edifact.EdifactEdiModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectEnvelopeHandler
extends BaseEnvelopeHandler
implements EdifactEnvelopeHandler {
    protected static final Logger logger = LoggerFactory.getLogger(DirectEnvelopeHandler.class);
    protected EdifactEdiModule ediModule;
    protected Set<String> groupCache;
    protected Set<String> setCache;
    protected String syntaxVersion;
    protected String contextToken;
    protected String senderId;
    protected String receiverId;

    public DirectEnvelopeHandler(EdifactEdiModule module2) {
        this.ediModule = module2;
    }

    @Override
    public Object handleUnb(Map<String, Object> map2) throws LexicalException {
        this.doHandleUnb(this.ediModule.isRequireUniqueGroupNumbers(), this.ediModule.isRequireUniqueMessageNumbers(), map2);
        String controlRef = DirectEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadReferenceKey(), map2);
        if (this.ediModule.isRequireUniqueInterchangeReferences() && !this.ediModule.cacheIdentifier(this.contextToken + controlRef)) {
            String text2 = "Duplicate interchange control reference " + controlRef;
            logger.error(text2);
            throw new EdifactInterchangeException(EdifactAcknowledgment.DuplicateDetected(), text2, null);
        }
        Character subChar = this.ediModule.getStringSubstitutionChar();
        return new EdifactParserConfig(this.ediModule.getValueLengthErrorFail(), this.ediModule.getInvalidCharacterInValueFail(), this.ediModule.getWrongValuesRepeatsFail(), this.ediModule.getUnknownSegmentFail(), this.ediModule.getSegmentOutOfOrderFail(), this.ediModule.getUnusedSegmentPresentFail(), this.ediModule.getWrongSegmentsRepeatsFail(), this.ediModule.getInvalidCharacterInValueFail(), subChar == null ? -1 : (int)subChar.charValue());
    }

    protected void doHandleUnb(boolean isRequireUniqueGroupNumbers, boolean isRequireUniqueMessageNumbers, Map<String, Object> map2) throws LexicalException {
        if (!DirectEnvelopeHandler.verifySetting(this.ediModule.getInterchangeIdQualifierPartner(), EdifactSchemaDefs.interHeadSenderQualKey(), map2) || !DirectEnvelopeHandler.verifySetting(this.ediModule.getInterchangeIdPartner(), EdifactSchemaDefs.interHeadSenderIdentKey(), map2)) {
            throw new EdifactInterchangeException(EdifactAcknowledgment.UnknownInterchangeSender(), "Interchange sender information does not match configuration", null);
        }
        if (!DirectEnvelopeHandler.verifySetting(this.ediModule.getInterchangeIdQualifierSelf(), EdifactSchemaDefs.interHeadRecipientQualKey(), map2) || !DirectEnvelopeHandler.verifySetting(this.ediModule.getInterchangeIdSelf(), EdifactSchemaDefs.interHeadRecipientIdentKey(), map2)) {
            throw new EdifactInterchangeException(EdifactAcknowledgment.NotActualRecipient(), "Interchange recipient information does not match configuration", null);
        }
        this.contextToken = DirectEnvelopeHandler.optionalString(EdifactSchemaDefs.interHeadSenderQualKey(), map2) + DirectEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadSenderIdentKey(), map2) + DirectEnvelopeHandler.optionalString(EdifactSchemaDefs.interHeadRecipientQualKey(), map2) + DirectEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadRecipientIdentKey(), map2);
        if (!isRequireUniqueGroupNumbers) {
            this.groupCache = new HashSet<String>();
        }
        if (!isRequireUniqueMessageNumbers) {
            this.setCache = new HashSet<String>();
        }
        this.syntaxVersion = DirectEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadSyntaxVersionKey(), map2);
    }

    @Override
    public EdifactAcknowledgment.SyntaxError handleUng(Map<String, Object> map2) {
        this.senderId = DirectEnvelopeHandler.optionalString(EdifactSchemaDefs.groupHeadSenderIdentKey(), map2);
        this.receiverId = DirectEnvelopeHandler.optionalString(EdifactSchemaDefs.groupHeadRecipientIdentKey(), map2);
        if (!DirectEnvelopeHandler.verifySetting(this.ediModule.getGroupIdPartner(), this.senderId, map2) || !DirectEnvelopeHandler.verifySetting(this.ediModule.getGroupIdSelf(), this.receiverId, map2)) {
            return EdifactAcknowledgment.NoAgreementForValue();
        }
        String groupRef = DirectEnvelopeHandler.requiredString(EdifactSchemaDefs.groupHeadReferenceKey(), map2);
        String ident2 = this.contextToken + this.senderId + this.receiverId + ":" + groupRef;
        if (this.ediModule.isRequireUniqueGroupNumbers()) {
            if (!this.ediModule.cacheIdentifier(ident2)) {
                logger.error("Duplicate group reference number " + groupRef);
                return EdifactAcknowledgment.DuplicateDetected();
            }
        } else if (!this.groupCache.add(ident2)) {
            logger.error("Duplicate group reference number " + groupRef);
            return EdifactAcknowledgment.DuplicateDetected();
        }
        if (!this.ediModule.isRequireUniqueMessageNumbers()) {
            this.setCache = new HashSet<String>();
        }
        return null;
    }

    @Override
    public Object handleUnh(Map<String, Object> map2) {
        Object edifactAckElseStructure = this.doHandleUnh(this.ediModule.isRequireUniqueMessageNumbers(), map2);
        if (edifactAckElseStructure instanceof EdiSchema.Structure) {
            EdiSchema.Structure structure = (EdiSchema.Structure)edifactAckElseStructure;
            return new EdifactStructureConfig(structure, null);
        }
        Object edifactAck = edifactAckElseStructure;
        return edifactAck;
    }

    protected Object doHandleUnh(boolean isRequireUniqueMessageNumbers, Map<String, Object> map2) {
        EdiSchema.Structure structure;
        if (this.isDuplicate(isRequireUniqueMessageNumbers, map2)) {
            return EdifactAcknowledgment.DuplicateDetected();
        }
        String messageType = DirectEnvelopeHandler.requiredString(EdifactSchemaDefs.msgHeadMessageTypeKey(), map2);
        String versionCode = DirectEnvelopeHandler.requiredString(EdifactSchemaDefs.msgHeadMessageVersionKey(), map2) + DirectEnvelopeHandler.requiredString(EdifactSchemaDefs.msgHeadMessageReleaseKey(), map2);
        try {
            structure = this.ediModule.getStructureSchema(this.syntaxVersion, versionCode, messageType);
        }
        catch (Exception e) {
            return EdifactAcknowledgment.NoAgreementForValue();
        }
        return structure;
    }

    protected boolean isDuplicate(boolean isRequireUniqueMessageNumbers, Map<String, Object> map2) {
        String controlNum = DirectEnvelopeHandler.requiredString(EdifactSchemaDefs.msgHeadReferenceKey(), map2);
        String ident2 = this.contextToken + this.senderId + this.receiverId + "$" + controlNum;
        return isRequireUniqueMessageNumbers ? !this.ediModule.cacheIdentifier(ident2) : !this.setCache.add(ident2);
    }
}

