/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.schema.tools;

import com.anypoint.df.edi.schema.EdiSchema;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.yaml.snakeyaml.1.15.shade.DumperOptions;
import org.yaml.snakeyaml.1.15.shade.Yaml;
import org.yaml.snakeyaml.1.15.shade.constructor.AbstractConstruct;
import org.yaml.snakeyaml.1.15.shade.constructor.Constructor;
import org.yaml.snakeyaml.1.15.shade.nodes.Node;
import org.yaml.snakeyaml.1.15.shade.nodes.ScalarNode;
import org.yaml.snakeyaml.1.15.shade.nodes.Tag;
import org.yaml.snakeyaml.1.15.shade.representer.Represent;
import org.yaml.snakeyaml.1.15.shade.representer.Representer;

public class YamlSupport {
    private final EdiSchema schema;

    public YamlSupport(EdiSchema s2) {
        this.schema = s2;
    }

    public YamlSupport() {
        this(null);
    }

    public static void writeMap(Map<String, Object> map2, Writer writer) {
        Yaml yaml = new Yaml(new EdiRepresenter(), new DumperOptions());
        yaml.dump(map2, writer);
    }

    public Map<String, Object> readMap(String text2) {
        Yaml yaml = new Yaml(new EdiConstructor());
        return (Map)yaml.load(new StringReader(text2));
    }

    private class EdiConstructor
    extends Constructor {
        public EdiConstructor() {
            this.yamlConstructors.put(new Tag("!bigdecimal"), new ConstructBigDecimal());
            this.yamlConstructors.put(new Tag("!biginteger"), new ConstructBigInteger());
            this.yamlConstructors.put(new Tag("!structure"), new ConstructStructure());
        }

        private class ConstructStructure
        extends AbstractConstruct {
            private ConstructStructure() {
            }

            @Override
            public Object construct(Node node) {
                return YamlSupport.this.schema.structures().apply((String)EdiConstructor.this.constructScalar((ScalarNode)node));
            }
        }

        private class ConstructBigInteger
        extends AbstractConstruct {
            private ConstructBigInteger() {
            }

            @Override
            public Object construct(Node node) {
                String value2 = (String)EdiConstructor.this.constructScalar((ScalarNode)node);
                return new BigInteger(value2);
            }
        }

        private class ConstructBigDecimal
        extends AbstractConstruct {
            private ConstructBigDecimal() {
            }

            @Override
            public Object construct(Node node) {
                String value2 = (String)EdiConstructor.this.constructScalar((ScalarNode)node);
                return new BigDecimal(value2);
            }
        }
    }

    private static class EdiRepresenter
    extends Representer {
        public EdiRepresenter() {
            this.representers.put(BigDecimal.class, new RepresentBigDecimal());
            this.representers.put(BigInteger.class, new RepresentBigInteger());
            this.representers.put(EdiSchema.Structure.class, new RepresentStructure());
        }

        private class RepresentStructure
        implements Represent {
            private RepresentStructure() {
            }

            @Override
            public Node representData(Object value2) {
                return EdiRepresenter.this.representScalar(new Tag("!structure"), ((EdiSchema.Structure)value2).ident());
            }
        }

        private class RepresentBigInteger
        implements Represent {
            private RepresentBigInteger() {
            }

            @Override
            public Node representData(Object value2) {
                return EdiRepresenter.this.representScalar(new Tag("!biginteger"), ((BigInteger)value2).toString());
            }
        }

        private class RepresentBigDecimal
        implements Represent {
            private RepresentBigDecimal() {
            }

            @Override
            public Node representData(Object value2) {
                return EdiRepresenter.this.representScalar(new Tag("!bigdecimal"), ((BigDecimal)value2).toString());
            }
        }
    }
}

