/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.WriteException;
import com.anypoint.df.edi.lexical.WriterBase;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public abstract class DelimiterWriter
extends WriterBase {
    private final boolean[] allowedChars;
    final int substitutionChar;
    final int subCompSeparator;
    final char componentSeparator;
    final char dataSeparator;
    final int repetitionSeparator;
    final int releaseIndicator;
    protected final String segmentSeparator;
    private final char segmentTerminator;
    private boolean segmentStart;
    protected int groupCount;
    private int skippedElementCount;
    private int skippedCompCount;
    private int skippedSubCompCount;

    protected DelimiterWriter(OutputStream os, Charset encoding, char datasep, char compsep, int subsep, int repsep2, char segterm, String segsep, int release, int subst2, char mark2, boolean[] chars) {
        super(os, encoding, mark2);
        this.dataSeparator = datasep;
        this.componentSeparator = compsep;
        this.subCompSeparator = subsep;
        this.repetitionSeparator = repsep2;
        this.segmentTerminator = segterm;
        this.segmentSeparator = segsep;
        this.releaseIndicator = release;
        this.substitutionChar = subst2;
        int limit = Math.max(datasep, Math.max(compsep, Math.max(subsep, Math.max(repsep2, Math.max(segterm, release)))));
        boolean[] allowed = null;
        if (chars == null) {
            int size2 = Math.max(limit, 128);
            allowed = DelimiterWriter.initFlags(size2);
        } else if (limit > chars.length) {
            allowed = DelimiterWriter.initFlags(limit);
            System.arraycopy(chars, 0, allowed, 0, chars.length);
        } else {
            allowed = new boolean[chars.length];
            System.arraycopy(chars, 0, allowed, 0, chars.length);
        }
        DelimiterWriter.clearFlag(datasep, allowed);
        DelimiterWriter.clearFlag(compsep, allowed);
        DelimiterWriter.clearFlag(subsep, allowed);
        DelimiterWriter.clearFlag(repsep2, allowed);
        DelimiterWriter.clearFlag(segterm, allowed);
        this.allowedChars = allowed;
    }

    private static boolean[] initFlags(int length) {
        boolean[] flags = new boolean[length];
        for (int i = 0; i < length; ++i) {
            flags[i] = true;
        }
        return flags;
    }

    private static void clearFlag(int chr, boolean[] flags) {
        if (chr >= 0 && chr < flags.length) {
            flags[chr] = false;
        }
    }

    public void countGroup() {
        ++this.groupCount;
    }

    public void skipElement() {
        ++this.skippedElementCount;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void skipComponent() {
        ++this.skippedCompCount;
        this.skippedSubCompCount = 0;
    }

    public void skipSubcomponent() {
        ++this.skippedSubCompCount;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    abstract String convertEscape(char var1) throws WriteException;

    @Override
    public abstract void init(Map<String, Object> var1) throws IOException;

    @Override
    public abstract void term(Map<String, Object> var1) throws IOException;

    private void checkSegmentStart() throws IOException {
        if (this.segmentStart && this.segmentSeparator != null) {
            this.writer.write(this.segmentSeparator);
        }
        this.segmentStart = false;
    }

    public void writeDataSeparator() throws IOException {
        this.checkSegmentStart();
        this.writer.write(this.dataSeparator);
        for (int i = 0; i < this.skippedElementCount; ++i) {
            this.writer.write(this.dataSeparator);
        }
        this.skippedElementCount = 0;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void writeComponentSeparator() throws IOException {
        this.checkSegmentStart();
        this.writer.write(this.componentSeparator);
        for (int i = 0; i < this.skippedCompCount; ++i) {
            this.writer.write(this.componentSeparator);
        }
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void writeSubcomponentSeparator() throws IOException {
        this.checkSegmentStart();
        this.writer.write((char)this.subCompSeparator);
        for (int i = 0; i < this.skippedSubCompCount; ++i) {
            this.writer.write(this.subCompSeparator);
        }
        this.skippedSubCompCount = 0;
    }

    @Override
    public void writeSegmentTerminator() throws IOException {
        this.writer.write(this.segmentTerminator);
        this.skippedElementCount = 0;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
        ++this.segmentCount;
        this.segmentStart = true;
    }

    public void writeRepetitionSeparator() throws IOException {
        this.checkSegmentStart();
        this.writer.write(this.repetitionSeparator);
        this.skippedElementCount = 0;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    private void writeText(String text2) throws IOException, WriteException {
        StringBuilder builder = new StringBuilder(text2);
        for (int i = 0; i < builder.length(); ++i) {
            char chr = builder.charAt(i);
            if (chr >= this.allowedChars.length || this.allowedChars[chr]) continue;
            if (this.releaseIndicator >= 0 && (chr == this.segmentTerminator || chr == this.dataSeparator || chr == this.componentSeparator || chr == this.subCompSeparator || chr == this.repetitionSeparator || chr == this.releaseIndicator)) {
                String escape2 = this.convertEscape(chr);
                builder.replace(i, i + 1, escape2);
                i += escape2.length() - 1;
                continue;
            }
            if (this.substitutionChar >= 0) {
                builder.setCharAt(i, (char)this.substitutionChar);
                continue;
            }
            throw new WriteException("invalid character " + chr + " in data with no release character and/or substitution character defined");
        }
        this.writer.write(builder.toString());
    }

    @Override
    public void writeToken(String text2) throws IOException {
        this.checkSegmentStart();
        this.writeText(text2);
    }

    @Override
    public void writeSpacePadded(String text2, int minl, int maxl) throws IOException {
        String token2 = text2;
        int length = token2.length();
        if (length > maxl) {
            throw new WriteException("length outside of allowed range");
        }
        this.writeText(token2);
        while (length < minl) {
            int pad = Math.min(minl - length, "                                        ".length());
            this.writer.write("                                        ", 0, pad);
            length += pad;
        }
    }

    @Override
    public void writeZeroPadded(String value2, int minl, int maxl, int adj) throws IOException {
        String text2 = value2;
        int length = text2.length() - adj;
        if (text2.startsWith("-")) {
            this.writeToken("-");
            text2 = text2.substring(1);
        } else {
            this.writeToken("");
        }
        while (length < minl) {
            int pad = Math.min(minl - length, "00000000000000000000".length());
            this.writer.write("00000000000000000000", 0, pad);
            length += pad;
        }
        if (length > maxl) {
            throw new WriteException("value too long");
        }
        this.writer.write(text2);
    }

    protected static Object getRequired(String key, Map<String, Object> props) throws WriteException {
        Object value2 = props.get(key);
        if (value2 == null) {
            throw new WriteException("missing required property value '" + key + "'");
        }
        return value2;
    }

    protected void writeProperty(String key, Map<String, Object> props, String dflt, int minl, int maxl) throws IOException {
        if (dflt == null) {
            this.writeAlphaNumeric(DelimiterWriter.getRequired(key, props).toString(), minl, maxl);
        } else {
            String text2 = (String)props.get(key);
            if (text2 == null) {
                text2 = dflt;
            }
            this.writeAlphaNumeric(text2, minl, maxl);
        }
        this.writeDataSeparator();
    }

    public void writeSeqId(int value2) throws IOException {
        if (value2 < 0) {
            throw new WriteException("value cannot be negative");
        }
        String text2 = Integer.toString(value2);
        if (text2.length() > 4) {
            throw new WriteException("value too long");
        }
        this.writeToken(text2);
    }

    public void writeAlphaNumeric(String text2, int minl, int maxl) throws IOException {
        this.writeSpacePadded(text2, minl, maxl);
    }

    public void writeId(String text2, int minl, int maxl) throws IOException {
        if (minl > 0 && text2.length() == 0) {
            throw new WriteException("at least one character must be present in id");
        }
        if (text2.charAt(0) == ' ') {
            throw new WriteException("first character of an id cannot be a space");
        }
        this.writeAlphaNumeric(text2, minl, maxl);
    }
}

