
package org.mule.modules.edi.edifact.adapters;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import com.mulesource.licm.EnterpriseLicenseKey;
import com.mulesource.licm.LicenseKeyException;
import com.mulesource.licm.LicenseManagementFactory;
import com.mulesource.licm.LicenseManager;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.common.DefaultResult;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.modules.edi.edifact.EdifactEdiMetaData;
import org.mule.modules.edi.edifact.EdifactEdiModule;
import org.mule.security.oauth.callback.ProcessCallback;


/**
 * A <code>EdifactEdiModuleProcessAdapter</code> is a wrapper around {@link EdifactEdiModule } that enables custom processing strategies.
 * 
 */
@Generated(value = "Mule DevKit Version 3.6.0", date = "2015-11-18T04:22:29-03:00", comments = "Build UNNAMED.2363.ef5c8a7")
public class EdifactEdiModuleProcessAdapter
    extends EdifactEdiModuleLifecycleAdapter
    implements ProcessAdapter<EdifactEdiModuleCapabilitiesAdapter> , Initialisable, ConnectorMetaDataEnabled
{


    public<P >ProcessTemplate<P, EdifactEdiModuleCapabilitiesAdapter> getProcessTemplate() {
        final EdifactEdiModuleCapabilitiesAdapter object = this;
        return new ProcessTemplate<P,EdifactEdiModuleCapabilitiesAdapter>() {


            @Override
            public P execute(ProcessCallback<P, EdifactEdiModuleCapabilitiesAdapter> processCallback, MessageProcessor messageProcessor, MuleEvent event)
                throws Exception
            {
                return processCallback.process(object);
            }

            @Override
            public P execute(ProcessCallback<P, EdifactEdiModuleCapabilitiesAdapter> processCallback, Filter filter, MuleMessage message)
                throws Exception
            {
                return processCallback.process(object);
            }

        }
        ;
    }

    @Override
    public Result<List<MetaDataKey>> getMetaDataKeys() {
        try {
            List<MetaDataKey> gatheredMetaDataKeys = new ArrayList<MetaDataKey>();
            EdifactEdiMetaData edifactEdiMetaData = new EdifactEdiMetaData();
            edifactEdiMetaData.setModule(this);
            gatheredMetaDataKeys.addAll(fillCategory(edifactEdiMetaData.getMetaDataKeys(), "EdifactEdiMetaData"));
            return new DefaultResult<List<MetaDataKey>>(gatheredMetaDataKeys, (Result.Status.SUCCESS));
        } catch (Exception e) {
            return new DefaultResult<List<MetaDataKey>>(null, (Result.Status.FAILURE), "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, e);
        }
    }

    private List<MetaDataKey> fillCategory(List<MetaDataKey> metadataKeys, String categoryClassName) {
        for (MetaDataKey metaDataKey: metadataKeys) {
            ((DefaultMetaDataKey) metaDataKey).setCategory(categoryClassName);
        }
        return metadataKeys;
    }

    @Override
    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        try {
            MetaData metaData = null;
            TypeDescribingProperty property = metaDataKey.getProperty(TypeDescribingProperty.class);
            String category = ((DefaultMetaDataKey) metaDataKey).getCategory();
            if (category!= null) {
                if (category.equals("EdifactEdiMetaData")) {
                    EdifactEdiMetaData edifactEdiMetaData = new EdifactEdiMetaData();
                    edifactEdiMetaData.setModule(this);
                    metaData = edifactEdiMetaData.getMetaData(metaDataKey);
                } else {
                    throw new Exception(((("Invalid key type. There is no matching category for ["+ metaDataKey.getId())+"]. All keys must contain a category with any of the following options:[EdifactEdiMetaData]")+((", but found ["+ category)+"] instead")));
                }
            } else {
                throw new Exception((("Invalid key type. There is no matching category for ["+ metaDataKey.getId())+"]. All keys must contain a category with any of the following options:[EdifactEdiMetaData]"));
            }
            metaData.getPayload().addProperty(new StructureIdentifierMetaDataModelProperty(metaDataKey, false));
            return new DefaultResult<MetaData>(metaData);
        } catch (Exception e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), getMetaDataException(metaDataKey), MetaDataFailureType.ERROR_METADATA_RETRIEVER, e);
        }
    }

    private String getMetaDataException(MetaDataKey key) {
        if ((key!= null)&&(key.getId()!= null)) {
            return ("There was an error retrieving metadata from key: "+(key.getId()+" after acquiring the connection, for more detailed information please read the provided stacktrace"));
        } else {
            return "There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace";
        }
    }

    @Override
    public void initialise()
        throws InitialisationException
    {
        super.initialise();
        checkMuleLicense();
    }

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    private void checkMuleLicense() {
        try {
            LicenseManager licenseManager = LicenseManagementFactory.getInstance().createLicenseManager(LicenseManagementFactory.MULE_EE);
            EnterpriseLicenseKey license = licenseManager.validate(LicenseManagementFactory.MULE_EE);
            Calendar expirationDate = Calendar.getInstance();
            if (license.getExpirationDate()!= null) {
                expirationDate.setTime(license.getExpirationDate());
                if (expirationDate.after(new Date())) {
                    throw new RuntimeException("Your license has expire");
                }
            }
        } catch (LicenseKeyException _x) {
            throw new RuntimeException("This Module requires an Enterprise license");
        }
    }

}
