package org.mule.modules.edi.edifact;

import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.schema.EdiSchema.Structure;
import com.anypoint.df.edi.schema.*;
import com.anypoint.df.edi.schema.EdifactAcknowledgment.SyntaxError;
import org.mule.modules.edi.BaseEnvelopeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class DirectEnvelopeHandler extends BaseEnvelopeHandler implements EdifactEnvelopeHandler
{
    protected final static Logger logger = LoggerFactory.getLogger(DirectEnvelopeHandler.class);

    protected EdifactEdiModule ediModule;
    protected Set<String> groupCache;
    protected Set<String> setCache;
    protected String syntaxVersion;
    protected String contextToken;
    protected String senderId;
    protected String receiverId;

    public DirectEnvelopeHandler(EdifactEdiModule module) {
        ediModule = module;
    }

    public Object handleUnb(Map<String, Object> map) throws LexicalException {

        doHandleUnb(ediModule.isRequireUniqueGroupNumbers(), ediModule.isRequireUniqueMessageNumbers(), map);

        String controlRef = requiredString(EdifactSchemaDefs.interHeadReferenceKey(), map);
        if (ediModule.isRequireUniqueInterchangeReferences()) {
            if (!ediModule.cacheIdentifier(contextToken + controlRef)) {
                String text = "Duplicate interchange control reference " + controlRef;
                logger.error(text);
                throw new EdifactInterchangeException(EdifactAcknowledgment.DuplicateDetected(), text, null);
            }
        }

        Character subChar = ediModule.getStringSubstitutionChar();
        return new EdifactParserConfig(ediModule.getValueLengthErrorFail(), ediModule.getInvalidCharacterInValueFail(),
            ediModule.getWrongValuesRepeatsFail(), ediModule.getUnknownSegmentFail(),
            ediModule.getSegmentOutOfOrderFail(), ediModule.getUnusedSegmentPresentFail(),
            ediModule.getWrongSegmentsRepeatsFail(), ediModule.getInvalidCharacterInValueFail(),
            subChar == null ? -1 : subChar.charValue());
    }

    protected void doHandleUnb(boolean isRequireUniqueGroupNumbers, boolean isRequireUniqueMessageNumbers,
                              Map<String, Object> map) throws LexicalException {

        if (!verifySetting(ediModule.getInterchangeIdQualifierPartner(), EdifactSchemaDefs.interHeadSenderQualKey(),
                map) ||
                !verifySetting(ediModule.getInterchangeIdPartner(), EdifactSchemaDefs.interHeadSenderIdentKey(), map)) {
            throw new EdifactInterchangeException(EdifactAcknowledgment.UnknownInterchangeSender(),
                    "Interchange sender information does not match configuration", null);
        }
        if (!verifySetting(ediModule.getInterchangeIdQualifierSelf(), EdifactSchemaDefs.interHeadRecipientQualKey(),
                map) ||
                !verifySetting(ediModule.getInterchangeIdSelf(), EdifactSchemaDefs.interHeadRecipientIdentKey(), map)) {
            throw new EdifactInterchangeException(EdifactAcknowledgment.NotActualRecipient(),
                    "Interchange recipient information does not match configuration", null);
        }

        contextToken = optionalString(EdifactSchemaDefs.interHeadSenderQualKey(), map) +
                requiredString(EdifactSchemaDefs.interHeadSenderIdentKey(), map) +
                optionalString(EdifactSchemaDefs.interHeadRecipientQualKey(), map) +
                requiredString(EdifactSchemaDefs.interHeadRecipientIdentKey(), map);

        if (!isRequireUniqueGroupNumbers) {
            groupCache = new HashSet<String>();
        }
        if (!isRequireUniqueMessageNumbers) {
            setCache = new HashSet<String>();
        }

        syntaxVersion = requiredString(EdifactSchemaDefs.interHeadSyntaxVersionKey(), map);
    }

    public SyntaxError handleUng(Map<String, Object> map) {
        senderId = optionalString(EdifactSchemaDefs.groupHeadSenderIdentKey(), map);
        receiverId = optionalString(EdifactSchemaDefs.groupHeadRecipientIdentKey(), map);
        if (!verifySetting(ediModule.getGroupIdPartner(), senderId, map) ||
            !verifySetting(ediModule.getGroupIdSelf(), receiverId, map)) {
            return EdifactAcknowledgment.NoAgreementForValue();
        }
        String groupRef = requiredString(EdifactSchemaDefs.groupHeadReferenceKey(), map);
        String ident = contextToken + senderId + receiverId + ":" + groupRef;
        if (ediModule.isRequireUniqueGroupNumbers()) {
            if (!ediModule.cacheIdentifier(ident)) {
                logger.error("Duplicate group reference number " + groupRef);
                return EdifactAcknowledgment.DuplicateDetected();
            }
        } else if (!groupCache.add(ident)) {
            logger.error("Duplicate group reference number " + groupRef);
            return EdifactAcknowledgment.DuplicateDetected();
        }
        if (!ediModule.isRequireUniqueMessageNumbers()) {
            setCache = new HashSet<String>();
        }
        return null;
    }

    public Object handleUnh(Map<String, Object> map) {
        Object edifactAckElseStructure = doHandleUnh(ediModule.isRequireUniqueMessageNumbers(), map);

        if (edifactAckElseStructure instanceof Structure) {
            Structure structure = (Structure) edifactAckElseStructure;
            return new EdifactStructureConfig(structure, null);
        } else {
            Object edifactAck = edifactAckElseStructure;
            return edifactAck;
        }
    }

    protected Object doHandleUnh(boolean isRequireUniqueMessageNumbers, Map<String, Object> map) {
        if (isDuplicate(isRequireUniqueMessageNumbers, map)) {
            return EdifactAcknowledgment.DuplicateDetected();
        }

        String messageType = requiredString(EdifactSchemaDefs.msgHeadMessageTypeKey(), map);
        String versionCode = requiredString(EdifactSchemaDefs.msgHeadMessageVersionKey(), map) +
                requiredString(EdifactSchemaDefs.msgHeadMessageReleaseKey(), map);

        Structure structure;
        try {
            structure = ediModule.getStructureSchema(syntaxVersion, versionCode, messageType);
        } catch (Exception e) {
            return EdifactAcknowledgment.NoAgreementForValue();
        }

        return structure;
    }

    protected boolean isDuplicate(boolean isRequireUniqueMessageNumbers, Map<String, Object> map) {
        String controlNum = requiredString(EdifactSchemaDefs.msgHeadReferenceKey(), map);
        String ident = contextToken + senderId + receiverId + "$" + controlNum;
        if (isRequireUniqueMessageNumbers) {
            if (!ediModule.cacheIdentifier(ident)) {
                return true;
            }
        } else if (!setCache.add(ident)) {
            return true;
        }

        return false;
    }
}
