/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.WriteException;
import com.anypoint.df.edi.lexical.WriterBase;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public class FlatFileWriter
extends WriterBase {
    public FlatFileWriter(OutputStream os, Charset encoding) {
        super(os, encoding, '.');
    }

    @Override
    public void init(Map<String, Object> props) throws IOException {
        this.writer.write("MSH");
        this.writer.write((String)props.get("MSH-02"));
    }

    @Override
    public void term(Map<String, Object> props) throws IOException {
    }

    @Override
    public void writeToken(String text) throws IOException {
        this.writer.write(text);
    }

    public void writeBlank(int size) throws IOException {
        int rem;
        for (rem = size; rem >= "                                        ".length(); rem -= "                                        ".length()) {
            this.writer.write("                                        ");
        }
        if (rem > 0) {
            this.writer.write("                                        ", 0, rem);
        }
    }

    @Override
    public void writeSpacePadded(String text, int minl, int maxl) throws IOException {
        String token2 = text;
        int length = token2.length();
        if (length > maxl) {
            throw new WriteException("length outside of allowed range");
        }
        this.writeToken(token2);
        if (length < maxl) {
            this.writeBlank(maxl - length);
        }
    }

    @Override
    public void writeZeroPadded(String value, int minl, int maxl, int adj) throws IOException {
        String text = value;
        int length = text.length();
        if (length > maxl) {
            throw new WriteException("value too long");
        }
        if (text.startsWith("-")) {
            this.writeToken("-");
            text = text.substring(1);
        } else {
            this.writeToken("");
        }
        while (length < maxl) {
            int pad = Math.min(maxl - length, "00000000000000000000".length());
            this.writer.write("00000000000000000000", 0, pad);
            length += pad;
        }
        this.writer.write(text);
    }

    @Override
    public void writeSegmentTerminator() throws IOException {
        this.writer.write(10);
        ++this.segmentCount;
    }
}

