/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.edifact.config;

import org.mule.config.MuleManifest;
import org.mule.modules.edi.edifact.config.EdifactEdiModuleConfigDefinitionParser;
import org.mule.modules.edi.edifact.config.ReadDefinitionParser;
import org.mule.modules.edi.edifact.config.WriteDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class EdifactEdiNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(EdifactEdiNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [edifact-edi] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [edifact-edi] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new EdifactEdiModuleConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("read", (BeanDefinitionParser)new ReadDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("read", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("write", (BeanDefinitionParser)new WriteDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("write", "@Processor", ex);
        }
    }
}

