/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.edifact;

import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.lexical.EdifactConstants;
import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdiSchemaVersion;
import com.anypoint.df.edi.schema.EdifactInterchangeException;
import com.anypoint.df.edi.schema.EdifactInterchangeParser;
import com.anypoint.df.edi.schema.EdifactNumberProvider;
import com.anypoint.df.edi.schema.EdifactSchemaDefs;
import com.anypoint.df.edi.schema.EdifactSchemaWriter;
import com.anypoint.df.edi.schema.EdifactWriterConfig;
import com.anypoint.df.edi.schema.SchemaJavaValues;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.ConfigType;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.mule.api.MuleEvent;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transport.OutputHandler;
import org.mule.modules.edi.BaseEdiModule;
import org.mule.modules.edi.TapOutputStream;
import org.mule.modules.edi.edifact.B2BProviderEnvelopeHandler;
import org.mule.modules.edi.edifact.DirectEnvelopeHandler;
import org.mule.modules.edi.edifact.EdifactConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.util.Try;

public class EdifactEdiModule
extends BaseEdiModule {
    private static final Logger logger = LoggerFactory.getLogger(EdifactEdiModule.class);
    private EdifactConfig edifactConfig;
    private Boolean useB2BProvider = false;
    private List<String> schemas;
    private String interchangeIdSelf;
    private String interchangeIdQualifierSelf;
    private String groupIdSelf;
    private String groupIdQualifierSelf;
    private String interchangeIdPartner;
    private String interchangeIdQualifierPartner;
    private String groupIdPartner;
    private String groupIdQualifierPartner;
    private boolean invalidCharacterInValueFail;
    private Character stringSubstitutionChar;
    private EdifactDelimiterUsage delimiterUsage;
    private Character dataSeparator;
    private Character componentSeparator;
    private Character repetitionSeparator;
    private Character segmentTerminator;
    private Character releaseCharacter;
    private boolean valueLengthErrorFail;
    private boolean wrongValuesRepeatsFail;
    private boolean unknownSegmentFail;
    private boolean segmentOutOfOrderFail;
    private boolean unusedSegmentPresentFail;
    private boolean wrongSegmentsRepeatsFail;
    private boolean requireUniqueInterchangeReferences;
    private boolean requireUniqueGroupNumbers;
    private boolean requireUniqueMessageNumbers;
    private EdifactCharacterEncoding characterEncoding;
    private EdifactConstants.SyntaxVersion sendSyntaxVersion;
    private BaseEdiModule.SegmentWhitespace lineEnding;
    private boolean alwaysSendUNA;
    private boolean sendGroups;
    private boolean sendUniqueGroupNumbers;
    private boolean sendUniqueMessageNumbers;
    private String initialInterchangeNumber;
    private String initialGroupNumber;
    private String initialMessageNumber;
    private boolean ackRequested;
    private Character defaultTestIndicator;
    @Inject
    private MuleRegistry registry;

    public void setRegistry(MuleRegistry registry) {
        this.registry = registry;
    }

    @Override
    protected MuleRegistry getRegistry() {
        return this.registry;
    }

    public void onStart() throws Exception {
        this.loadSchemas(Collections.singletonList(EdifactSchemaDefs.contrlMsg(this.sendSyntaxVersion)), new EdiSchemaVersion(EdiSchema.convertEdiForm("EDIFACT"), "D00A"));
        if (!this.useB2BProvider.booleanValue()) {
            this.edifactConfig = this.createLocalEdifactConfig();
        }
        this.doStart();
    }

    @Inject
    @MetaDataStaticKey(type="InMessage")
    public Map<String, Object> read(InputStream ediContent, MuleEvent event) throws Exception {
        Map<String, Object> result2;
        if (ediContent == null) {
            throw new RuntimeException("Couldn't get the file");
        }
        String delims = null;
        if (this.useB2BProvider.booleanValue()) {
            this.loadB2BProvider();
            QueryObject configQueryObject = (QueryObject)this.queryObjectFactory.create();
            if (this.getInterchangeIdSelf() != null && this.getInterchangeIdPartner() != null) {
                configQueryObject.put("interchangeReceiverId", this.getInterchangeIdSelf());
                configQueryObject.put("interchangeReceiverIdQualifier", this.getInterchangeIdQualifierSelf());
                configQueryObject.put("applicationReceiverId", this.getGroupIdSelf());
                configQueryObject.put("applicationReceiverIdQualifier", this.getGroupIdQualifierSelf());
                configQueryObject.put("interchangeSenderId", this.getInterchangeIdPartner());
                configQueryObject.put("interchangeSenderIdQualifier", this.getInterchangeIdQualifierPartner());
                configQueryObject.put("applicationSenderId", this.getGroupIdPartner());
                configQueryObject.put("applicationSenderIdQualifier", this.getGroupIdQualifierPartner());
                Config b2bProviderConfig = this.getB2BProviderConfig(configQueryObject, Direction.INBOUND);
                delims = new String(new char[]{Character.valueOf(((Serializable)b2bProviderConfig.get("dataSeparator")).toString().charAt(0)).charValue(), Character.valueOf(((Serializable)b2bProviderConfig.get("componentSeparator")).toString().charAt(0)).charValue(), Character.valueOf(((Serializable)b2bProviderConfig.get("repetitionSeparator")).toString().charAt(0)).charValue(), Character.valueOf(((Serializable)b2bProviderConfig.get("segmentTerminator")).toString().charAt(0)).charValue(), Character.valueOf(((Serializable)b2bProviderConfig.get("releaseCharacter")).toString().charAt(0)).charValue()});
            }
            byte[] payload = event.getMessage().getPayloadAsBytes();
            EdifactInterchangeParser parser = new EdifactInterchangeParser(new ByteArrayInputStream(payload), delims, new B2BProviderEnvelopeHandler(this.b2bProvider, this));
            result2 = this.parse(parser);
            TransmissionSession transmissionSession = this.trackInboundTransmission(event, payload, result2, TransmissionType.EDIFACT);
            event.setFlowVariable("b2bTransmissionSession", (Object)transmissionSession);
        } else {
            if (this.delimiterUsage == EdifactDelimiterUsage.USE_SPECIFIED_FOR_ALL) {
                delims = new String(new char[]{this.getDataSeparator().charValue(), this.getComponentSeparator().charValue(), this.getRepetitionSeparator().charValue(), this.getSegmentTerminator().charValue(), this.getReleaseCharacter().charValue()});
            }
            EdifactInterchangeParser parser = new EdifactInterchangeParser(ediContent, delims, new DirectEnvelopeHandler(this));
            Try<Map<String, Object>> parse2 = parser.parse();
            result2 = parse2.get();
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject
    public OutputHandler write(final @MetaDataStaticKey(type="OutMessage") Map<String, Object> map2, String interSelfIdent, String interSelfQual, String grpSelfIdent, String grpSelfQual, String interPartnerIdent, String interPartnerQual, String grpPartnerIdent, String grpPartnerQual, MuleEvent event) throws Exception {
        String delims;
        EdifactConfig writeEdifactConfig;
        final String selectedInterchangeIdSelf = this.nonnull((Serializable)((Object)interSelfIdent), this.interchangeIdSelf);
        final String selectedInterchangeIdQualifierSelf = this.nonnull((Serializable)((Object)interSelfQual), this.interchangeIdQualifierSelf);
        final String selectedGroupIdSelf = this.nonnull((Serializable)((Object)grpSelfIdent), this.groupIdSelf);
        final String selectedGroupIdQualifierSelf = this.nonnull((Serializable)((Object)grpSelfQual), this.groupIdQualifierSelf);
        final String selectedInterchangeIdPartner = this.nonnull((Serializable)((Object)interPartnerIdent), this.interchangeIdPartner);
        final String selectedInterchangeIdQualifierPartner = this.nonnull((Serializable)((Object)interPartnerQual), this.interchangeIdQualifierPartner);
        final String selectedGroupIdPartner = this.nonnull((Serializable)((Object)grpPartnerIdent), this.groupIdPartner);
        final String selectedGroupIdQualifierPartner = this.nonnull((Serializable)((Object)grpPartnerQual), this.groupIdQualifierPartner);
        if (this.useB2BProvider.booleanValue()) {
            Config b2bProviderConfig;
            this.loadB2BProvider();
            String messageType = this.getMessageType(map2);
            QueryObject queryObject = (QueryObject)this.queryObjectFactory.create();
            queryObject.put("interchangeSenderId", selectedInterchangeIdSelf);
            queryObject.put("interchangeSenderIdQualifier", selectedInterchangeIdQualifierSelf);
            queryObject.put("applicationSenderId", selectedGroupIdSelf);
            queryObject.put("applicationSenderIdQualifier", selectedGroupIdQualifierSelf);
            queryObject.put("interchangeReceiverId", selectedInterchangeIdPartner);
            queryObject.put("interchangeReceiverIdQualifier", selectedInterchangeIdQualifierPartner);
            queryObject.put("applicationReceiverId", selectedGroupIdPartner);
            queryObject.put("applicationReceiverIdQualifier", selectedGroupIdQualifierPartner);
            queryObject.put("version", this.getCombinedSchema().ediVersion().version().toUpperCase());
            if (messageType != null) {
                queryObject.put("messageType", messageType);
            }
            if ((b2bProviderConfig = this.getB2BProviderConfig(queryObject, Direction.OUTBOUND)) == null) throw new Exception("Queried registered B2B Provider for EDIFACT write config but none was found. Check your configuration. Lookup key used was: " + queryObject.toString());
            writeEdifactConfig = this.mapB2BProviderWriteConfigToEdifactConfig(b2bProviderConfig);
        } else {
            writeEdifactConfig = this.edifactConfig;
        }
        if ((delims = (String)map2.get(SchemaJavaValues.delimiterCharacters())) == null) {
            if (this.delimiterUsage != EdifactDelimiterUsage.USE_DEFAULTS) {
                delims = new String(new char[]{writeEdifactConfig.getDataSeparator().charValue(), writeEdifactConfig.getComponentSeparator().charValue(), writeEdifactConfig.getRepetitionSeparator().charValue(), writeEdifactConfig.getSegmentTerminator().charValue(), writeEdifactConfig.getReleaseCharacter().charValue()});
            }
        } else if (delims.length() != 5) {
            throw new IllegalArgumentException(SchemaJavaValues.delimiterCharacters() + " value must be 5 characters: '" + delims + "'");
        }
        if (delims != null) {
            HashSet<Character> chars = new HashSet<Character>();
            for (int i = 0; i < 5; ++i) {
                char delim = delims.charAt(i);
                if ((Character.isAlphabetic(delim) || Character.isDigit(delim)) && (i != 2 || delim != '\u0000')) {
                    throw new IllegalArgumentException("Invalid delimiter character: '" + delim + "'");
                }
                if (chars.add(Character.valueOf(delim))) continue;
                throw new IllegalArgumentException("Duplicate delimiter character: '" + delim + "'");
            }
        }
        final String useDelims = delims;
        HashMap<String, Object> imap = (HashMap<String, Object>)map2.get(SchemaJavaValues.interchangeKey());
        if (imap == null) {
            imap = new HashMap<String, Object>();
            map2.put(SchemaJavaValues.interchangeKey(), imap);
        }
        if (!imap.containsKey(EdifactSchemaDefs.interHeadAckreqKey())) {
            map2.put(EdifactSchemaDefs.interHeadAckreqKey(), writeEdifactConfig.isAckRequested() ? "1" : "0");
        }
        this.setNullDefault(EdifactSchemaDefs.interHeadSenderQualKey(), selectedInterchangeIdQualifierSelf, imap);
        this.setNullDefault(EdifactSchemaDefs.interHeadSenderIdentKey(), selectedInterchangeIdSelf, imap);
        this.setNullDefault(EdifactSchemaDefs.interHeadRecipientQualKey(), selectedInterchangeIdQualifierPartner, imap);
        this.setNullDefault(EdifactSchemaDefs.interHeadRecipientIdentKey(), selectedInterchangeIdPartner, imap);
        if (writeEdifactConfig.getDefaultTestIndicator() == null) return new OutputHandler(){
            final Transmission transmission;
            {
                this.transmission = EdifactEdiModule.this.useB2BProvider != false ? (Transmission)EdifactEdiModule.this.transmissionFactory.create() : null;
            }

            public void write(MuleEvent onWriteEvent, OutputStream output) throws IOException {
                ByteArrayOutputStream tapStream = new ByteArrayOutputStream();
                int subChar = writeEdifactConfig.getStringSubstitutionChar() == null ? -1 : (int)writeEdifactConfig.getStringSubstitutionChar().charValue();
                EdifactWriterConfig config = new EdifactWriterConfig(writeEdifactConfig.getCharacterEncoding().syntaxIdentifier, writeEdifactConfig.getSendSyntaxVersion(), writeEdifactConfig.isInvalidCharacterInValueFail(), true, subChar, '.', writeEdifactConfig.getCharacterEncoding().characterSet, useDelims, writeEdifactConfig.getLineEnding().whitespace, writeEdifactConfig.isAlwaysSendUNA());
                Map verMap = (Map)map2.get(EdifactSchemaDefs.messagesMap());
                for (String vkey : verMap.keySet()) {
                    Map msgMap = (Map)verMap.get(vkey);
                    for (String tkey : msgMap.keySet()) {
                        List msgs = (List)msgMap.get(tkey);
                        if (msgs.isEmpty()) continue;
                        EdiSchema.Structure structure = EdifactEdiModule.this.getStructureSchema(EdifactEdiModule.this.getSendSyntaxVersion().code(), vkey, tkey);
                        for (Map set : msgs) {
                            set.put(SchemaJavaValues.structureSchema(), structure);
                        }
                    }
                }
                EdifactSchemaWriter writer = new EdifactSchemaWriter(EdifactEdiModule.this.useB2BProvider != false ? new TapOutputStream(output, tapStream) : output, new EdifactNumberProvider(){
                    String groupNum;
                    String messageNum;

                    @Override
                    public String contextToken(String senderId, String senderQual, String receiverId, String receiverQual) {
                        return senderId + senderQual + receiverId + receiverQual;
                    }

                    @Override
                    public String nextInterchange(String context) {
                        this.groupNum = writeEdifactConfig.getInitialGroupNumber();
                        this.messageNum = writeEdifactConfig.getInitialMessageNumber();
                        String interchangeControlReference = EdifactEdiModule.this.getNextString(context, writeEdifactConfig.getInitialInterchangeNumber(), 14);
                        if (transmission != null) {
                            transmission.put("interchangeControlReference", interchangeControlReference);
                        }
                        return interchangeControlReference;
                    }

                    @Override
                    public String nextGroup(String context, String senderId, String senderQual, String receiverId, String receiverQual) {
                        this.messageNum = writeEdifactConfig.getInitialMessageNumber();
                        if (writeEdifactConfig.isSendUniqueGroupNumbers()) {
                            return EdifactEdiModule.this.getNextString(context + "*" + senderId + "*" + senderQual + "*" + receiverId + "*" + receiverQual, writeEdifactConfig.getInitialGroupNumber(), 14);
                        }
                        this.groupNum = EdifactEdiModule.this.incrementString(this.groupNum, 18);
                        return this.groupNum;
                    }

                    @Override
                    public String nextMessage(String context, String msgType, String msgVersion, String msgRelease, String agency) {
                        if (writeEdifactConfig.isSendUniqueMessageNumbers()) {
                            return EdifactEdiModule.this.getNextString(context, writeEdifactConfig.getInitialMessageNumber(), 14);
                        }
                        this.messageNum = EdifactEdiModule.this.incrementString(this.messageNum, 18);
                        return this.messageNum;
                    }
                }, config);
                writer.write(map2).get();
                try {
                    if (this.transmission != null) {
                        this.transmission.put("edi", map2);
                        String filename = (String)onWriteEvent.getMessage().getInboundProperty("originalFilename");
                        if (filename != null) {
                            this.transmission.put("filename", filename);
                        }
                        this.transmission.put("content", tapStream.toByteArray());
                        this.transmission.put("interchangeSenderId", selectedInterchangeIdSelf);
                        this.transmission.put("interchangeSenderIdQualifier", selectedInterchangeIdQualifierSelf);
                        this.transmission.put("applicationSenderId", selectedGroupIdSelf);
                        this.transmission.put("applicationSenderIdQualifier", selectedGroupIdQualifierSelf);
                        this.transmission.put("interchangeReceiverId", selectedInterchangeIdPartner);
                        this.transmission.put("interchangeReceiverIdQualifier", selectedInterchangeIdQualifierPartner);
                        this.transmission.put("applicationReceiverId", selectedGroupIdPartner);
                        this.transmission.put("applicationReceiverIdQualifier", selectedGroupIdQualifierPartner);
                        TransmissionSession transmissionSession = EdifactEdiModule.this.trackTransmission(EdifactEdiModule.this.b2bProvider, onWriteEvent, Direction.OUTBOUND, this.transmission, TransmissionType.EDIFACT);
                        onWriteEvent.setFlowVariable("b2bTransmissionSession", (Object)transmissionSession);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.setNullDefault(EdifactSchemaDefs.interHeadTestKey(), new String(new char[]{writeEdifactConfig.getDefaultTestIndicator().charValue()}), imap);
        return new /* invalid duplicate definition of identical inner class */;
    }

    protected String validateStringProperty(String text2, int maxl, boolean[] chflags, String name) {
        int length = text2.length();
        if (length > maxl) {
            throw new IllegalArgumentException("Value '" + text2 + "' too long for " + name);
        }
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr <= chflags.length && chflags[chr]) continue;
            throw new IllegalArgumentException("Character '" + chr + "' not allowed in string value " + name);
        }
        return text2;
    }

    protected long validateNumberProperty(long number2, String name) {
        if (number2 > 99999999999999L) {
            throw new IllegalArgumentException("Value '" + number2 + "' too large for " + name);
        }
        if (number2 < 0L) {
            throw new IllegalArgumentException("Value for " + name + " must be positive");
        }
        return number2;
    }

    @Override
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public String getInterchangeIdQualifierSelf() {
        return this.interchangeIdQualifierSelf;
    }

    public void setInterchangeIdQualifierSelf(String interchangeIdQualifierSelf) {
        this.interchangeIdQualifierSelf = this.validateStringProperty(interchangeIdQualifierSelf, 4, EdifactConstants.levelBCharacterSet, "interchangeIdQualifierSelf");
    }

    public String getInterchangeIdSelf() {
        return this.interchangeIdSelf;
    }

    public void setInterchangeIdSelf(String interchangeIdSelf) {
        this.interchangeIdSelf = this.validateStringProperty(interchangeIdSelf, 35, EdifactConstants.levelBCharacterSet, "interchangeIdSelf");
    }

    public String getInitialInterchangeNumber() {
        return this.initialInterchangeNumber;
    }

    public String getGroupIdSelf() {
        return this.groupIdSelf;
    }

    public void setGroupIdSelf(String groupIdSelf) {
        this.groupIdSelf = this.validateStringProperty(groupIdSelf, 35, EdifactConstants.levelBCharacterSet, "groupIdSelf");
    }

    public String getInterchangeIdQualifierPartner() {
        return this.interchangeIdQualifierPartner;
    }

    public void setInterchangeIdQualifierPartner(String interchangeIdQualifierPartner) {
        this.interchangeIdQualifierPartner = this.validateStringProperty(interchangeIdQualifierPartner, 4, EdifactConstants.levelBCharacterSet, "interchangeIdQualifierPartner");
    }

    public String getInterchangeIdPartner() {
        return this.interchangeIdPartner;
    }

    public void setInterchangeIdPartner(String interchangeIdPartner) {
        this.interchangeIdPartner = this.validateStringProperty(interchangeIdPartner, 35, EdifactConstants.levelBCharacterSet, "interchangeIdPartner");
    }

    public String getGroupIdPartner() {
        return this.groupIdPartner;
    }

    public void setGroupIdPartner(String groupIdPartner) {
        this.groupIdPartner = this.validateStringProperty(groupIdPartner, 35, EdifactConstants.levelBCharacterSet, "groupIdPartner");
    }

    public boolean getAckRequested() {
        return this.ackRequested;
    }

    public void setAckRequested(boolean ackRequested) {
        this.ackRequested = ackRequested;
    }

    public Character getDefaultTestIndicator() {
        return this.defaultTestIndicator;
    }

    public void setDefaultTestIndicator(Character defaultTestIndicator) {
        this.defaultTestIndicator = defaultTestIndicator;
    }

    public boolean getValueLengthErrorFail() {
        return this.valueLengthErrorFail;
    }

    public void setValueLengthErrorFail(boolean valueLengthErrorFail) {
        this.valueLengthErrorFail = valueLengthErrorFail;
    }

    public Character getStringSubstitutionChar() {
        return this.stringSubstitutionChar;
    }

    public void setStringSubstitutionChar(Character stringSubstitutionChar) {
        this.stringSubstitutionChar = this.validateSeparator(stringSubstitutionChar, "stringSubstitutionChar");
    }

    public boolean getInvalidCharacterInValueFail() {
        return this.invalidCharacterInValueFail;
    }

    public void setInvalidCharacterInValueFail(boolean invalidCharacterInValueFail) {
        this.invalidCharacterInValueFail = invalidCharacterInValueFail;
    }

    public boolean getWrongValuesRepeatsFail() {
        return this.wrongValuesRepeatsFail;
    }

    public void setWrongValuesRepeatsFail(boolean wrongValuesRepeatsFail) {
        this.wrongValuesRepeatsFail = wrongValuesRepeatsFail;
    }

    public boolean getUnknownSegmentFail() {
        return this.unknownSegmentFail;
    }

    public void setUnknownSegmentFail(boolean unknownSegmentFail) {
        this.unknownSegmentFail = unknownSegmentFail;
    }

    public boolean getSegmentOutOfOrderFail() {
        return this.segmentOutOfOrderFail;
    }

    public void setSegmentOutOfOrderFail(boolean segmentOutOfOrderFail) {
        this.segmentOutOfOrderFail = segmentOutOfOrderFail;
    }

    public boolean getUnusedSegmentPresentFail() {
        return this.unusedSegmentPresentFail;
    }

    public void setUnusedSegmentPresentFail(boolean unusedSegmentPresentFail) {
        this.unusedSegmentPresentFail = unusedSegmentPresentFail;
    }

    public boolean getWrongSegmentsRepeatsFail() {
        return this.wrongSegmentsRepeatsFail;
    }

    public void setWrongSegmentsRepeatsFail(boolean wrongSegmentsRepeatsFail) {
        this.wrongSegmentsRepeatsFail = wrongSegmentsRepeatsFail;
    }

    public boolean isRequireUniqueInterchangeReferences() {
        return this.requireUniqueInterchangeReferences;
    }

    public void setRequireUniqueInterchangeReferences(boolean requireUniqueInterchangeReferences) {
        this.requireUniqueInterchangeReferences = requireUniqueInterchangeReferences;
    }

    public boolean isRequireUniqueGroupNumbers() {
        return this.requireUniqueGroupNumbers;
    }

    public void setRequireUniqueGroupNumbers(boolean requireUniqueGroupNumbers) {
        this.requireUniqueGroupNumbers = requireUniqueGroupNumbers;
    }

    public boolean isRequireUniqueMessageNumbers() {
        return this.requireUniqueMessageNumbers;
    }

    public void setRequireUniqueMessageNumbers(boolean requireUniqueMessageNumbers) {
        this.requireUniqueMessageNumbers = requireUniqueMessageNumbers;
    }

    public boolean isSendUniqueMessageNumbers() {
        return this.sendUniqueMessageNumbers;
    }

    public void setSendUniqueMessageNumbers(boolean sendUniqueMessageNumbers) {
        this.sendUniqueMessageNumbers = sendUniqueMessageNumbers;
    }

    public boolean isSendUniqueGroupNumbers() {
        return this.sendUniqueGroupNumbers;
    }

    public void setSendUniqueGroupNumbers(boolean sendUniqueGroupNumbers) {
        this.sendUniqueGroupNumbers = sendUniqueGroupNumbers;
    }

    public EdifactDelimiterUsage getDelimiterUsage() {
        return this.delimiterUsage;
    }

    public void setDelimiterUsage(EdifactDelimiterUsage delimiterUsage) {
        this.delimiterUsage = delimiterUsage;
    }

    public Character getDataSeparator() {
        return this.dataSeparator;
    }

    public void setDataSeparator(Character dataSeparator) {
        this.dataSeparator = this.validateSeparator(dataSeparator, "dataSeparator");
    }

    public Character getComponentSeparator() {
        return this.componentSeparator;
    }

    public void setComponentSeparator(Character componentSeparator) {
        this.componentSeparator = this.validateSeparator(componentSeparator, "componentSeparator");
    }

    public Character getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public void setRepetitionSeparator(Character repetitionSeparator) {
        this.repetitionSeparator = repetitionSeparator.charValue() == 'U' ? repetitionSeparator : this.validateSeparator(repetitionSeparator, "repetitionSeparator");
    }

    public Character getSegmentTerminator() {
        return this.segmentTerminator;
    }

    public void setSegmentTerminator(Character segmentTerminator) {
        this.segmentTerminator = this.validateSeparator(segmentTerminator, "segmentTerminator");
    }

    public Character getReleaseCharacter() {
        return this.releaseCharacter;
    }

    public void setReleaseCharacter(Character releaseCharacter) {
        this.releaseCharacter = releaseCharacter;
    }

    public BaseEdiModule.SegmentWhitespace getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(BaseEdiModule.SegmentWhitespace lineEnding) {
        this.lineEnding = lineEnding;
    }

    public boolean isAlwaysSendUNA() {
        return this.alwaysSendUNA;
    }

    public void setAlwaysSendUNA(boolean alwaysSendUNA) {
        this.alwaysSendUNA = alwaysSendUNA;
    }

    public String getGroupIdQualifierSelf() {
        return this.groupIdQualifierSelf;
    }

    public void setGroupIdQualifierSelf(String groupIdQualifierSelf) {
        this.groupIdQualifierSelf = groupIdQualifierSelf;
    }

    public String getGroupIdQualifierPartner() {
        return this.groupIdQualifierPartner;
    }

    public void setGroupIdQualifierPartner(String groupIdQualifierPartner) {
        this.groupIdQualifierPartner = groupIdQualifierPartner;
    }

    public EdifactCharacterEncoding getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(EdifactCharacterEncoding characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public EdifactConstants.SyntaxVersion getSendSyntaxVersion() {
        return this.sendSyntaxVersion;
    }

    public void setSendSyntaxVersion(EdifactConstants.SyntaxVersion sendSyntaxVersion) {
        this.sendSyntaxVersion = sendSyntaxVersion;
    }

    public boolean isSendGroups() {
        return this.sendGroups;
    }

    public void setSendGroups(boolean sendGroups) {
        this.sendGroups = sendGroups;
    }

    public String getInitialGroupNumber() {
        return this.initialGroupNumber;
    }

    public void setInitialGroupNumber(String initialGroupNumber) {
        this.initialGroupNumber = initialGroupNumber;
    }

    public String getInitialMessageNumber() {
        return this.initialMessageNumber;
    }

    public void setInitialMessageNumber(String initialMessageNumber) {
        this.initialMessageNumber = initialMessageNumber;
    }

    public void setInitialInterchangeNumber(String initialInterchangeNumber) {
        this.initialInterchangeNumber = initialInterchangeNumber;
    }

    protected EdiSchema.Structure getStructureSchema(String syntax, String version, String setId) {
        if (setId.equals("CONTRL")) {
            return "4".equals(syntax) ? EdifactSchemaDefs.transCONTRLv4() : EdifactSchemaDefs.transCONTRLv3();
        }
        return this.getSchema("EDIFACT", version, setId);
    }

    private EdifactConfig createLocalEdifactConfig() throws Exception {
        EdifactConfig edifactConfig = new EdifactConfig();
        edifactConfig.setAckRequested(this.ackRequested);
        edifactConfig.setAlwaysSendUNA(this.alwaysSendUNA);
        edifactConfig.setCharacterEncoding(this.characterEncoding);
        edifactConfig.setComponentSeparator(this.componentSeparator);
        edifactConfig.setDataSeparator(this.dataSeparator);
        edifactConfig.setDefaultTestIndicator(this.defaultTestIndicator);
        edifactConfig.setInitialGroupNumber(this.initialGroupNumber);
        edifactConfig.setInitialInterchangeNumber(this.initialInterchangeNumber);
        edifactConfig.setInitialMessageNumber(this.initialMessageNumber);
        edifactConfig.setInvalidCharacterInValueFail(this.invalidCharacterInValueFail);
        edifactConfig.setLineEnding(this.lineEnding);
        edifactConfig.setReleaseCharacter(this.releaseCharacter);
        edifactConfig.setRepetitionSeparator(this.repetitionSeparator);
        edifactConfig.setRequireUniqueGroupNumbers(this.requireUniqueGroupNumbers);
        edifactConfig.setRequireUniqueInterchangeReferences(this.requireUniqueInterchangeReferences);
        edifactConfig.setRequireUniqueMessageNumbers(this.requireUniqueMessageNumbers);
        edifactConfig.setSegmentOutOfOrderFail(this.segmentOutOfOrderFail);
        edifactConfig.setSegmentTerminator(this.segmentTerminator);
        edifactConfig.setSendGroups(this.sendGroups);
        edifactConfig.setSendSyntaxVersion(this.sendSyntaxVersion);
        edifactConfig.setSendUniqueGroupNumbers(this.sendUniqueGroupNumbers);
        edifactConfig.setSendUniqueMessageNumbers(this.sendUniqueMessageNumbers);
        edifactConfig.setStringSubstitutionChar(this.stringSubstitutionChar);
        edifactConfig.setUnknownSegmentFail(this.unknownSegmentFail);
        edifactConfig.setUnusedSegmentPresentFail(this.unusedSegmentPresentFail);
        edifactConfig.setValueLengthErrorFail(this.valueLengthErrorFail);
        edifactConfig.setWrongSegmentsRepeatsFail(this.wrongSegmentsRepeatsFail);
        edifactConfig.setWrongValuesRepeatsFail(this.wrongValuesRepeatsFail);
        return edifactConfig;
    }

    protected Config getB2BProviderConfig(QueryObject configQueryObject, Direction direction) {
        try {
            return this.b2bProvider.getConfig(ConfigType.EDIFACT, direction, configQueryObject);
        }
        catch (B2BProviderException e) {
            throw new EdifactInterchangeException(null, e.getMessage(), (Throwable)((Object)e));
        }
    }

    private EdifactConfig mapB2BProviderWriteConfigToEdifactConfig(Config ediB2BProviderConfig) throws Exception {
        EdifactConfig edifactConfig = new EdifactConfig();
        if (ediB2BProviderConfig.get("defaultTestIndicator") != null) {
            edifactConfig.setDefaultTestIndicator(new Character(((Serializable)ediB2BProviderConfig.get("defaultTestIndicator")).toString().charAt(0)));
        }
        if (ediB2BProviderConfig.get("stringSubstitutionChar") != null) {
            edifactConfig.setStringSubstitutionChar(Character.valueOf(((Serializable)ediB2BProviderConfig.get("stringSubstitutionChar")).toString().charAt(0)));
        }
        edifactConfig.setSendSyntaxVersion(Enum.valueOf(EdifactConstants.SyntaxVersion.class, ((Serializable)ediB2BProviderConfig.get("sendSyntaxVersion")).toString()));
        edifactConfig.setAckRequested(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("ackRequested")).toString()));
        edifactConfig.setDataSeparator(new Character(((Serializable)ediB2BProviderConfig.get("dataSeparator")).toString().charAt(0)));
        edifactConfig.setComponentSeparator(new Character(((Serializable)ediB2BProviderConfig.get("componentSeparator")).toString().charAt(0)));
        edifactConfig.setInitialGroupNumber(((Serializable)ediB2BProviderConfig.get("initialGroupNumber")).toString());
        edifactConfig.setInitialInterchangeNumber(((Serializable)ediB2BProviderConfig.get("initialInterchangeNumber")).toString());
        edifactConfig.setInitialMessageNumber(((Serializable)ediB2BProviderConfig.get("initialMessageNumber")).toString());
        edifactConfig.setSendGroups(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("sendGroups")).toString()));
        edifactConfig.setSendUniqueGroupNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("sendUniqueGroupNumbers")).toString()));
        edifactConfig.setSendUniqueMessageNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("sendUniqueMessageNumbers")).toString()));
        edifactConfig.setReleaseCharacter(new Character(((Serializable)ediB2BProviderConfig.get("releaseCharacter")).toString().charAt(0)));
        edifactConfig.setLineEnding(Enum.valueOf(BaseEdiModule.SegmentWhitespace.class, ((Serializable)ediB2BProviderConfig.get("lineEnding")).toString()));
        edifactConfig.setSegmentTerminator(new Character(((Serializable)ediB2BProviderConfig.get("segmentTerminator")).toString().charAt(0)));
        edifactConfig.setAlwaysSendUNA(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("alwaysSendUna")).toString()));
        edifactConfig.setCharacterEncoding(Enum.valueOf(EdifactCharacterEncoding.class, ((Serializable)ediB2BProviderConfig.get("characterEncoding")).toString()));
        edifactConfig.setRepetitionSeparator(new Character(((Serializable)ediB2BProviderConfig.get("repetitionSeparator")).toString().charAt(0)));
        edifactConfig.setInvalidCharacterInValueFail(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("invalidCharacterInValueFail")).toString()));
        return edifactConfig;
    }

    public Boolean getUseB2BProvider() {
        return this.useB2BProvider;
    }

    public void setUseB2BProvider(Boolean useB2BProvider) {
        this.useB2BProvider = useB2BProvider;
    }

    private Map<String, Object> parse(EdifactInterchangeParser parser) {
        Try<Map<String, Object>> parse2 = parser.parse();
        return parse2.get();
    }

    private String getMessageType(Map edifact) {
        Map messagesByVersionRelease = (Map)edifact.get(EdifactSchemaDefs.messagesMap());
        String messageType = null;
        for (Map.Entry messagesByVersionReleaseEntry : messagesByVersionRelease.entrySet()) {
            for (Map.Entry messagesByMessageType : ((Map)messagesByVersionReleaseEntry.getValue()).entrySet()) {
                messageType = (String)messagesByMessageType.getKey();
            }
        }
        return messageType;
    }

    public static enum EdifactDelimiterUsage {
        USE_DEFAULTS("Use default delimiters from standard"),
        USE_SPECIFIED_FOR_WRITES("Use specified delimiters for writes"),
        USE_SPECIFIED_FOR_ALL("Use specified delimiters for reads and writes");

        public final String text;

        private EdifactDelimiterUsage(String msg) {
            this.text = msg;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum EdifactCharacterEncoding {
        ASCII_A("ASCII Level A", EdifactConstants.LEVELA),
        ASCII_B("ASCII Level B", EdifactConstants.LEVELB),
        ISO8859_1("ISO-8859-1", EdifactConstants.LEVELC),
        ISO8859_2("ISO-8859-2", EdifactConstants.EDIFACT_CHARSETS.get("UNOD")),
        ISO8859_3("ISO-8859-3", EdifactConstants.EDIFACT_CHARSETS.get("UNOG")),
        ISO8859_4("ISO-8859-4", EdifactConstants.EDIFACT_CHARSETS.get("UNOH")),
        ISO8859_5("ISO-8859-5", EdifactConstants.EDIFACT_CHARSETS.get("UNOE")),
        ISO8859_6("ISO-8859-6", EdifactConstants.EDIFACT_CHARSETS.get("UNOI")),
        ISO8859_7("ISO-8859-7", EdifactConstants.EDIFACT_CHARSETS.get("UNOF")),
        ISO8859_8("ISO-8859-8", EdifactConstants.EDIFACT_CHARSETS.get("UNOJ")),
        ISO8859_9("ISO-8859-9", EdifactConstants.EDIFACT_CHARSETS.get("UNOK")),
        UTF8("UTF-8", EdifactConstants.LEVELY);

        public final Charset characterSet;
        public final EdifactConstants.SyntaxIdentifier syntaxIdentifier;

        private EdifactCharacterEncoding(String name, EdifactConstants.SyntaxIdentifier syntax) {
            if (name.startsWith("ASCII")) {
                this.characterSet = EdiConstants.ASCII_CHARSET;
            } else {
                Charset chset = null;
                try {
                    chset = Charset.forName(name);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.characterSet = chset;
            }
            this.syntaxIdentifier = syntax;
        }
    }
}

