/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.WriteException;
import com.anypoint.df.edi.lexical.WriterBase;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public class FlatFileWriter
extends WriterBase {
    public FlatFileWriter(OutputStream os, Charset encoding) {
        super(os, encoding, '.');
    }

    @Override
    public void init(Map<String, Object> props) throws IOException {
        this.writer.write("MSH");
        this.writer.write((String)props.get("MSH-02"));
    }

    @Override
    public void term(Map<String, Object> props) throws IOException {
    }

    @Override
    public void writeToken(String text2) throws IOException {
        this.writer.write(text2);
    }

    public void writeBlank(int size2) throws IOException {
        int rem;
        for (rem = size2; rem >= "                                        ".length(); rem -= "                                        ".length()) {
            this.writer.write("                                        ");
        }
        if (rem > 0) {
            this.writer.write("                                        ", 0, rem);
        }
    }

    @Override
    public void writeSpacePadded(String text2, int minl, int maxl) throws IOException {
        String token2 = text2;
        int length = token2.length();
        if (length > maxl) {
            throw new WriteException("length outside of allowed range");
        }
        this.writeToken(token2);
        if (length < maxl) {
            this.writeBlank(maxl - length);
        }
    }

    @Override
    public void writeZeroPadded(String value2, int minl, int maxl, int adj) throws IOException {
        String text2 = value2;
        int length = text2.length();
        if (length > maxl) {
            throw new WriteException("value too long");
        }
        if (text2.startsWith("-")) {
            this.writeToken("-");
            text2 = text2.substring(1);
        } else {
            this.writeToken("");
        }
        while (length < maxl) {
            int pad = Math.min(maxl - length, "00000000000000000000".length());
            this.writer.write("00000000000000000000", 0, pad);
            length += pad;
        }
        this.writer.write(text2);
    }

    @Override
    public void writeSegmentTerminator() throws IOException {
        this.writer.write(10);
        ++this.segmentCount;
    }
}

