/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.edifact;

import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdifactAcknowledgment;
import com.anypoint.df.edi.schema.EdifactInterchangeException;
import com.anypoint.df.edi.schema.EdifactParserConfig;
import com.anypoint.df.edi.schema.EdifactSchemaDefs;
import com.anypoint.df.edi.schema.EdifactStructureConfig;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import org.mule.modules.edi.edifact.DirectEnvelopeHandler;
import org.mule.modules.edi.edifact.EdifactEdiModule;

class B2BProviderEnvelopeHandler
extends DirectEnvelopeHandler {
    private B2BProvider b2bProvider;
    private Factory<QueryObject> queryObjectFactory;
    private String interchangeIdQualifierPartner;
    private String interchangeIdPartner;
    private String groupIdPartner;
    private String groupIdQualifierPartner;
    private String interchangeIdQualifierSelf;
    private String interchangeIdSelf;
    private String groupIdSelf;
    private String groupIdQualifierSelf;

    public B2BProviderEnvelopeHandler(B2BProvider b2bProvider, EdifactEdiModule ediModule) throws Exception {
        super(ediModule);
        this.b2bProvider = b2bProvider;
        this.queryObjectFactory = b2bProvider.getFactoryResolver().getFactory(QueryObject.class);
    }

    @Override
    public Object handleUnb(Map<String, Object> map2) throws LexicalException {
        this.interchangeIdQualifierPartner = this.ediModule.getInterchangeIdQualifierPartner() != null ? this.ediModule.getInterchangeIdQualifierPartner() : B2BProviderEnvelopeHandler.optionalString(EdifactSchemaDefs.interHeadSenderQualKey(), map2);
        this.interchangeIdPartner = this.ediModule.getInterchangeIdPartner() != null ? this.ediModule.getInterchangeIdPartner() : B2BProviderEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadSenderIdentKey(), map2);
        this.groupIdPartner = this.ediModule.getGroupIdPartner();
        this.groupIdQualifierPartner = this.ediModule.getGroupIdQualifierPartner();
        this.interchangeIdQualifierSelf = this.ediModule.getInterchangeIdQualifierSelf() != null ? this.ediModule.getInterchangeIdQualifierSelf() : B2BProviderEnvelopeHandler.optionalString(EdifactSchemaDefs.interHeadRecipientQualKey(), map2);
        this.interchangeIdSelf = this.ediModule.getInterchangeIdSelf() != null ? this.ediModule.getInterchangeIdSelf() : B2BProviderEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadRecipientIdentKey(), map2);
        this.groupIdSelf = this.ediModule.getGroupIdSelf();
        this.groupIdQualifierSelf = this.ediModule.getGroupIdQualifierSelf();
        this.contextToken = B2BProviderEnvelopeHandler.optionalString(EdifactSchemaDefs.interHeadSenderQualKey(), map2) + B2BProviderEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadSenderIdentKey(), map2) + B2BProviderEnvelopeHandler.optionalString(EdifactSchemaDefs.interHeadRecipientQualKey(), map2) + B2BProviderEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadRecipientIdentKey(), map2);
        if (!B2BProviderEnvelopeHandler.verifySetting(this.ediModule.getInterchangeIdQualifierPartner(), EdifactSchemaDefs.interHeadSenderQualKey(), map2) || !B2BProviderEnvelopeHandler.verifySetting(this.ediModule.getInterchangeIdPartner(), EdifactSchemaDefs.interHeadSenderIdentKey(), map2)) {
            throw new EdifactInterchangeException(EdifactAcknowledgment.UnknownInterchangeSender(), "Interchange sender information does not match configuration", null);
        }
        if (!B2BProviderEnvelopeHandler.verifySetting(this.ediModule.getInterchangeIdQualifierSelf(), EdifactSchemaDefs.interHeadRecipientQualKey(), map2) || !B2BProviderEnvelopeHandler.verifySetting(this.ediModule.getInterchangeIdSelf(), EdifactSchemaDefs.interHeadRecipientIdentKey(), map2)) {
            throw new EdifactInterchangeException(EdifactAcknowledgment.NotActualRecipient(), "Interchange recipient information does not match configuration", null);
        }
        QueryObject configQueryObject = this.queryObjectFactory.create();
        configQueryObject.put("interchangeReceiverId", this.interchangeIdSelf);
        configQueryObject.put("interchangeReceiverIdQualifier", this.interchangeIdQualifierSelf);
        configQueryObject.put("applicationReceiverId", this.groupIdSelf);
        configQueryObject.put("applicationReceiverIdQualifier", this.groupIdQualifierSelf);
        configQueryObject.put("interchangeSenderId", this.interchangeIdPartner);
        configQueryObject.put("interchangeSenderIdQualifier", this.interchangeIdQualifierPartner);
        configQueryObject.put("applicationSenderId", this.groupIdPartner);
        configQueryObject.put("applicationSenderIdQualifier", this.groupIdQualifierPartner);
        Config b2bProviderConfig = this.ediModule.getB2BProviderConfig(configQueryObject, Direction.INBOUND);
        if (b2bProviderConfig != null) {
            String controlRef = B2BProviderEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadReferenceKey(), map2);
            if (Boolean.valueOf(((Serializable)b2bProviderConfig.get("requireUniqueInterchangeReferences")).toString()).booleanValue()) {
                this.assertNotDuplicateInterchange(this.interchangeIdSelf, this.interchangeIdQualifierSelf, this.groupIdSelf, this.groupIdQualifierSelf, this.interchangeIdPartner, this.interchangeIdQualifierPartner, this.groupIdPartner, this.groupIdQualifierPartner, controlRef);
            }
            if (!Boolean.valueOf(((Serializable)b2bProviderConfig.get("requireUniqueGroupNumbers")).toString()).booleanValue()) {
                this.groupCache = new HashSet();
            }
            if (!Boolean.valueOf(((Serializable)b2bProviderConfig.get("requireUniqueMessageNumbers")).toString()).booleanValue()) {
                this.setCache = new HashSet();
            }
            this.syntaxVersion = B2BProviderEnvelopeHandler.requiredString(EdifactSchemaDefs.interHeadSyntaxVersionKey(), map2);
            return this.createEdifactParserConfig(b2bProviderConfig);
        }
        throw new EdifactInterchangeException(null, "Queried registered B2B Provider for UNB segment EDIFACT read config but none was found. Check your configuration. Lookup key used was: " + configQueryObject.toString(), null);
    }

    private void assertNotDuplicateInterchange(String interchangeIdSelf, String interchangeIdQualifierSelf, String groupIdSelf, String groupIdQualifierSelf, String interchangeIdPartner, String interchangeIdQualifierPartner, String groupIdPartner, String groupIdQualifierPartner, String controlRef) {
        QueryObject transmissionQueryObject = this.queryObjectFactory.create();
        transmissionQueryObject.put("interchangeReceiverId", interchangeIdSelf);
        transmissionQueryObject.put("interchangeReceiverIdQualifier", interchangeIdQualifierSelf);
        transmissionQueryObject.put("applicationReceiverId", groupIdSelf);
        transmissionQueryObject.put("applicationReceiverIdQualifier", groupIdQualifierSelf);
        transmissionQueryObject.put("interchangeSenderId", interchangeIdPartner);
        transmissionQueryObject.put("interchangeSenderIdQualifier", interchangeIdQualifierPartner);
        transmissionQueryObject.put("applicationSenderId", groupIdPartner);
        transmissionQueryObject.put("applicationSenderIdQualifier", groupIdQualifierPartner);
        transmissionQueryObject.put("interchangeControlReference", controlRef);
        try {
            if (this.b2bProvider.readTransmission(Direction.INBOUND, TransmissionType.EDIFACT, transmissionQueryObject) != null) {
                String text2 = "Duplicate interchange control reference " + controlRef;
                logger.error(text2);
                throw new EdifactInterchangeException(EdifactAcknowledgment.DuplicateDetected(), text2, null);
            }
        }
        catch (B2BProviderException e) {
            throw new EdifactInterchangeException(null, e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public Object handleUnh(Map<String, Object> map2) {
        String messageVersion = B2BProviderEnvelopeHandler.requiredString(EdifactSchemaDefs.msgHeadMessageVersionKey(), map2) + B2BProviderEnvelopeHandler.requiredString(EdifactSchemaDefs.msgHeadMessageReleaseKey(), map2);
        QueryObject configQueryObject = this.queryObjectFactory.create();
        configQueryObject.put("interchangeReceiverId", this.interchangeIdSelf);
        configQueryObject.put("interchangeReceiverIdQualifier", this.interchangeIdQualifierSelf);
        configQueryObject.put("applicationReceiverId", this.groupIdSelf);
        configQueryObject.put("applicationReceiverIdQualifier", this.groupIdQualifierSelf);
        configQueryObject.put("interchangeSenderId", this.interchangeIdPartner);
        configQueryObject.put("interchangeSenderIdQualifier", this.interchangeIdQualifierPartner);
        configQueryObject.put("applicationSenderId", this.groupIdPartner);
        configQueryObject.put("applicationSenderIdQualifier", this.groupIdQualifierPartner);
        configQueryObject.put("messageVersion", messageVersion);
        Config b2bProviderConfig = this.ediModule.getB2BProviderConfig(configQueryObject, Direction.INBOUND);
        if (b2bProviderConfig != null) {
            EdiSchema.Structure structure;
            if (this.isDuplicate(Boolean.valueOf(((Serializable)b2bProviderConfig.get("requireUniqueMessageNumbers")).toString()), map2)) {
                return EdifactAcknowledgment.DuplicateDetected();
            }
            try {
                structure = this.getStructureSchema(map2);
            }
            catch (Exception e) {
                return EdifactAcknowledgment.NoAgreementForValue();
            }
            return new EdifactStructureConfig(structure, this.createEdifactParserConfig(b2bProviderConfig));
        }
        throw new EdifactInterchangeException(null, "Queried registered B2B Provider for UNH segment EDIFACT read config but none was found. Check your configuration. Lookup key used was: " + configQueryObject.toString(), null);
    }

    private EdifactParserConfig createEdifactParserConfig(Config b2bProviderConfig) {
        Character subChar = null;
        if (b2bProviderConfig.get("stringSubstitutionChar") != null) {
            subChar = new Character(((Serializable)b2bProviderConfig.get("stringSubstitutionChar")).toString().charAt(0));
        }
        return new EdifactParserConfig(Boolean.valueOf(((Serializable)b2bProviderConfig.get("valueLengthErrorFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("invalidCharacterInValueFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("wrongValuesRepeatsFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("unknownSegmentFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("segmentOutOfOrderFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("unusedSegmentPresentFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("wrongSegmentsRepeatsFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("invalidCharacterInValueFail")).toString()), subChar == null ? -1 : (int)subChar.charValue());
    }
}

