/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.WriteException;
import com.anypoint.df.edi.lexical.WriterBase;
import com.anypoint.df.edi.lexical.X12Constants;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;

public class X12Writer
extends WriterBase {
    public X12Writer(OutputStream os, Charset encoding, char datasep, char subsep, int repsep2, char segterm, String segsep, int subst2, X12Constants.CharacterRestriction chset) {
        super(os, encoding, datasep, subsep, -1, repsep2, segterm, segsep, -1, subst2, '.', chset.flags());
    }

    private void writeInterchangeControlNumber(Map<String, Object> props) throws IOException {
        Object version = X12Writer.getRequired("ISA13", props);
        if (!(version instanceof Integer)) {
            throw new WriteException("expected Integer for property value 'ISA13'");
        }
        this.writeInt((Integer)version, 9, 9);
    }

    @Override
    public void init(Map<String, Object> props) throws IOException {
        this.writer.write("ISA");
        this.writeDataSeparator();
        this.writeProperty("ISA01", props, "00", 2, 2);
        this.writeProperty("ISA02", props, "", 10, 10);
        this.writeProperty("ISA03", props, "00", 2, 2);
        this.writeProperty("ISA04", props, "", 10, 10);
        this.writeProperty("ISA05", props, "00", 2, 2);
        this.writeProperty("ISA06", props, null, 15, 15);
        this.writeProperty("ISA07", props, "00", 2, 2);
        this.writeProperty("ISA08", props, null, 15, 15);
        Calendar calendar = (Calendar)props.get("ISA09");
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        this.writeDate(calendar, 6, 6);
        this.writeDataSeparator();
        Integer time = (Integer)props.get("ISA10");
        int millis = time == null ? (calendar.get(11) * 24 + calendar.get(12)) * 60 * 1000 : time;
        this.writeTime(millis, 4, 4);
        this.writeDataSeparator();
        Object version = X12Writer.getRequired("ISA12", props);
        if (!(version instanceof String)) {
            throw new WriteException("expected String value for property 'ISA12'");
        }
        if ("00402".compareTo(version.toString()) <= 0) {
            this.writer.write(this.repetitionSeparator > 0 ? this.repetitionSeparator : 85);
        } else {
            this.writer.write(85);
        }
        this.writeDataSeparator();
        this.writeAlphaNumeric(version.toString(), 5, 5);
        this.writeDataSeparator();
        this.writeInterchangeControlNumber(props);
        this.writeDataSeparator();
        this.writeProperty("ISA14", props, "1", 1, 1);
        this.writeProperty("ISA15", props, "P", 1, 1);
        this.writeComponentSeparator();
        this.writeSegmentTerminator();
        this.groupCount = 0;
    }

    @Override
    public void term(Map<String, Object> props) throws IOException {
        this.writer.write("IEA");
        this.writeDataSeparator();
        this.writeInt(this.groupCount, 1, 5);
        this.writeDataSeparator();
        this.writeInterchangeControlNumber(props);
        this.writeSegmentTerminator();
    }
}

