/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.WriteException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public abstract class WriterBase {
    private static final String SPACES = "                    ";
    private static final String ZEROES = "00000000000000000000";
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;
    protected final OutputStream stream;
    protected final Writer writer;
    private final int substitutionChar;
    private final boolean[] allowedChars;
    private final int subCompSeparator;
    private final char componentSeparator;
    private final char dataSeparator;
    protected final int repetitionSeparator;
    private final int releaseIndicator;
    protected final char decimalMark;
    protected final String segmentSeparator;
    private final char segmentTerminator;
    private boolean segmentStart;
    private int segmentCount;
    protected int groupCount;
    private int skippedElementCount;
    private int skippedCompCount;
    private int skippedSubCompCount;

    protected WriterBase(OutputStream os, Charset encoding, char datasep, char compsep, int subsep, int repsep2, char segterm, String segsep, int release, int subst2, char mark2, boolean[] chars) {
        this.stream = os;
        this.dataSeparator = datasep;
        this.componentSeparator = compsep;
        this.subCompSeparator = subsep;
        this.repetitionSeparator = repsep2;
        this.segmentTerminator = segterm;
        this.decimalMark = mark2;
        this.segmentSeparator = segsep;
        this.releaseIndicator = release;
        this.substitutionChar = subst2;
        boolean[] allowed = null;
        if (chars != null && this.releaseIndicator < 0) {
            allowed = new boolean[chars.length];
            System.arraycopy(chars, 0, allowed, 0, chars.length);
            WriterBase.clearFlag(datasep, allowed);
            WriterBase.clearFlag(compsep, allowed);
            WriterBase.clearFlag(subsep, allowed);
            WriterBase.clearFlag(repsep2, allowed);
            WriterBase.clearFlag(segterm, allowed);
        }
        this.allowedChars = allowed;
        this.writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), encoding);
    }

    private static void clearFlag(int chr, boolean[] flags) {
        if (chr >= 0 && chr < flags.length) {
            flags[chr] = false;
        }
    }

    public void countGroup() {
        ++this.groupCount;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public void skipElement() {
        ++this.skippedElementCount;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void skipComponent() {
        ++this.skippedCompCount;
        this.skippedSubCompCount = 0;
    }

    public void skipSubcomponent() {
        ++this.skippedSubCompCount;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public abstract void init(Map<String, Object> var1) throws IOException;

    public abstract void term(Map<String, Object> var1) throws IOException;

    private void checkSegmentStart() throws IOException {
        if (this.segmentStart && this.segmentSeparator != null) {
            this.writer.write(this.segmentSeparator);
        }
        this.segmentStart = false;
    }

    public void writeDataSeparator() throws IOException {
        this.checkSegmentStart();
        this.writer.write(this.dataSeparator);
        for (int i = 0; i < this.skippedElementCount; ++i) {
            this.writer.write(this.dataSeparator);
        }
        this.skippedElementCount = 0;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void writeComponentSeparator() throws IOException {
        this.checkSegmentStart();
        this.writer.write(this.componentSeparator);
        for (int i = 0; i < this.skippedCompCount; ++i) {
            this.writer.write(this.componentSeparator);
        }
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void writeSubcomponentSeparator() throws IOException {
        this.checkSegmentStart();
        this.writer.write((char)this.subCompSeparator);
        for (int i = 0; i < this.skippedSubCompCount; ++i) {
            this.writer.write(this.subCompSeparator);
        }
        this.skippedSubCompCount = 0;
    }

    public void writeSegmentTerminator() throws IOException {
        this.writer.write(this.segmentTerminator);
        this.skippedElementCount = 0;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
        ++this.segmentCount;
        this.segmentStart = true;
    }

    public void writeRepetitionSeparator() throws IOException {
        this.checkSegmentStart();
        this.writer.write(this.repetitionSeparator);
        this.skippedElementCount = 0;
        this.skippedCompCount = 0;
        this.skippedSubCompCount = 0;
    }

    public void writeToken(String text2) throws IOException {
        this.checkSegmentStart();
        if (this.releaseIndicator >= 0) {
            StringBuilder builder = new StringBuilder(text2);
            for (int i = 0; i < builder.length(); ++i) {
                char chr = builder.charAt(i);
                if (chr != this.dataSeparator && chr != this.componentSeparator && chr != this.repetitionSeparator && chr != this.segmentTerminator && chr != this.releaseIndicator) continue;
                builder.insert(i++, (char)this.releaseIndicator);
            }
            this.writer.write(builder.toString());
        } else {
            this.writer.write(text2);
        }
    }

    protected static Object getRequired(String key, Map<String, Object> props) throws WriteException {
        Object value2 = props.get(key);
        if (value2 == null) {
            throw new WriteException("missing required property value '" + key + "'");
        }
        return value2;
    }

    protected void writeProperty(String key, Map<String, Object> props, String dflt, int minl, int maxl) throws IOException {
        if (dflt == null) {
            this.writeAlphaNumeric(WriterBase.getRequired(key, props).toString(), minl, maxl);
        } else {
            String text2 = (String)props.get(key);
            if (text2 == null) {
                text2 = dflt;
            }
            this.writeAlphaNumeric(text2, minl, maxl);
        }
        this.writeDataSeparator();
    }

    protected void writePadded(String text2, int minl, int maxl) throws IOException {
        int pad;
        String token2 = text2;
        for (int length = token2.length(); length < minl; length += pad) {
            pad = Math.min(minl - length, SPACES.length());
            token2 = token2 + SPACES.substring(0, pad);
        }
        if (token2.length() > maxl) {
            throw new WriteException("length outside of allowed range");
        }
        this.writeToken(token2);
    }

    public void writeAlpha(String text2, int minl, int maxl) throws IOException {
        for (int i = 0; i < text2.length(); ++i) {
            char chr = text2.charAt(i);
            if (chr < '0' || chr > '9') continue;
            throw new WriteException("alpha value type cannot contain digit");
        }
        this.writePadded(text2, minl, maxl);
    }

    public void writeAlphaNumeric(String text2, int minl, int maxl) throws IOException {
        for (int i = 0; i < text2.length(); ++i) {
            char chr = text2.charAt(i);
            if (this.allowedChars == null || chr <= this.allowedChars.length && this.allowedChars[chr]) continue;
            if (this.substitutionChar >= 0) {
                text2 = text2.replace(chr, (char)this.substitutionChar);
                continue;
            }
            throw new WriteException("character '" + chr + "' not allowed in string");
        }
        this.writePadded(text2, minl, maxl);
    }

    public void writeId(String text2, int minl, int maxl) throws IOException {
        if (minl > 0 && text2.length() == 0) {
            throw new WriteException("at least one character must be present in id");
        }
        if (text2.charAt(0) == ' ') {
            throw new WriteException("first character of an id cannot be a space");
        }
        this.writeAlphaNumeric(text2, minl, maxl);
    }

    public static String padZeroes(String value2, int minl) {
        int pad;
        String text2 = value2;
        boolean negate = text2.startsWith("-");
        for (int length = text2.length() - (negate ? 1 : 0); length < minl; length += pad) {
            pad = Math.min(minl - length, ZEROES.length());
            text2 = negate ? "-" + ZEROES.substring(0, pad) + text2.substring(1) : ZEROES.substring(0, pad) + text2;
        }
        return text2;
    }

    public void writeInt(int value2, int minl, int maxl) throws IOException {
        String text2 = WriterBase.padZeroes(Integer.toString(value2), minl);
        if (!(text2.length() <= maxl || text2.startsWith("-") && text2.length() - 1 <= maxl)) {
            throw new WriteException("value too long");
        }
        this.writeToken(text2);
    }

    public void writeSeqId(int value2) throws IOException {
        if (value2 < 0) {
            throw new WriteException("value cannot be negative");
        }
        String text2 = Integer.toString(value2);
        if (text2.length() > 4) {
            throw new WriteException("value too long");
        }
        this.writeToken(text2);
    }

    public void writeBigInteger(BigInteger value2, int minl, int maxl) throws IOException {
        String text2 = WriterBase.padZeroes(value2.toString(), minl);
        if (!(text2.length() <= maxl || text2.startsWith("-") && text2.length() - 1 <= maxl)) {
            throw new WriteException("value too long");
        }
        this.writeToken(text2);
    }

    public void writeImplicitDecimal(BigDecimal value2, int scale, int minl, int maxl) throws IOException {
        this.writeBigInteger(value2.movePointRight(scale).setScale(scale, RoundingMode.HALF_UP).toBigIntegerExact(), minl, maxl);
    }

    public void writeDecimal(BigDecimal value2, int minl, int maxl) throws IOException {
        int adj;
        int precision = value2.precision();
        int scale = value2.scale();
        if (scale <= 0 && precision - scale <= maxl) {
            this.writeBigInteger(value2.toBigIntegerExact(), minl, maxl);
            return;
        }
        if (scale >= 0 && Math.max(precision, scale) <= maxl) {
            int adj2 = (value2.signum() < 0 ? 1 : 0) + (scale > 0 ? 1 : 0);
            this.writeToken(WriterBase.padZeroes(value2.toPlainString(), minl + adj2));
            return;
        }
        BigDecimal adjusted = value2.movePointRight(scale);
        String text2 = adjusted.toBigIntegerExact().toString();
        text2 = text2 + "E" + Integer.toString(-scale);
        int n = adj = value2.signum() < 0 ? 2 : 1;
        if (scale > 0) {
            ++adj;
        }
        if (text2.length() > maxl + adj) {
            throw new WriteException("length outside of allowed range");
        }
        this.writeToken(WriterBase.padZeroes(text2, minl + adj));
    }

    public void writeNumeric(Number number2, int minl, int maxl) throws IOException {
        if (!(number2 instanceof BigInteger)) {
            BigDecimal value2 = (BigDecimal)number2;
            int precision = value2.precision();
            int scale = value2.scale();
            if (scale <= 0 && precision - scale <= maxl) {
                this.writeBigInteger(value2.toBigIntegerExact(), minl, maxl);
                return;
            }
            if (scale >= 0 && Math.max(precision, scale) <= maxl) {
                int adj = (value2.signum() < 0 ? 1 : 0) + (scale > 0 ? 1 : 0);
                this.writeToken(WriterBase.padZeroes(value2.toPlainString(), minl + adj));
                return;
            }
            throw new WriteException("length outside of allowed range");
        }
        this.writeBigInteger((BigInteger)number2, minl, maxl);
    }

    protected void appendTwoDigit(int num, StringBuilder builder) {
        if (num < 10) {
            builder.append('0');
        }
        builder.append(num);
    }

    public void writeDate(Calendar calendar, int minl, int maxl) throws IOException {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        StringBuilder builder = new StringBuilder();
        builder.append(year);
        if (maxl == 6) {
            if (year > 2070 || year <= 1970) {
                throw new WriteException("year out of range for short form date");
            }
            builder.delete(0, 2);
        } else {
            if (builder.length() > 4) {
                throw new WriteException("year outside of allowed range");
            }
            while (builder.length() < 4) {
                builder.insert(0, '0');
            }
        }
        this.appendTwoDigit(month, builder);
        this.appendTwoDigit(day, builder);
        this.writeToken(builder.toString());
    }

    public void writeDate(Date date, int minl, int maxl) throws IOException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        this.writeDate(calendar, minl, maxl);
    }

    public void writeTime(int time, int minl, int maxl) throws IOException {
        int remain = time;
        StringBuilder builder = new StringBuilder();
        int hour = remain / 3600000;
        remain = time % 3600000;
        this.appendTwoDigit(hour, builder);
        int minute = remain / 60000;
        remain = time % 60000;
        this.appendTwoDigit(minute, builder);
        if (maxl > 4 && remain > 0) {
            int second = remain / 1000;
            remain = time % 1000;
            this.appendTwoDigit(second, builder);
            if (maxl > 7 && remain > 10) {
                this.appendTwoDigit(remain / 10, builder);
            } else if (maxl == 7 && remain > 100) {
                builder.append(remain / 100);
            } else if (minl > 7) {
                builder.append("00");
            } else if (minl > 6) {
                builder.append('0');
            }
        }
        while (builder.length() < minl) {
            builder.append('0');
        }
        this.writeToken(builder.toString());
    }
}

