/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public abstract class EdiConstants {
    public static final Charset ASCII_CHARSET = Charset.forName("US-ASCII");
    public static final int maximumYear = 2070;
    private static final Map<String, DataType> NAMETYPES = new HashMap<String, DataType>();
    private static final int X12_FLAG = 1;
    private static final int EDIFACT_FLAG = 2;
    private static final int HL7_FLAG = 3;
    private static final Map<String, DataType> HL7Mapping = new HashMap<String, DataType>();
    public static final DataType[] REAL_TYPES;
    public static final DataType[] INTEGER_TYPES;
    public static final DataType[] DATE_TYPES;
    public static final DataType[] STRING_TYPES;

    protected EdiConstants() {
    }

    public static DataType toX12Type(String code2) {
        if (NAMETYPES.containsKey(code2)) {
            DataType type = NAMETYPES.get(code2);
            if ((type.formFlags & 1) == 0) {
                throw new IllegalArgumentException("Not an X12 type code " + code2);
            }
            return type;
        }
        throw new IllegalArgumentException("Unknown type code " + code2);
    }

    public static DataType toEdifactType(String code2) {
        if (NAMETYPES.containsKey(code2)) {
            DataType type = NAMETYPES.get(code2);
            if ((type.formFlags & 2) == 0) {
                throw new IllegalArgumentException("Not an EDIFACT type code " + code2);
            }
            return type;
        }
        throw new IllegalArgumentException("Unknown type code " + code2);
    }

    public static DataType toHL7Type(String code2) {
        if (HL7Mapping.containsKey(code2)) {
            return HL7Mapping.get(code2);
        }
        if (NAMETYPES.containsKey(code2)) {
            DataType type = NAMETYPES.get(code2);
            if ((type.formFlags & 3) == 0) {
                throw new IllegalArgumentException("Not an HL7 type code " + code2);
            }
            return type;
        }
        throw new IllegalArgumentException("Unknown type code " + code2);
    }

    protected static void fillChars(char from2, char to2, boolean[] flags) {
        for (int i = from2; i <= to2; ++i) {
            flags[i] = true;
        }
    }

    protected static void setChars(char[] chars, boolean[] flags) {
        for (int i = 0; i < chars.length; ++i) {
            flags[chars[i]] = true;
        }
    }

    static {
        HL7Mapping.put("FT", DataType.STRINGDATA);
        HL7Mapping.put("GTS", DataType.ALPHANUMERIC);
        HL7Mapping.put("ID", DataType.STRINGDATA);
        HL7Mapping.put("IS", DataType.STRINGDATA);
        HL7Mapping.put("TX", DataType.STRINGDATA);
        HL7Mapping.put("DTM", DataType.STRINGDATA);
        HL7Mapping.put("var", DataType.VARIES);
        REAL_TYPES = new DataType[]{DataType.REAL, DataType.NUMBER, DataType.DECIMAL1, DataType.DECIMAL2, DataType.DECIMAL3, DataType.DECIMAL4, DataType.DECIMAL5, DataType.DECIMAL6, DataType.DECIMAL7, DataType.DECIMAL8, DataType.DECIMAL9, DataType.NUMERIC};
        INTEGER_TYPES = new DataType[]{DataType.INTEGER, DataType.TIME, DataType.SEQID};
        DATE_TYPES = new DataType[]{DataType.DATE};
        STRING_TYPES = new DataType[]{DataType.ID, DataType.ALPHANUMERIC, DataType.ALPHA, DataType.DATETIME, DataType.STRINGDATA};
    }

    public static enum DataType {
        REAL("R", 1),
        ID("ID", 3),
        ALPHANUMERIC("AN", 3),
        ALPHA("A", 3),
        DATE("DT", 3),
        TIME("TM", 3),
        BINARY("B", 1),
        DATETIME("DTM", 3),
        NUMBER("N", 3),
        NUMERIC("NM", 3),
        INTEGER("N0", 1),
        DECIMAL1("N1", 1, 1),
        DECIMAL2("N2", 1, 2),
        DECIMAL3("N3", 1, 3),
        DECIMAL4("N4", 1, 4),
        DECIMAL5("N5", 1, 5),
        DECIMAL6("N6", 1, 6),
        DECIMAL7("N7", 1, 7),
        DECIMAL8("N8", 1, 8),
        DECIMAL9("N9", 1, 9),
        SEQID("SI", 3),
        STRINGDATA("ST", 3),
        VARIES("varies", 3);

        private final String typeCode;
        private final int decimalPlaces;
        private final int formFlags;

        private DataType(String code2, int flags, int places) {
            this.typeCode = code2;
            this.formFlags = flags;
            this.decimalPlaces = places;
            NAMETYPES.put(code2, this);
        }

        private DataType(String code2, int flags) {
            this(code2, flags, -1);
        }

        public String code() {
            return this.typeCode;
        }

        public boolean isDecimal() {
            return this.decimalPlaces >= 0;
        }

        public int decimalPlaces() {
            return this.decimalPlaces;
        }
    }

    public static enum ItemType {
        SEGMENT,
        END,
        REPETITION,
        DATA_ELEMENT,
        COMPONENT,
        SUB_COMPONENT;


        public ItemType nextLevel() {
            if (this.ordinal() < DATA_ELEMENT.ordinal()) {
                throw new IllegalStateException("No granularity defined for item type " + this.toString());
            }
            if (this.ordinal() == ItemType.values().length - 1) {
                return this;
            }
            return ItemType.values()[this.ordinal() + 1];
        }
    }
}

