/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.edifact;

import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdifactAcknowledgment;
import com.anypoint.df.edi.schema.EdifactEnvelopeHandler;
import com.anypoint.df.edi.schema.EdifactInterchangeException;
import com.anypoint.df.edi.schema.EdifactParserConfig;
import com.anypoint.df.edi.schema.EdifactSchemaDefs;
import com.anypoint.df.edi.schema.EdifactStructureConfig;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.modules.edi.BaseEnvelopeHandler;
import org.mule.modules.edi.edifact.EdifactEdiModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectEnvelopeHandler
extends BaseEnvelopeHandler
implements EdifactEnvelopeHandler {
    protected static final Logger logger = LoggerFactory.getLogger(DirectEnvelopeHandler.class);
    protected EdifactEdiModule ediModule;
    protected Set<String> groupCache;
    protected Set<String> setCache;
    protected String syntaxVersion;
    protected String contextToken;
    protected String senderId;
    protected String receiverId;

    public DirectEnvelopeHandler(EdifactEdiModule module) {
        this.ediModule = module;
    }

    public Object handleUnb(Map<String, Object> map) throws LexicalException {
        this.doHandleUnb(this.ediModule.isRequireUniqueGroupNumbers(), this.ediModule.isRequireUniqueMessageNumbers(), map);
        String controlRef = DirectEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.interHeadReferenceKey(), map);
        if (this.ediModule.isRequireUniqueInterchangeReferences() && !this.ediModule.cacheIdentifier(this.contextToken + controlRef)) {
            String text = "Duplicate interchange control reference " + controlRef;
            logger.error(text);
            throw new EdifactInterchangeException(EdifactAcknowledgment.DuplicateDetected(), text, null);
        }
        Character subChar = this.ediModule.getStringSubstitutionChar();
        return new EdifactParserConfig(this.ediModule.getValueLengthErrorFail(), this.ediModule.getInvalidCharacterInValueFail(), this.ediModule.getWrongValuesRepeatsFail(), this.ediModule.getUnknownSegmentFail(), this.ediModule.getSegmentOutOfOrderFail(), this.ediModule.getUnusedSegmentPresentFail(), this.ediModule.getWrongSegmentsRepeatsFail(), this.ediModule.getInvalidCharacterInValueFail(), subChar == null ? -1 : (int)subChar.charValue());
    }

    protected void doHandleUnb(boolean isRequireUniqueGroupNumbers, boolean isRequireUniqueMessageNumbers, Map<String, Object> map) throws LexicalException {
        if (!DirectEnvelopeHandler.verifySetting((String)this.ediModule.getInterchangeIdQualifierPartner(), (Object)EdifactSchemaDefs.interHeadSenderQualKey(), map) || !DirectEnvelopeHandler.verifySetting((String)this.ediModule.getInterchangeIdPartner(), (Object)EdifactSchemaDefs.interHeadSenderIdentKey(), map)) {
            throw new EdifactInterchangeException(EdifactAcknowledgment.UnknownInterchangeSender(), "Interchange sender information does not match configuration", null);
        }
        if (!DirectEnvelopeHandler.verifySetting((String)this.ediModule.getInterchangeIdQualifierSelf(), (Object)EdifactSchemaDefs.interHeadRecipientQualKey(), map) || !DirectEnvelopeHandler.verifySetting((String)this.ediModule.getInterchangeIdSelf(), (Object)EdifactSchemaDefs.interHeadRecipientIdentKey(), map)) {
            throw new EdifactInterchangeException(EdifactAcknowledgment.NotActualRecipient(), "Interchange recipient information does not match configuration", null);
        }
        this.contextToken = DirectEnvelopeHandler.optionalString((Object)EdifactSchemaDefs.interHeadSenderQualKey(), map) + DirectEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.interHeadSenderIdentKey(), map) + DirectEnvelopeHandler.optionalString((Object)EdifactSchemaDefs.interHeadRecipientQualKey(), map) + DirectEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.interHeadRecipientIdentKey(), map);
        if (!isRequireUniqueGroupNumbers) {
            this.groupCache = new HashSet<String>();
        }
        if (!isRequireUniqueMessageNumbers) {
            this.setCache = new HashSet<String>();
        }
        this.syntaxVersion = DirectEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.interHeadSyntaxVersionKey(), map);
    }

    public EdifactAcknowledgment.SyntaxError handleUng(Map<String, Object> map) {
        this.senderId = DirectEnvelopeHandler.optionalString((Object)EdifactSchemaDefs.groupHeadSenderIdentKey(), map);
        this.receiverId = DirectEnvelopeHandler.optionalString((Object)EdifactSchemaDefs.groupHeadRecipientIdentKey(), map);
        if (!DirectEnvelopeHandler.verifySetting((String)this.ediModule.getGroupIdPartner(), (Object)this.senderId, map) || !DirectEnvelopeHandler.verifySetting((String)this.ediModule.getGroupIdSelf(), (Object)this.receiverId, map)) {
            return EdifactAcknowledgment.NoAgreementForValue();
        }
        String groupRef = DirectEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.groupHeadReferenceKey(), map);
        String ident = this.contextToken + this.senderId + this.receiverId + ":" + groupRef;
        if (this.ediModule.isRequireUniqueGroupNumbers()) {
            if (!this.ediModule.cacheIdentifier(ident)) {
                logger.error("Duplicate group reference number " + groupRef);
                return EdifactAcknowledgment.DuplicateDetected();
            }
        } else if (!this.groupCache.add(ident)) {
            logger.error("Duplicate group reference number " + groupRef);
            return EdifactAcknowledgment.DuplicateDetected();
        }
        if (!this.ediModule.isRequireUniqueMessageNumbers()) {
            this.setCache = new HashSet<String>();
        }
        return null;
    }

    public Object handleUnh(Map<String, Object> map) {
        Object edifactAckElseStructure = this.doHandleUnh(this.ediModule.isRequireUniqueMessageNumbers(), map);
        if (edifactAckElseStructure instanceof EdiSchema.Structure) {
            EdiSchema.Structure structure = (EdiSchema.Structure)edifactAckElseStructure;
            return new EdifactStructureConfig(structure, null);
        }
        Object edifactAck = edifactAckElseStructure;
        return edifactAck;
    }

    protected Object doHandleUnh(boolean isRequireUniqueMessageNumbers, Map<String, Object> map) {
        EdiSchema.Structure structure;
        if (this.isDuplicate(isRequireUniqueMessageNumbers, map)) {
            return EdifactAcknowledgment.DuplicateDetected();
        }
        String messageType = DirectEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.msgHeadMessageTypeKey(), map);
        String versionCode = DirectEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.msgHeadMessageVersionKey(), map) + DirectEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.msgHeadMessageReleaseKey(), map);
        try {
            structure = this.ediModule.getStructureSchema(this.syntaxVersion, versionCode, messageType);
        }
        catch (Exception e) {
            return EdifactAcknowledgment.NoAgreementForValue();
        }
        return structure;
    }

    protected boolean isDuplicate(boolean isRequireUniqueMessageNumbers, Map<String, Object> map) {
        String controlNum = DirectEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.msgHeadReferenceKey(), map);
        String ident = this.contextToken + this.senderId + this.receiverId + "$" + controlNum;
        return isRequireUniqueMessageNumbers ? !this.ediModule.cacheIdentifier(ident) : !this.setCache.add(ident);
    }
}

