/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.edifact;

import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdifactAcknowledgment;
import com.anypoint.df.edi.schema.EdifactInterchangeException;
import com.anypoint.df.edi.schema.EdifactParserConfig;
import com.anypoint.df.edi.schema.EdifactSchemaDefs;
import com.anypoint.df.edi.schema.EdifactStructureConfig;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.Serializable;
import java.util.Map;
import org.mule.modules.edi.edifact.DirectEnvelopeHandler;
import org.mule.modules.edi.edifact.EdifactEdiModule;

class B2BProviderEnvelopeHandler
extends DirectEnvelopeHandler {
    private B2BProvider b2bProvider;
    private Factory<QueryObject> queryObjectFactory;
    private String interchangeIdQualifierPartner;
    private String interchangeIdPartner;
    private String groupIdPartner;
    private String groupIdQualifierPartner;
    private String interchangeIdQualifierSelf;
    private String interchangeIdSelf;
    private String groupIdSelf;
    private String groupIdQualifierSelf;

    public B2BProviderEnvelopeHandler(B2BProvider b2bProvider, EdifactEdiModule ediModule) throws Exception {
        super(ediModule);
        this.b2bProvider = b2bProvider;
        this.queryObjectFactory = b2bProvider.getFactoryResolver().getFactory(QueryObject.class);
    }

    @Override
    public Object handleUnb(Map<String, Object> map) throws LexicalException {
        this.interchangeIdQualifierPartner = this.ediModule.getInterchangeIdQualifierPartner() != null ? this.ediModule.getInterchangeIdQualifierPartner() : B2BProviderEnvelopeHandler.optionalString((Object)EdifactSchemaDefs.interHeadSenderQualKey(), map);
        this.interchangeIdPartner = this.ediModule.getInterchangeIdPartner() != null ? this.ediModule.getInterchangeIdPartner() : B2BProviderEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.interHeadSenderIdentKey(), map);
        this.groupIdPartner = this.ediModule.getGroupIdPartner();
        this.groupIdQualifierPartner = this.ediModule.getGroupIdQualifierPartner();
        this.interchangeIdQualifierSelf = this.ediModule.getInterchangeIdQualifierSelf() != null ? this.ediModule.getInterchangeIdQualifierSelf() : B2BProviderEnvelopeHandler.optionalString((Object)EdifactSchemaDefs.interHeadRecipientQualKey(), map);
        this.interchangeIdSelf = this.ediModule.getInterchangeIdSelf() != null ? this.ediModule.getInterchangeIdSelf() : B2BProviderEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.interHeadRecipientIdentKey(), map);
        this.groupIdSelf = this.ediModule.getGroupIdSelf();
        this.groupIdQualifierSelf = this.ediModule.getGroupIdQualifierSelf();
        QueryObject configQueryObject = (QueryObject)this.queryObjectFactory.create();
        configQueryObject.put((Object)"interchangeReceiverId", (Object)this.interchangeIdSelf);
        configQueryObject.put((Object)"interchangeReceiverIdQualifier", (Object)this.interchangeIdQualifierSelf);
        configQueryObject.put((Object)"applicationReceiverId", (Object)this.groupIdSelf);
        configQueryObject.put((Object)"applicationReceiverIdQualifier", (Object)this.groupIdQualifierSelf);
        configQueryObject.put((Object)"interchangeSenderId", (Object)this.interchangeIdPartner);
        configQueryObject.put((Object)"interchangeSenderIdQualifier", (Object)this.interchangeIdQualifierPartner);
        configQueryObject.put((Object)"applicationSenderId", (Object)this.groupIdPartner);
        configQueryObject.put((Object)"applicationSenderIdQualifier", (Object)this.groupIdQualifierPartner);
        Config b2bProviderConfig = this.ediModule.getB2BProviderConfig(configQueryObject, Direction.INBOUND);
        if (b2bProviderConfig != null) {
            this.doHandleUnb(Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"requireUniqueGroupNumbers")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"requireUniqueMessageNumbers")).toString()), map);
            String controlRef = B2BProviderEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.interHeadReferenceKey(), map);
            if (Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"requireUniqueInterchangeReferences")).toString()).booleanValue()) {
                this.assertNotDuplicateInterchange(this.interchangeIdSelf, this.interchangeIdQualifierSelf, this.groupIdSelf, this.groupIdQualifierSelf, this.interchangeIdPartner, this.interchangeIdQualifierPartner, this.groupIdPartner, this.groupIdQualifierPartner, controlRef);
            }
            return this.createEdifactParserConfig(b2bProviderConfig);
        }
        logger.error("Queried registered B2B Provider for UNB segment EDIFACT read config but none was found. Check your configuration. Lookup key used was: " + configQueryObject.toString());
        throw new EdifactInterchangeException(EdifactAcknowledgment.NoAgreementForValue(), "Interchange sender/recipient information does not match configuration", null);
    }

    private void assertNotDuplicateInterchange(String interchangeIdSelf, String interchangeIdQualifierSelf, String groupIdSelf, String groupIdQualifierSelf, String interchangeIdPartner, String interchangeIdQualifierPartner, String groupIdPartner, String groupIdQualifierPartner, String controlRef) {
        QueryObject transmissionQueryObject = (QueryObject)this.queryObjectFactory.create();
        transmissionQueryObject.put((Object)"interchangeReceiverId", (Object)interchangeIdSelf);
        transmissionQueryObject.put((Object)"interchangeReceiverIdQualifier", (Object)interchangeIdQualifierSelf);
        transmissionQueryObject.put((Object)"applicationReceiverId", (Object)groupIdSelf);
        transmissionQueryObject.put((Object)"applicationReceiverIdQualifier", (Object)groupIdQualifierSelf);
        transmissionQueryObject.put((Object)"interchangeSenderId", (Object)interchangeIdPartner);
        transmissionQueryObject.put((Object)"interchangeSenderIdQualifier", (Object)interchangeIdQualifierPartner);
        transmissionQueryObject.put((Object)"applicationSenderId", (Object)groupIdPartner);
        transmissionQueryObject.put((Object)"applicationSenderIdQualifier", (Object)groupIdQualifierPartner);
        transmissionQueryObject.put((Object)"interchangeControlReference", (Object)controlRef);
        try {
            if (this.b2bProvider.readTransmission(Direction.INBOUND, TransmissionType.EDIFACT, transmissionQueryObject) != null) {
                String text = "Duplicate interchange control reference " + controlRef;
                logger.error(text);
                throw new EdifactInterchangeException(EdifactAcknowledgment.DuplicateDetected(), text, null);
            }
        }
        catch (B2BProviderException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EdifactInterchangeException(EdifactAcknowledgment.UnspecifiedError(), e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object handleUnh(Map<String, Object> map) {
        String messageVersion = B2BProviderEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.msgHeadMessageVersionKey(), map) + B2BProviderEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.msgHeadMessageReleaseKey(), map);
        QueryObject configQueryObject = (QueryObject)this.queryObjectFactory.create();
        configQueryObject.put((Object)"interchangeReceiverId", (Object)this.interchangeIdSelf);
        configQueryObject.put((Object)"interchangeReceiverIdQualifier", (Object)this.interchangeIdQualifierSelf);
        configQueryObject.put((Object)"applicationReceiverId", (Object)this.groupIdSelf);
        configQueryObject.put((Object)"applicationReceiverIdQualifier", (Object)this.groupIdQualifierSelf);
        configQueryObject.put((Object)"interchangeSenderId", (Object)this.interchangeIdPartner);
        configQueryObject.put((Object)"interchangeSenderIdQualifier", (Object)this.interchangeIdQualifierPartner);
        configQueryObject.put((Object)"applicationSenderId", (Object)this.groupIdPartner);
        configQueryObject.put((Object)"applicationSenderIdQualifier", (Object)this.groupIdQualifierPartner);
        configQueryObject.put((Object)"version", (Object)messageVersion);
        configQueryObject.put((Object)"messageType", (Object)B2BProviderEnvelopeHandler.requiredString((Object)EdifactSchemaDefs.msgHeadMessageTypeKey(), map));
        Config b2bProviderConfig = this.ediModule.getB2BProviderConfig(configQueryObject, Direction.INBOUND);
        if (b2bProviderConfig != null) {
            Object edifactAckElseStructure = this.doHandleUnh(Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"requireUniqueMessageNumbers")).toString()), map);
            if (edifactAckElseStructure instanceof EdiSchema.Structure) {
                EdiSchema.Structure structure = (EdiSchema.Structure)edifactAckElseStructure;
                return new EdifactStructureConfig(structure, this.createEdifactParserConfig(b2bProviderConfig));
            }
            Object edifactAck = edifactAckElseStructure;
            return edifactAck;
        }
        logger.error("Queried registered B2B Provider for UNH segment EDIFACT read config but none was found. Check your configuration. Lookup key used was: " + configQueryObject.toString());
        throw new EdifactInterchangeException(EdifactAcknowledgment.NoAgreementForValue(), "Interchange sender/recipient information does not match configuration", null);
    }

    private EdifactParserConfig createEdifactParserConfig(Config b2bProviderConfig) {
        Character subChar = null;
        if (b2bProviderConfig.get((Object)"stringSubstitutionChar") != null) {
            subChar = new Character(((Serializable)b2bProviderConfig.get((Object)"stringSubstitutionChar")).toString().charAt(0));
        }
        return new EdifactParserConfig(Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"valueLengthErrorFail")).toString()).booleanValue(), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"invalidCharacterInValueFail")).toString()).booleanValue(), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"wrongValuesRepeatsFail")).toString()).booleanValue(), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"unknownSegmentFail")).toString()).booleanValue(), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"segmentOutOfOrderFail")).toString()).booleanValue(), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"unusedSegmentPresentFail")).toString()).booleanValue(), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"wrongSegmentsRepeatsFail")).toString()).booleanValue(), Boolean.valueOf(((Serializable)b2bProviderConfig.get((Object)"invalidCharacterInValueFail")).toString()).booleanValue(), subChar == null ? -1 : (int)subChar.charValue());
    }
}

