
package org.mule.modules.edi.edifact.processors;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transport.OutputHandler;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.modules.edi.edifact.EdifactEdiModule;
import org.mule.security.oauth.callback.ProcessCallback;


/**
 * WriteMessageProcessor invokes the {@link org.mule.modules.edi.edifact.EdifactEdiModule#write(java.util.Map, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, org.mule.api.MuleEvent)} method in {@link EdifactEdiModule }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.6.0", date = "2015-11-03T03:42:51-06:00", comments = "Build UNNAMED.2363.ef5c8a7")
public class WriteMessageProcessor
    extends DevkitBasedMessageProcessor
    implements MessageProcessor, OperationMetaDataEnabled
{

    protected Object map;
    protected Map<String, Object> _mapType;
    protected Object interSelfIdent;
    protected String _interSelfIdentType;
    protected Object interSelfQual;
    protected String _interSelfQualType;
    protected Object grpSelfIdent;
    protected String _grpSelfIdentType;
    protected Object grpSelfQual;
    protected String _grpSelfQualType;
    protected Object interPartnerIdent;
    protected String _interPartnerIdentType;
    protected Object interPartnerQual;
    protected String _interPartnerQualType;
    protected Object grpPartnerIdent;
    protected String _grpPartnerIdentType;
    protected Object grpPartnerQual;
    protected String _grpPartnerQualType;
    protected Object event;
    protected MuleEvent _eventType;

    public WriteMessageProcessor(String operationName) {
        super(operationName);
    }

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    @Override
    public void start()
        throws MuleException
    {
        super.start();
    }

    @Override
    public void stop()
        throws MuleException
    {
        super.stop();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    /**
     * Sets interPartnerQual
     * 
     * @param value Value to set
     */
    public void setInterPartnerQual(Object value) {
        this.interPartnerQual = value;
    }

    /**
     * Sets interPartnerIdent
     * 
     * @param value Value to set
     */
    public void setInterPartnerIdent(Object value) {
        this.interPartnerIdent = value;
    }

    /**
     * Sets grpSelfIdent
     * 
     * @param value Value to set
     */
    public void setGrpSelfIdent(Object value) {
        this.grpSelfIdent = value;
    }

    /**
     * Sets interSelfQual
     * 
     * @param value Value to set
     */
    public void setInterSelfQual(Object value) {
        this.interSelfQual = value;
    }

    /**
     * Sets grpSelfQual
     * 
     * @param value Value to set
     */
    public void setGrpSelfQual(Object value) {
        this.grpSelfQual = value;
    }

    /**
     * Sets interSelfIdent
     * 
     * @param value Value to set
     */
    public void setInterSelfIdent(Object value) {
        this.interSelfIdent = value;
    }

    /**
     * Sets grpPartnerIdent
     * 
     * @param value Value to set
     */
    public void setGrpPartnerIdent(Object value) {
        this.grpPartnerIdent = value;
    }

    /**
     * Sets event
     * 
     * @param value Value to set
     */
    public void setEvent(Object value) {
        this.event = value;
    }

    /**
     * Sets map
     * 
     * @param value Value to set
     */
    public void setMap(Object value) {
        this.map = value;
    }

    /**
     * Sets grpPartnerQual
     * 
     * @param value Value to set
     */
    public void setGrpPartnerQual(Object value) {
        this.grpPartnerQual = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws Exception
     */
    public MuleEvent doProcess(final MuleEvent event)
        throws Exception
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(null, false, event);
            final Map<String, Object> _transformedMap = ((Map<String, Object> ) evaluateAndTransform(getMuleContext(), event, WriteMessageProcessor.class.getDeclaredField("_mapType").getGenericType(), null, map));
            final String _transformedInterSelfIdent = ((String) evaluateAndTransform(getMuleContext(), event, WriteMessageProcessor.class.getDeclaredField("_interSelfIdentType").getGenericType(), null, interSelfIdent));
            final String _transformedInterSelfQual = ((String) evaluateAndTransform(getMuleContext(), event, WriteMessageProcessor.class.getDeclaredField("_interSelfQualType").getGenericType(), null, interSelfQual));
            final String _transformedGrpSelfIdent = ((String) evaluateAndTransform(getMuleContext(), event, WriteMessageProcessor.class.getDeclaredField("_grpSelfIdentType").getGenericType(), null, grpSelfIdent));
            final String _transformedGrpSelfQual = ((String) evaluateAndTransform(getMuleContext(), event, WriteMessageProcessor.class.getDeclaredField("_grpSelfQualType").getGenericType(), null, grpSelfQual));
            final String _transformedInterPartnerIdent = ((String) evaluateAndTransform(getMuleContext(), event, WriteMessageProcessor.class.getDeclaredField("_interPartnerIdentType").getGenericType(), null, interPartnerIdent));
            final String _transformedInterPartnerQual = ((String) evaluateAndTransform(getMuleContext(), event, WriteMessageProcessor.class.getDeclaredField("_interPartnerQualType").getGenericType(), null, interPartnerQual));
            final String _transformedGrpPartnerIdent = ((String) evaluateAndTransform(getMuleContext(), event, WriteMessageProcessor.class.getDeclaredField("_grpPartnerIdentType").getGenericType(), null, grpPartnerIdent));
            final String _transformedGrpPartnerQual = ((String) evaluateAndTransform(getMuleContext(), event, WriteMessageProcessor.class.getDeclaredField("_grpPartnerQualType").getGenericType(), null, grpPartnerQual));
            Object resultPayload;
            final ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class<? extends Exception>> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((EdifactEdiModule) object).write(_transformedMap, _transformedInterSelfIdent, _transformedInterSelfQual, _transformedGrpSelfIdent, _transformedGrpSelfQual, _transformedInterPartnerIdent, _transformedInterPartnerQual, _transformedGrpPartnerIdent, _transformedGrpPartnerQual, event);
                }

            }
            , this, event);
            event.getMessage().setPayload(resultPayload);
            return event;
        } catch (Exception e) {
            throw e;
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        DefaultMetaDataKey metaDataKey = new DefaultMetaDataKey("OutMessage", null);
        metaDataKey.setCategory("EdifactEdiMetaData");
        metaDataKey.addProperty(new TypeDescribingProperty(TypeDescribingProperty.TypeScope.INPUT, "write"));
        Result<MetaData> genericMetaData = getGenericMetaData(metaDataKey);
        if ((Result.Status.FAILURE).equals(genericMetaData.getStatus())) {
            return genericMetaData;
        }
        return new DefaultResult<MetaData>(new DefaultMetaData(genericMetaData.get().getPayload()));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult<MetaData>(new DefaultMetaData(getPojoOrSimpleModel(OutputHandler.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        ConnectorMetaDataEnabled connector;
        try {
            connector = ((ConnectorMetaDataEnabled) findOrCreate(null, false, null));
            try {
                Result<MetaData> metadata = connector.getMetaData(metaDataKey);
                if ((Result.Status.FAILURE).equals(metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), "There was an error processing metadata at EdifactEdiModule at write retrieving was successful but result is null");
                }
                return metadata;
            } catch (Exception e) {
                return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
            }
        } catch (ClassCastException cast) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        } catch (ConfigurationException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (RegistrationException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (IllegalAccessException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (InstantiationException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (Exception e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        }
    }

}
