/**
 * (c) 2003-2014 MuleSoft, Inc. The software in this package is published under the terms of the CPAL v1.0 license, a
 * copy of which has been included with this distribution in the LICENSE.md file.
 */

package org.mule.modules.edi.edifact;

import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.DynamicObjectFieldBuilder;
import org.mule.common.metadata.datatype.DataType;
import org.mule.modules.edi.EdiMetaDataBuilder;

import scala.collection.convert.WrapAsJava$;

import com.anypoint.df.edi.lexical.EdifactConstants.SyntaxVersion;
import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdiSchema.Structure;
import com.anypoint.df.edi.schema.EdifactSchemaDefs;
import com.anypoint.df.edi.schema.SchemaJavaValues;
import com.anypoint.df.edi.schema.EdifactError;

/**
 * Build metadata for X12 messages.
 *
 * @author MuleSoft, Inc.
 */
public class EdifactMetaDataBuilder extends EdiMetaDataBuilder
{
    private final SyntaxVersion syntaxVersion;
    
    public EdifactMetaDataBuilder(SyntaxVersion syntax, EdiSchema schema) {
        super(schema);
        syntaxVersion = syntax;
    }

    private void addErrors(DynamicObjectBuilder<?> container) {
        container.addList(SchemaJavaValues.errorListKey()).ofPojo(EdifactError.class);
    }

    private void addInterchangeHeader(DynamicObjectBuilder<?> container, boolean errors) {
        DynamicObjectFieldBuilder<?> inter = container.addDynamicObjectField(SchemaJavaValues.interchangeKey());
        buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(EdifactSchemaDefs.unbSegment(syntaxVersion).
            components()), inter);
        if (errors) {
            addErrors(inter);
        }
    }

    /**
     * Build metadata for a schema.
     *
     * @param root
     * @param read
     */
    public void build(DynamicObjectBuilder<?> root, boolean read) {
        Structure contrl = EdifactSchemaDefs.contrlMsg(syntaxVersion);
        if (read) {
            root.addSimpleField(SchemaJavaValues.delimiterCharacters(), DataType.STRING);
            DynamicObjectBuilder<?> ackMap1 = root.addList(SchemaJavaValues.functionalAcksGenerated()).
                ofDynamicObject(contrl.ident());
            buildStructure(contrl, false, ackMap1);
            DynamicObjectBuilder<?> ackMap2 = root.addList(EdifactSchemaDefs.functionalAcksReceived()).
                ofDynamicObject(contrl.ident());
            buildStructure(contrl, true, ackMap2);
            addErrors(root);
        } else {
            DynamicObjectBuilder<?> ackMap1 = root.addList(EdifactSchemaDefs.functionalAcksToSend()).
                ofDynamicObject(contrl.ident());
            buildStructure(contrl, false, ackMap1);
            addInterchangeHeader(root, false);
        }
        DynamicObjectFieldBuilder<?> verMap = root.addDynamicObjectField(EdifactSchemaDefs.messagesMap());
        buildStructures(verMap, schema.ediVersion().version().toUpperCase(), read);
    }

    /**
     * Build metadata for a message.
     *
     * @param transaction
     * @param addErrors
     * @param container
     */
    protected void buildStructure(Structure structure, boolean addErrors, DynamicObjectBuilder<?> container) {
        addInterchangeHeader(container, addErrors);
        if (addErrors) {
            addErrors(container);
        }
        DynamicObjectFieldBuilder<?> msg = container.addDynamicObjectField(EdifactSchemaDefs.messageHeaderKey());
        buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(EdifactSchemaDefs.unhSegment(syntaxVersion).
            components()), msg);
        buildStructureDetails(structure, container);
    }
}