
package org.mule.modules.edi.edifact;

import java.util.List;

import javax.inject.Inject;

import org.mule.api.annotations.MetaDataKeyRetriever;
import org.mule.api.annotations.MetaDataRetriever;
import org.mule.api.annotations.components.MetaDataCategory;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.modules.edi.BaseEdiMetaData;

/**
 * Metadata class for EDIFACT connector.
 */
@MetaDataCategory
public class EdifactEdiMetaData extends BaseEdiMetaData
{
    @Inject
    protected EdifactEdiModule module;

    @Override
    public EdifactEdiModule getModule() {
        return module;
    }

    public void setModule(EdifactEdiModule module) {
        this.module = module;
    }

    @MetaDataKeyRetriever
    @Override
    public List<MetaDataKey> getMetaDataKeys() {
        return getStandardMetaDataKeys();
    }

    @MetaDataRetriever
    @Override
    public MetaData getMetaData(MetaDataKey metaDataKey) {
        DynamicObjectBuilder<?> dynamicObject = new DefaultMetaDataBuilder().createDynamicObject(metaDataKey.getId());

        if ("InMessage".equals(metaDataKey.getId())) {
            new EdifactMetaDataBuilder(module.getSendSyntaxVersion(), module.getCombinedSchema()).build(dynamicObject, true);
        } else if ("OutMessage".equals(metaDataKey.getId())) {
            new EdifactMetaDataBuilder(module.getSendSyntaxVersion(), module.getCombinedSchema()).build(dynamicObject, false);
        }

        // Create Map metadata model
        MetaDataModel model = dynamicObject.build();
        return new DefaultMetaData(model);
    }
}