package org.mule.modules.edi.edifact;

import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.schema.*;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.TransmissionType;

import java.util.Map;

class B2BProviderEnvelopeHandler extends DirectEnvelopeHandler {

    private B2BProvider b2bProvider;
    private Factory<QueryObject> queryObjectFactory;

    private String interchangeIdQualifierPartner;
    private String interchangeIdPartner;
    private String groupIdPartner;
    private String groupIdQualifierPartner;

    private String interchangeIdQualifierSelf;
    private String interchangeIdSelf;
    private String groupIdSelf;
    private String groupIdQualifierSelf;

    public B2BProviderEnvelopeHandler(B2BProvider b2bProvider, EdifactEdiModule ediModule) throws Exception {
        super(ediModule);
        this.b2bProvider = b2bProvider;
        queryObjectFactory = b2bProvider.getFactoryResolver().getFactory(QueryObject.class);
    }

    @Override
    public Object handleUnb(Map<String, Object> map) throws LexicalException {
        interchangeIdQualifierPartner = ediModule.getInterchangeIdQualifierPartner() != null ? ediModule.getInterchangeIdQualifierPartner() : optionalString(EdifactSchemaDefs.interHeadSenderQualKey(), map);
        interchangeIdPartner = ediModule.getInterchangeIdPartner() != null ? ediModule.getInterchangeIdPartner() : requiredString(EdifactSchemaDefs.interHeadSenderIdentKey(), map);
        groupIdPartner = ediModule.getGroupIdPartner();
        groupIdQualifierPartner = ediModule.getGroupIdQualifierPartner();

        interchangeIdQualifierSelf = ediModule.getInterchangeIdQualifierSelf() != null ? ediModule.getInterchangeIdQualifierSelf() : optionalString(EdifactSchemaDefs.interHeadRecipientQualKey(), map);
        interchangeIdSelf = ediModule.getInterchangeIdSelf() != null ? ediModule.getInterchangeIdSelf() : requiredString(EdifactSchemaDefs.interHeadRecipientIdentKey(), map);
        groupIdSelf = ediModule.getGroupIdSelf();
        groupIdQualifierSelf = ediModule.getGroupIdQualifierSelf();

        QueryObject configQueryObject = queryObjectFactory.create();
        configQueryObject.put("interchangeReceiverId", interchangeIdSelf);
        configQueryObject.put("interchangeReceiverIdQualifier", interchangeIdQualifierSelf);
        configQueryObject.put("applicationReceiverId", groupIdSelf);
        configQueryObject.put("applicationReceiverIdQualifier", groupIdQualifierSelf);
        configQueryObject.put("interchangeSenderId", interchangeIdPartner);
        configQueryObject.put("interchangeSenderIdQualifier", interchangeIdQualifierPartner);
        configQueryObject.put("applicationSenderId", groupIdPartner);
        configQueryObject.put("applicationSenderIdQualifier", groupIdQualifierPartner);

        Config b2bProviderConfig = ediModule.getB2BProviderConfig(configQueryObject, Direction.INBOUND);

        if (b2bProviderConfig != null) {
            doHandleUnb(Boolean.valueOf(b2bProviderConfig.get("requireUniqueGroupNumbers").toString()),
                        Boolean.valueOf(b2bProviderConfig.get("requireUniqueMessageNumbers").toString()), map);

            String controlRef = requiredString(EdifactSchemaDefs.interHeadReferenceKey(), map);
            if (Boolean.valueOf(b2bProviderConfig.get("requireUniqueInterchangeReferences").toString())) {
                assertNotDuplicateInterchange(interchangeIdSelf, interchangeIdQualifierSelf, groupIdSelf, groupIdQualifierSelf,
                        interchangeIdPartner, interchangeIdQualifierPartner, groupIdPartner, groupIdQualifierPartner, controlRef);
            }

            return createEdifactParserConfig(b2bProviderConfig);
        } else {
            logger.error("Queried registered B2B Provider for UNB segment EDIFACT read config but none was found. Check your configuration. Lookup key used was: " + configQueryObject.toString());
            throw new EdifactInterchangeException(EdifactAcknowledgment.NoAgreementForValue(), "Interchange sender/recipient information does not match configuration", null);
        }
    }

    private void assertNotDuplicateInterchange(String interchangeIdSelf, String interchangeIdQualifierSelf,
                                               String groupIdSelf, String groupIdQualifierSelf, String interchangeIdPartner,
                                               String interchangeIdQualifierPartner, String groupIdPartner, String groupIdQualifierPartner,
                                               String controlRef) {

        QueryObject transmissionQueryObject = queryObjectFactory.create();
        transmissionQueryObject.put("interchangeReceiverId", interchangeIdSelf);
        transmissionQueryObject.put("interchangeReceiverIdQualifier", interchangeIdQualifierSelf);
        transmissionQueryObject.put("applicationReceiverId", groupIdSelf);
        transmissionQueryObject.put("applicationReceiverIdQualifier", groupIdQualifierSelf);
        transmissionQueryObject.put("interchangeSenderId", interchangeIdPartner);
        transmissionQueryObject.put("interchangeSenderIdQualifier", interchangeIdQualifierPartner);
        transmissionQueryObject.put("applicationSenderId", groupIdPartner);
        transmissionQueryObject.put("applicationSenderIdQualifier", groupIdQualifierPartner);
        transmissionQueryObject.put("interchangeControlReference", controlRef);

        try {
            if (b2bProvider.readTransmission(Direction.INBOUND, TransmissionType.EDIFACT, transmissionQueryObject) != null) {
                String text = "Duplicate interchange control reference " + controlRef;
                logger.error(text);
                throw new EdifactInterchangeException(EdifactAcknowledgment.DuplicateDetected(), text, null);
            }
        } catch (B2BProviderException e) {
            logger.error(e.getMessage(), e);
            throw new EdifactInterchangeException(EdifactAcknowledgment.UnspecifiedError(), e.getMessage(), e);
        }
    }

    @Override
    public Object handleUnh(Map<String, Object> map) {
        String messageVersion = requiredString(EdifactSchemaDefs.msgHeadMessageVersionKey(), map) + requiredString(EdifactSchemaDefs.msgHeadMessageReleaseKey(), map);

        QueryObject configQueryObject = queryObjectFactory.create();
        configQueryObject.put("interchangeReceiverId", interchangeIdSelf);
        configQueryObject.put("interchangeReceiverIdQualifier", interchangeIdQualifierSelf);
        configQueryObject.put("applicationReceiverId", groupIdSelf);
        configQueryObject.put("applicationReceiverIdQualifier", groupIdQualifierSelf);
        configQueryObject.put("interchangeSenderId", interchangeIdPartner);
        configQueryObject.put("interchangeSenderIdQualifier", interchangeIdQualifierPartner);
        configQueryObject.put("applicationSenderId", groupIdPartner);
        configQueryObject.put("applicationSenderIdQualifier", groupIdQualifierPartner);
        configQueryObject.put("version", messageVersion);
        configQueryObject.put("messageType", requiredString(EdifactSchemaDefs.msgHeadMessageTypeKey(), map));

        Config b2bProviderConfig = ediModule.getB2BProviderConfig(configQueryObject, Direction.INBOUND);

        if (b2bProviderConfig != null) {
            Object edifactAckElseStructure = doHandleUnh(Boolean.valueOf(b2bProviderConfig.get("requireUniqueMessageNumbers").toString()), map);

            if (edifactAckElseStructure instanceof EdiSchema.Structure) {
                EdiSchema.Structure structure = (EdiSchema.Structure) edifactAckElseStructure;
                return new EdifactStructureConfig(structure, createEdifactParserConfig(b2bProviderConfig));
            } else {
                Object edifactAck = edifactAckElseStructure;
                return edifactAck;
            }
        }
        else {
            logger.error("Queried registered B2B Provider for UNH segment EDIFACT read config but none was found. Check your configuration. Lookup key used was: " + configQueryObject.toString());
            throw new EdifactInterchangeException(EdifactAcknowledgment.NoAgreementForValue(), "Interchange sender/recipient information does not match configuration", null);
        }
    }

    private EdifactParserConfig createEdifactParserConfig(Config b2bProviderConfig) {
        Character subChar = null;
        if (b2bProviderConfig.get("stringSubstitutionChar") != null) {
            subChar = new Character(b2bProviderConfig.get("stringSubstitutionChar").toString().charAt(0));
        }

        return new EdifactParserConfig(Boolean.valueOf(b2bProviderConfig.get("valueLengthErrorFail").toString()), Boolean.valueOf(b2bProviderConfig.get("invalidCharacterInValueFail").toString()),
                Boolean.valueOf(b2bProviderConfig.get("wrongValuesRepeatsFail").toString()), Boolean.valueOf(b2bProviderConfig.get("unknownSegmentFail").toString()),
                Boolean.valueOf(b2bProviderConfig.get("segmentOutOfOrderFail").toString()), Boolean.valueOf(b2bProviderConfig.get("unusedSegmentPresentFail").toString()),
                Boolean.valueOf(b2bProviderConfig.get("wrongSegmentsRepeatsFail").toString()), Boolean.valueOf(b2bProviderConfig.get("invalidCharacterInValueFail").toString()),
                subChar == null ? -1 : subChar.charValue());

    }

}
