/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Task;
import com.anaplan.client.TaskStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnaplanUtil {
    private static Logger logger = LogManager.getLogger((String)AnaplanUtil.class.getName());

    private AnaplanUtil() {
    }

    public static String debugOutput(String[] toprint) {
        StringBuilder sb = new StringBuilder();
        for (String s : toprint) {
            sb.append(s);
            sb.append("||");
        }
        if (sb.length() > 1) {
            return sb.toString().substring(0, sb.length() - 1);
        }
        return "*";
    }

    public static TaskStatus runServerTask(Task task) throws AnaplanAPIException {
        TaskStatus status = task.getStatus();
        logger.info("TASK STATUS: {}", new Object[]{status.getTaskState()});
        while (status.getTaskState() != TaskStatus.State.COMPLETE && status.getTaskState() != TaskStatus.State.CANCELLED) {
            try {
                Thread.sleep(1000L);
                logger.debug("Running Task = {}", new Object[]{task.getStatus().getProgress()});
            }
            catch (InterruptedException e) {
                logger.error("Task interrupted!\n{}", new Object[]{e.getMessage()});
            }
            status = task.getStatus();
        }
        return status;
    }
}

