/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.connection;

import com.anaplan.client.Service;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanConnectionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;

public class BaseConnectionStrategy {
    private static final Logger logger = LogManager.getLogger((String)BaseConnectionStrategy.class.getName());
    protected AnaplanConnection apiConn;

    public AnaplanConnection getApiConnection() {
        return this.apiConn;
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.apiConn.closeConnection();
            this.apiConn = null;
        } else {
            logger.error("No connStrategy to disconnect!");
        }
    }

    public boolean isConnected() {
        return this.apiConn != null;
    }

    public String connectionId() {
        if (this.isConnected()) {
            return this.apiConn.getConnectionId();
        }
        return "Not connected!";
    }

    protected synchronized void connectToApi() throws ConnectionException {
        Service service;
        try {
            service = this.apiConn.openConnection();
        }
        catch (AnaplanConnectionException e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, e.getMessage(), (Throwable)e);
        }
        if (service == null) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, "No service object acquired after opening connStrategy to Anaplan API!", null);
        }
        logger.info("Successfully connected to Anaplan API!");
    }

    public void validateConnection() throws AnaplanConnectionException {
        if (this.isConnected()) {
            if (this.apiConn.getConnection() == null) {
                this.apiConn.openConnection();
            } else {
                logger.info("Connection to API exists. Proceeding...");
            }
        } else {
            throw new AnaplanConnectionException("No connStrategy object: call connect()");
        }
    }
}

