/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.connection;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Credentials;
import com.anaplan.client.Service;
import com.anaplan.connector.AnaplanConnectorProperties;
import com.anaplan.connector.exceptions.AnaplanConnectionException;
import com.anaplan.connector.exceptions.ConnectorPropertiesException;
import com.anaplan.connector.utils.UserMessages;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnaplanConnection {
    private static final Logger logger = LogManager.getLogger((String)AnaplanConnection.class.getName());
    private static final String USERNAME_FIELD = "username";
    private static final String PASSWORD_FIELD = "password";
    private static final String URL_FIELD = "url";
    private static final String CERT_PATH = "certPath";
    private static final String URL_PROXY = "proxyHost";
    private static final String URL_PROXY_USER = "proxyUser";
    private static final String URL_PROXY_PASS = "proxyPass";
    private final AnaplanConnectorProperties connectionConfig;
    private final boolean isCertificate;
    private Service openConnection = null;

    public AnaplanConnection(boolean isCertificate, String ... credentials) {
        logger.debug("NOTICE: {} @ {}", new Object[]{credentials[0], credentials[2]});
        this.isCertificate = isCertificate;
        this.connectionConfig = new AnaplanConnectorProperties();
        try {
            if (isCertificate) {
                this.connectionConfig.setProperties(credentials, CERT_PATH, URL_FIELD, URL_PROXY, URL_PROXY_USER, URL_PROXY_PASS);
            } else {
                this.connectionConfig.setProperties(credentials, USERNAME_FIELD, PASSWORD_FIELD, URL_FIELD, URL_PROXY, URL_PROXY_USER, URL_PROXY_PASS);
            }
        }
        catch (ConnectorPropertiesException e) {
            logger.error("Could not set connector properties!", (Throwable)e);
        }
        logger.info("Stored connection properties!");
    }

    public String getConnectionId() {
        return this.toString();
    }

    public X509Certificate readCertificate(String certificateLocation) throws AnaplanConnectionException {
        BufferedInputStream buffStream = null;
        X509Certificate x509 = null;
        try {
            buffStream = new BufferedInputStream(new FileInputStream(certificateLocation));
            Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(buffStream);
            if (cert instanceof X509Certificate) {
                x509 = (X509Certificate)cert;
                logger.info("Certificate VALID!");
                logger.debug(x509.toString());
            }
        }
        catch (CertificateException e) {
            throw new AnaplanConnectionException("Bad certificate", e);
        }
        catch (IOException e) {
            throw new AnaplanConnectionException("Could not open certificate", e);
        }
        catch (Throwable e) {
            throw new AnaplanConnectionException("Unknown exception occurred", e);
        }
        finally {
            if (buffStream != null) {
                try {
                    buffStream.close();
                }
                catch (IOException e) {
                    throw new AnaplanConnectionException(e.getMessage());
                }
            }
        }
        return x509;
    }

    private Service cacheService() throws AnaplanConnectionException {
        List availableWorkspaces;
        Service service;
        block10: {
            logger.debug("Trying Anaplan service connection...");
            String apiUrl = this.connectionConfig.getStringProperty(URL_FIELD);
            logger.debug("API Url: {}", new Object[]{apiUrl});
            try {
                service = new Service(new URI(apiUrl));
            }
            catch (URISyntaxException e) {
                this.closeConnection();
                throw new AnaplanConnectionException(UserMessages.getMessage("invalidApiUri", apiUrl), e);
            }
            String username = this.connectionConfig.getStringProperty(USERNAME_FIELD);
            String password = this.connectionConfig.getStringProperty(PASSWORD_FIELD);
            String certLocation = this.connectionConfig.getStringProperty(CERT_PATH);
            String proxyHost = this.connectionConfig.getStringProperty(URL_PROXY);
            String proxyUser = this.connectionConfig.getStringProperty(URL_PROXY_USER);
            String proxyPass = this.connectionConfig.getStringProperty(URL_PROXY_PASS);
            try {
                Credentials creds = this.isCertificate ? new Credentials(this.readCertificate(certLocation)) : new Credentials(username, password, null, null);
                service.setServiceCredentials(creds);
                if (proxyHost != null && !proxyHost.isEmpty()) {
                    service.setProxyLocation(new URI(proxyHost));
                    if (proxyUser != null && !proxyUser.isEmpty()) {
                        service.setProxyCredentials(new Credentials(proxyUser, proxyPass, null, null));
                        logger.debug("Proxy server configured");
                    }
                }
            }
            catch (AnaplanAPIException | URISyntaxException e) {
                this.closeConnection();
                String msg = UserMessages.getMessage("apiConnectFail", e.getMessage());
                logger.error(msg, e);
                throw new AnaplanConnectionException(msg, e);
            }
            logger.debug("Anaplan service connection information cached.");
            availableWorkspaces = null;
            try {
                availableWorkspaces = service.getWorkspaces();
            }
            catch (AnaplanAPIException e) {
                this.closeConnection();
                logger.error(e.getMessage(), (Throwable)e);
                if (e.getMessage() != null && e.getMessage().toLowerCase().contains("credentials")) break block10;
                String exceptionDetails = e.getMessage();
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    exceptionDetails = exceptionDetails + " (" + e.getCause().getMessage() + ")";
                }
                throw new AnaplanConnectionException(exceptionDetails, e);
            }
        }
        if (availableWorkspaces == null || availableWorkspaces.isEmpty()) {
            String msg = UserMessages.getMessage("accessFail");
            logger.error("{} (availableWorkspaces={})", new Object[]{msg, availableWorkspaces});
            throw new AnaplanConnectionException(msg);
        }
        logger.debug("Anaplan service connection validated successfully");
        this.openConnection = service;
        return service;
    }

    public Service openConnection() throws AnaplanConnectionException {
        logger.info("Establishing connection....");
        if (this.openConnection == null) {
            logger.info("No new connection found, establishing new connection!");
            return this.cacheService();
        }
        logger.info("Connection exists, returning cached connection!");
        return this.openConnection;
    }

    public Service getConnection() {
        return this.openConnection;
    }

    public void closeConnection() {
        if (this.openConnection != null) {
            this.openConnection.close();
        }
        this.openConnection = null;
        logger.info("Connection closed.");
    }
}

