/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellReader;
import com.anaplan.client.ExportMetadata;
import com.anaplan.client.ServerFile;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.OperationStatus;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MulesoftAnaplanResponse
implements Serializable {
    private static Logger logger = LogManager.getLogger((String)MulesoftAnaplanResponse.class.getName());
    private static final long serialVersionUID = 1L;
    private final String responseMessage;
    private final ServerFile serverFile;
    private final ExportMetadata exportMetadata;
    private final OperationStatus status;
    private final Throwable exception;

    private MulesoftAnaplanResponse(String responseMessage, OperationStatus status, ServerFile serverFile, ExportMetadata exportMetaData, Throwable failureCause) {
        this.responseMessage = responseMessage;
        this.status = status;
        this.serverFile = serverFile;
        this.exportMetadata = exportMetaData;
        this.exception = failureCause;
        logger.info("Created {}", new Object[]{this});
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public ServerFile getServerFile() {
        return this.serverFile;
    }

    public ExportMetadata getExportMetadata() {
        return this.exportMetadata;
    }

    public Throwable getException() {
        return this.exception;
    }

    private String writeResponse(CellReader cellReader) throws AnaplanAPIException, IOException {
        StringBuilder sb = new StringBuilder();
        String header = StringUtils.join((Object[])cellReader.getHeaderRow(), (char)',');
        sb.append(header);
        logger.debug("{}", new Object[]{header});
        String dataLine = StringUtils.join((Object[])cellReader.readDataRow(), (char)',');
        while (dataLine != null) {
            sb.append("\n").append(dataLine);
            Object[] dataLineArr = cellReader.readDataRow();
            dataLine = dataLineArr == null ? null : StringUtils.join((Object[])dataLineArr, (char)',');
        }
        logger.debug("finished writing file");
        return sb.toString();
    }

    private String responseServerFile(ServerFile serverFile) throws IOException, AnaplanAPIException {
        if (serverFile == null) {
            throw new AnaplanAPIException("Response is empty: " + (Object)((Object)this.getStatus()));
        }
        CellReader cellReader = serverFile.getDownloadCellReader();
        return this.writeResponse(cellReader);
    }

    public String writeExportData(AnaplanConnection connection) throws IOException, AnaplanAPIException, AnaplanOperationException {
        if (this.getStatus() != OperationStatus.SUCCESS) {
            if (this.getException() == null) {
                MulesoftAnaplanResponse.responseFail(connection, this.getResponseMessage());
            } else {
                MulesoftAnaplanResponse.responseEpicFail(connection, this.getException(), this.getResponseMessage());
            }
        }
        return this.responseServerFile(this.getServerFile());
    }

    public String toString() {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append("AnaplanResponse with status ");
        strBuffer.append(this.status == null ? "null" : this.status.toString());
        strBuffer.append("; message: ");
        strBuffer.append(this.responseMessage == null ? "null" : this.responseMessage);
        strBuffer.append("; serverfile ");
        strBuffer.append(this.serverFile == null ? "null" : this.serverFile.getName());
        return strBuffer.toString();
    }

    public static void responseFail(AnaplanConnection connection, String reason) {
        logger.error("Aborting operation for all documents in request: {}", new Object[]{reason});
    }

    public static void responseEpicFail(AnaplanConnection connection, Throwable e, String reason) throws AnaplanOperationException {
        String msg = reason == null ? "Unexpected operation error: Generating OperationResponse error for " + e.getMessage() : reason + ": " + e.getMessage();
        logger.error(msg, e);
        throw new AnaplanOperationException(e.getMessage());
    }

    public static MulesoftAnaplanResponse exportSuccess(String responseMessage, ServerFile exportOutput, ExportMetadata exportMetadata) throws IllegalArgumentException {
        if (exportOutput == null) {
            logger.error("Discarding response for task: {}", new Object[]{responseMessage});
            throw new IllegalArgumentException("Output cannot be null for a successful export");
        }
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.SUCCESS, exportOutput, exportMetadata, null);
    }

    public static MulesoftAnaplanResponse exportFailure(String responseMessage, ExportMetadata exportMetadata, Throwable cause) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.FAILURE, null, exportMetadata, cause);
    }

    public static MulesoftAnaplanResponse importSuccess(String responseMessage, ServerFile serverFile) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.SUCCESS, serverFile, null, null);
    }

    public static MulesoftAnaplanResponse importFailure(String responseMessage, Throwable cause) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.FAILURE, null, null, cause);
    }

    public static MulesoftAnaplanResponse importWithFailureDump(String responseMessage, ServerFile failDump) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.APPLICATION_ERROR, failDump, null, null);
    }

    public static MulesoftAnaplanResponse executeActionSuccess(String responseMessage) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.SUCCESS, null, null, null);
    }

    public static MulesoftAnaplanResponse executeActionFailure(String responseMessage, Throwable cause) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.FAILURE, null, null, cause);
    }

    public static MulesoftAnaplanResponse runProcessSuccess(String responseMessage) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.SUCCESS, null, null, null);
    }

    public static MulesoftAnaplanResponse runProcessFailure(String responseMessage, Throwable cause) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.FAILURE, null, null, cause);
    }

    public String getDumpFileContents() {
        StringBuilder dumpFileContents = new StringBuilder();
        if (this.serverFile != null) {
            try {
                InputStream dumpFileStream = this.serverFile.getDownloadStream();
                if (dumpFileStream != null) {
                    int read;
                    byte[] buffer = new byte[5];
                    do {
                        if ((read = dumpFileStream.read(buffer)) <= 0) continue;
                        dumpFileContents.append(new String(buffer));
                    } while (read != -1);
                }
            }
            catch (AnaplanAPIException | IOException e) {
                logger.info("No Dump file found. Proceeding...");
            }
        }
        return dumpFileContents.toString();
    }
}

