/**
 * Copyright 2015 Anaplan Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License.md file for the specific language governing permissions and
 * limitations under the License.
 */

package com.anaplan.connector.exceptions;


/**
 * Used for throwing exceptions when errors occur during the authentication
 * phase.
 *
 * @author spondonsaha
 */
public class AnaplanConnectionException extends Exception {

	private static final long serialVersionUID = 1L;

	/**
	 * Creates an exception with the specified messsage
	 * @param message
	 */
	public AnaplanConnectionException(String message) {
		super(message);
	}

	/**
	 * Creates an exception with the specified message and cause
	 * @param message
	 * @param cause
	 */
	public AnaplanConnectionException(String message, Throwable cause) {
		super(message, cause);
	}
}