/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.transport;

import com.anaplan.client.transport.AnaplanAPITransportException;
import com.anaplan.client.transport.TransportProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class TransportProviderFactory {
    private static TransportProviderFactory instance;
    private static final Logger logger;
    private Map<String, Class<? extends TransportProvider>> providers;
    private Class<? extends TransportProvider> defaultProvider;
    private int debugLevel;

    public static synchronized TransportProviderFactory getInstance() throws AnaplanAPITransportException {
        if (instance == null) {
            instance = new TransportProviderFactory();
        }
        return instance;
    }

    private TransportProviderFactory() throws AnaplanAPITransportException {
        block6: {
            this.providers = new HashMap<String, Class<? extends TransportProvider>>();
            String defaultProviderProperty = System.getProperty("anaplan.client.transport.default");
            if (null != defaultProviderProperty) {
                try {
                    Class<TransportProvider> providerClass = Class.forName(defaultProviderProperty).asSubclass(TransportProvider.class);
                    this.providers.put(providerClass.getSimpleName(), providerClass);
                    this.defaultProvider = providerClass;
                }
                catch (Throwable thrown) {
                    throw new AnaplanAPITransportException("Failed to create default transport", thrown);
                }
            }
            try {
                Class<TransportProvider> apacheHTTPProvider = Class.forName("com.anaplan.client.transport.ApacheHttpProvider").asSubclass(TransportProvider.class);
                this.providers.put("ApacheHTTP", apacheHTTPProvider);
                if (null == this.defaultProvider) {
                    this.defaultProvider = apacheHTTPProvider;
                }
            }
            catch (Throwable thrown) {
                if (this.debugLevel <= 0) break block6;
                logger.warning(thrown.toString());
            }
        }
    }

    public TransportProvider createProvider(String name) throws AnaplanAPITransportException {
        try {
            Class<? extends TransportProvider> providerClass = this.providers.get(name);
            if (providerClass == null) {
                return null;
            }
            TransportProvider instance = providerClass.newInstance();
            if (this.debugLevel > 0) {
                instance.setDebugLevel(this.debugLevel);
            }
            return instance;
        }
        catch (Exception exception) {
            throw new AnaplanAPITransportException("Failed to create transport provider(" + name + ")", exception);
        }
    }

    public TransportProvider createDefaultProvider() throws AnaplanAPITransportException {
        try {
            TransportProvider instance = this.defaultProvider.newInstance();
            if (this.debugLevel > 0) {
                instance.setDebugLevel(this.debugLevel);
            }
            return instance;
        }
        catch (Exception exception) {
            throw new AnaplanAPITransportException("Failed to create default transport provider", exception);
        }
    }

    static {
        logger = Logger.getLogger("anaplan-connect.transport");
    }
}

