/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.transport;

import com.anaplan.client.Credentials;
import com.anaplan.client.transport.AnaplanAPITransportException;
import com.anaplan.client.transport.TransportProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class TransportProviderBase
implements TransportProvider {
    private static final Logger logger = Logger.getLogger("anaplan-connect.transport");
    private static ProxySelector defaultProxySelector;
    private URI serviceLocation;
    private Credentials serviceCredentials;
    private URI proxyLocation;
    private Credentials proxyCredentials;
    private ProxySelector proxySelector = defaultProxySelector;
    private String userAgent;
    private int debugLevel;

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @Override
    public void setServiceLocation(URI serviceLocation) throws AnaplanAPITransportException {
        this.serviceLocation = serviceLocation;
    }

    protected URI getServiceLocation() {
        return this.serviceLocation;
    }

    @Override
    public void setServiceCredentials(Credentials serviceCredentials) throws AnaplanAPITransportException {
        this.serviceCredentials = serviceCredentials;
    }

    protected Credentials getServiceCredentials() {
        return this.serviceCredentials;
    }

    @Override
    public void setProxyLocation(URI proxyLocation) throws AnaplanAPITransportException {
        Proxy proxy;
        this.proxyLocation = proxyLocation;
        Proxy.Type proxyType = Proxy.Type.DIRECT;
        InetSocketAddress socketAddress = null;
        if (proxyLocation != null) {
            if ("http".equalsIgnoreCase(proxyLocation.getScheme())) {
                proxyType = Proxy.Type.HTTP;
            } else if ("socks".equalsIgnoreCase(proxyLocation.getScheme())) {
                proxyType = Proxy.Type.SOCKS;
            } else {
                throw new IllegalArgumentException("Unsupported scheme for proxy location URI (must start with http: or socks:): " + proxyLocation.getScheme());
            }
            socketAddress = new InetSocketAddress(proxyLocation.getHost(), proxyLocation.getPort());
            proxy = new Proxy(proxyType, socketAddress);
        } else {
            proxy = Proxy.NO_PROXY;
        }
        this.proxySelector = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.singletonList(proxy);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress socketAddress, IOException ioException) {
            }
        };
    }

    protected URI getProxyLocation() {
        return this.proxyLocation;
    }

    @Override
    public void setProxyCredentials(Credentials proxyCredentials) throws AnaplanAPITransportException {
        if (null == proxyCredentials.getUserName() || proxyCredentials.getUserName().isEmpty()) {
            throw new AnaplanAPITransportException("User name not specified");
        }
        if (null == proxyCredentials.getPassphrase() || proxyCredentials.getPassphrase().isEmpty()) {
            throw new AnaplanAPITransportException("Passphrase not specified");
        }
        this.proxyCredentials = proxyCredentials;
    }

    protected Credentials getProxyCredentials() {
        return this.proxyCredentials;
    }

    protected ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    protected int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public abstract byte[] get(String var1, String var2) throws AnaplanAPITransportException;

    @Override
    public abstract boolean head(String var1) throws AnaplanAPITransportException;

    @Override
    public abstract byte[] post(String var1, byte[] var2, String var3, String var4) throws AnaplanAPITransportException;

    @Override
    public abstract byte[] put(String var1, byte[] var2, String var3) throws AnaplanAPITransportException;

    @Override
    public abstract byte[] delete(String var1, String var2) throws AnaplanAPITransportException;

    @Override
    public abstract void close();

    protected String getRequestPath(String path) {
        StringBuilder result = new StringBuilder(this.serviceLocation.getPath());
        while (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
            result.setLength(result.length() - 1);
        }
        String encodedPath = path;
        try {
            encodedPath = new URI(null, null, path, null).getRawPath();
        }
        catch (URISyntaxException uriSyntaxException) {
            logger.warning("Warning: failed to encode URI path \"" + path + "\": " + uriSyntaxException);
        }
        if (!encodedPath.isEmpty() && encodedPath.charAt(0) != '/') {
            result.append('/');
        }
        return result.append(encodedPath).toString();
    }

    protected byte[] readResponseBody(InputStream inputStream) throws AnaplanAPITransportException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bufferSize = 32768;
            byte[] buffer = new byte[32768];
            int read = 0;
            while (read >= 0) {
                read = inputStream.read(buffer);
                if (read <= 0) continue;
                baos.write(buffer, 0, read);
            }
            inputStream.close();
            return baos.toByteArray();
        }
        catch (IOException ioException) {
            throw new AnaplanAPITransportException("Failed to read response body from server", ioException);
        }
    }

    protected byte[] compress(byte[] source, int offset, int size) throws AnaplanAPITransportException {
        try {
            ByteArrayOutputStream sink = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(sink);
            gzos.write(source, offset, size);
            gzos.close();
            return sink.toByteArray();
        }
        catch (IOException ioException) {
            throw new AnaplanAPITransportException("Failed to compress data for upload", ioException);
        }
    }

    protected byte[] decompress(byte[] source, int offset, int size) throws AnaplanAPITransportException {
        try {
            GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(source, offset, size));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bufferSize = 65536;
            byte[] buffer = new byte[65536];
            int read = 0;
            while (read >= 0) {
                read = gzis.read(buffer);
                if (read <= 0) continue;
                baos.write(buffer, 0, read);
            }
            gzis.close();
            return baos.toByteArray();
        }
        catch (IOException ioException) {
            throw new AnaplanAPITransportException("Failed to decompress downloaded data", ioException);
        }
    }

    static {
        try {
            Class<?> proxySearchClass = Class.forName("com.btr.proxy.search.ProxySearch");
            Method getDefaultProxySearch = proxySearchClass.getMethod("getDefaultProxySearch", new Class[0]);
            Object proxySearchInstance = getDefaultProxySearch.invoke(null, new Object[0]);
            Method getProxySelector = proxySearchClass.getMethod("getProxySelector", new Class[0]);
            defaultProxySelector = (ProxySelector)getProxySelector.invoke(proxySearchInstance, new Object[0]);
        }
        catch (Throwable thrown) {
            defaultProxySelector = ProxySelector.getDefault();
        }
    }
}

