/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.transport;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMEngineException;

public class JCIFSEngine
implements NTLMEngine {
    private static Class<?> NTLM_FLAGS;
    private static Class<?> TYPE_1_MESSAGE;
    private static Class<?> TYPE_2_MESSAGE;
    private static Class<?> TYPE_3_MESSAGE;
    private static Class<?> BASE64;
    private static int TYPE_1_FLAGS;
    private static int NTLMSSP_TARGET_TYPE_DOMAIN;
    private static int NTLMSSP_TARGET_TYPE_SERVER;
    private static final Throwable initFailure;

    JCIFSEngine() throws InvocationTargetException {
        if (null != initFailure) {
            if (initFailure instanceof InvocationTargetException) {
                throw (InvocationTargetException)initFailure;
            }
            throw new InvocationTargetException(initFailure, "Cannot load JCIFSEngine");
        }
    }

    public String generateType1Msg(String domain, String workstation) throws NTLMEngineException {
        try {
            Object type1Message = TYPE_1_MESSAGE.getConstructor(Integer.TYPE, String.class, String.class).newInstance(TYPE_1_FLAGS, domain, workstation);
            byte[] byteArray = (byte[])TYPE_1_MESSAGE.getMethod("toByteArray", new Class[0]).invoke(type1Message, new Object[0]);
            return (String)BASE64.getMethod("encode", byteArray.getClass()).invoke(null, new Object[]{byteArray});
        }
        catch (Exception thrown) {
            throw new NTLMEngineException("Failed to generate NTLM type 1 message", (Throwable)thrown);
        }
    }

    public String generateType3Msg(String username, String password, String domain, String workstation, String challenge) throws NTLMEngineException {
        if (domain == null) {
            throw new NTLMEngineException("Domain must be specified with user name");
        }
        try {
            byte[] byteArray = (byte[])BASE64.getMethod("decode", String.class).invoke(null, challenge);
            Object type2Message = TYPE_2_MESSAGE.getConstructor(byteArray.getClass()).newInstance(new Object[]{byteArray});
            Integer type2Flags = (Integer)TYPE_2_MESSAGE.getMethod("getFlags", new Class[0]).invoke(type2Message, new Object[0]);
            int type3Flags = type2Flags & (0xFFFFFFFF ^ (NTLMSSP_TARGET_TYPE_DOMAIN | NTLMSSP_TARGET_TYPE_SERVER));
            Object type3Message = TYPE_3_MESSAGE.getConstructor(TYPE_2_MESSAGE, String.class, String.class, String.class, String.class, Integer.TYPE).newInstance(type2Message, password, domain, username, workstation, type3Flags);
            byte[] type3ByteArray = (byte[])TYPE_3_MESSAGE.getMethod("toByteArray", new Class[0]).invoke(type3Message, new Object[0]);
            return (String)BASE64.getMethod("encode", type3ByteArray.getClass()).invoke(null, new Object[]{type3ByteArray});
        }
        catch (Exception thrown) {
            throw new NTLMEngineException("Failed to generate NTLM type 3 message", (Throwable)thrown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Throwable failure = null;
        try {
            int type1Flags = 0;
            NTLM_FLAGS = Class.forName("jcifs.ntlmssp.NtlmFlags");
            TYPE_1_MESSAGE = Class.forName("jcifs.ntlmssp.Type1Message");
            TYPE_2_MESSAGE = Class.forName("jcifs.ntlmssp.Type2Message");
            TYPE_3_MESSAGE = Class.forName("jcifs.ntlmssp.Type3Message");
            BASE64 = Class.forName("jcifs.util.Base64");
            NTLMSSP_TARGET_TYPE_DOMAIN = NTLM_FLAGS.getField("NTLMSSP_TARGET_TYPE_DOMAIN").getInt(null);
            NTLMSSP_TARGET_TYPE_SERVER = NTLM_FLAGS.getField("NTLMSSP_TARGET_TYPE_SERVER").getInt(null);
            for (String flagName : Arrays.asList("NTLMSSP_NEGOTIATE_56", "NTLMSSP_NEGOTIATE_128", "NTLMSSP_NEGOTIATE_NTLM2", "NTLMSSP_NEGOTIATE_ALWAYS_SIGN", "NTLMSSP_REQUEST_TARGET")) {
                type1Flags |= NTLM_FLAGS.getField(flagName).getInt(null);
            }
            TYPE_1_FLAGS = type1Flags;
        }
        catch (Throwable thrown) {
            failure = thrown;
        }
        finally {
            initFailure = failure;
        }
    }
}

