/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.transport;

import com.anaplan.client.transport.TransportProviderBase;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class HttpProvider
extends TransportProviderBase {
    protected final int DEFAULT_HTTP_PORT = 80;
    protected final int DEFAULT_HTTPS_PORT = 443;
    protected static final String MSG_NO_CONTENT = "noContent";
    protected static final String MSG_COMMS_FAILURE = "communicationFailure";
    protected static final String MSG_CODE_PREFIX = "code.";
    protected static final String MSG_CODE_OTHER = "code.other";
    private ResourceBundle messages = ResourceBundle.getBundle(HttpProvider.class.getSimpleName(), Locale.getDefault());

    protected HttpProvider() {
    }

    protected int getPort(URI uri) {
        String scheme = uri.getScheme();
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        return port;
    }

    protected String getMessage(String key, Object ... parameters) {
        try {
            String message = this.messages.getString(key);
            if (parameters == null || parameters.length == 0) {
                return message;
            }
            MessageFormat messageFormat = new MessageFormat(message);
            return messageFormat.format(parameters).toString();
        }
        catch (MissingResourceException mre) {
            StringBuilder message = new StringBuilder(key);
            for (int i = 0; i < message.length(); ++i) {
                char c = message.charAt(i);
                if (!Character.isUpperCase(c)) continue;
                message.insert(i++, ' ');
                message.setCharAt(i, Character.toLowerCase(c));
            }
            return message.toString();
        }
    }

    protected String getStatusMessage(int statusCode, String reasonPhrase) {
        String key = MSG_CODE_PREFIX + statusCode;
        if (this.messages.containsKey(key)) {
            return this.messages.getString(key);
        }
        return String.format(this.messages.getString(MSG_CODE_OTHER), statusCode, reasonPhrase);
    }
}

