/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.transport;

import com.anaplan.client.Credentials;
import com.anaplan.client.transport.AnaplanAPITransportException;
import com.anaplan.client.transport.HttpProvider;
import com.anaplan.client.transport.JCIFSEngine;
import com.anaplan.client.transport.TransportProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApacheHttpProvider
extends HttpProvider
implements TransportProvider {
    private static final String RFC_2617_AUTHORISATION_SCHEME = "AnaplanCertificate";
    private static final String CHARACTER_ENCODING = "UTF-8";
    private static final Logger logger = LogManager.getLogger((String)ApacheHttpProvider.class.getName());
    private DefaultHttpClient httpClient;
    private HttpHost httpHost;
    private HttpContext httpContext;
    private ProxySelectorRoutePlanner routePlanner;
    private String certificateAuthorizationHeader;

    protected ApacheHttpProvider() {
    }

    private void initialise(Credentials serviceCredentials) throws AnaplanAPITransportException {
        block9: {
            this.httpClient = new DefaultHttpClient();
            if (serviceCredentials.getScheme() == Credentials.Scheme.USER_CERTIFICATE) {
                try {
                    X509Certificate certificate = serviceCredentials.getCertificate();
                    String certificateCommonName = this.extractCommonName(certificate);
                    String rawAuthenticationParameter = certificateCommonName + ":" + this.convertToPEMFormat(certificate);
                    byte[] encodedAuthenticationParameter = Base64.encodeBase64((byte[])rawAuthenticationParameter.getBytes(CHARACTER_ENCODING));
                    this.certificateAuthorizationHeader = "AnaplanCertificate " + new String(encodedAuthenticationParameter, CHARACTER_ENCODING);
                }
                catch (Throwable thrown) {
                    throw new AnaplanAPITransportException("Could not initialise transport given provided certificate credentials", thrown);
                }
            }
            this.httpClient.getParams().setParameter("http.protocol.handle-authentication", (Object)Boolean.TRUE);
            this.httpClient.setCredentialsProvider((CredentialsProvider)new ApacheCredentialsProvider());
            try {
                final JCIFSEngine ntlmEngine = new JCIFSEngine();
                this.httpClient.getAuthSchemes().register("ntlm", new AuthSchemeFactory(){

                    public AuthScheme newInstance(HttpParams params) {
                        return new NTLMScheme(ntlmEngine);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                if (this.getDebugLevel() >= 2) {
                    logger.info("Not using JCIFS NTLM proxy authentication", invocationTargetException.getCause());
                } else if (this.getDebugLevel() >= 1) {
                    logger.info("Not using JCIFS NTLM proxy authentication due to " + invocationTargetException.getCause() + " (add jcifs.jar to lib folder if required)");
                }
            }
            catch (Throwable thrown) {
                if (this.getDebugLevel() < 1) break block9;
                logger.warn("Failed to set up JCIFS NTLM proxy authentication", thrown);
            }
        }
        this.routePlanner = new ProxySelectorRoutePlanner(this.httpClient.getConnectionManager().getSchemeRegistry(), this.getProxySelector()){
            private boolean suppressed;

            public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
                HttpRoute httpRoute = super.determineRoute(target, request, context);
                if (ApacheHttpProvider.this.getDebugLevel() >= 1 && !this.suppressed) {
                    logger.info(httpRoute.toString() + " (" + this.getProxySelector().getClass().getSimpleName() + ")");
                    if (ApacheHttpProvider.this.getDebugLevel() == 1) {
                        this.suppressed = true;
                    }
                }
                return httpRoute;
            }
        };
        this.httpClient.setRoutePlanner((HttpRoutePlanner)this.routePlanner);
    }

    @Override
    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @Override
    public void setServiceLocation(URI serviceLocation) throws AnaplanAPITransportException {
        super.setServiceLocation(serviceLocation);
        String scheme = serviceLocation.getScheme();
        int port = this.getPort(serviceLocation);
        this.httpHost = new HttpHost(serviceLocation.getHost(), port, scheme);
        this.httpContext = new BasicHttpContext();
        if (this.getServiceCredentials() != null) {
            this.setServiceCredentials(this.getServiceCredentials());
        }
    }

    @Override
    public void setServiceCredentials(Credentials serviceCredentials) throws AnaplanAPITransportException {
        super.setServiceCredentials(serviceCredentials);
        this.initialise(serviceCredentials);
        if (serviceCredentials.getScheme() != Credentials.Scheme.USER_CERTIFICATE && this.getServiceLocation() != null) {
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicScheme = new BasicScheme();
            authCache.put(this.httpHost, (AuthScheme)basicScheme);
            this.httpContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
    }

    @Override
    public void setProxyLocation(URI proxyLocation) throws AnaplanAPITransportException {
        super.setProxyLocation(proxyLocation);
        this.routePlanner.setProxySelector(this.getProxySelector());
    }

    @Override
    public void setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        HttpProtocolParams.setUserAgent((HttpParams)this.httpClient.getParams(), (String)userAgent);
    }

    @Override
    public byte[] get(String path, String acceptType) throws AnaplanAPITransportException {
        try {
            HttpGet httpGet = new HttpGet(this.getRequestPath(path));
            if (acceptType != null) {
                httpGet.setHeader("Accept", acceptType);
            }
            this.addHeaders((HttpRequestBase)httpGet);
            if (this.getDebugLevel() >= 1) {
                logger.info(httpGet.getRequestLine().toString());
            }
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpGet, this.httpContext);
            this.checkResponse(httpResponse);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return this.readResponseBody(httpEntity.getContent());
            }
            throw new AnaplanAPITransportException(this.getMessage("noContent", new Object[0]), null);
        }
        catch (IOException ioException) {
            throw this.createTransportException(ioException);
        }
    }

    @Override
    public boolean head(String path) throws AnaplanAPITransportException {
        try {
            HttpHead httpHead = new HttpHead(this.getRequestPath(path));
            if (this.getDebugLevel() >= 1) {
                logger.info(httpHead.getRequestLine().toString());
            }
            this.addHeaders((HttpRequestBase)httpHead);
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpHead, this.httpContext);
            HttpEntity httpEntity = httpResponse.getEntity();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (200 <= statusCode && statusCode <= 299) {
                if (httpEntity != null) {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                return true;
            }
            if (statusCode == 404) {
                if (httpEntity != null) {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                return false;
            }
            this.checkResponse(httpResponse);
            return false;
        }
        catch (IOException ioException) {
            throw this.createTransportException(ioException);
        }
    }

    @Override
    public byte[] post(String path, byte[] content, String contentType, String acceptType) throws AnaplanAPITransportException {
        try {
            HttpPost httpPost = new HttpPost(this.getRequestPath(path));
            if (contentType != null) {
                httpPost.setHeader("Content-Type", contentType);
            }
            if (acceptType != null) {
                httpPost.setHeader("Accept", acceptType);
            }
            this.addHeaders((HttpRequestBase)httpPost);
            if (this.getDebugLevel() >= 1) {
                logger.info(httpPost.getRequestLine().toString());
            }
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(content));
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpPost, this.httpContext);
            this.checkResponse(httpResponse);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return this.readResponseBody(httpEntity.getContent());
            }
            return null;
        }
        catch (IOException ioException) {
            throw this.createTransportException(ioException);
        }
    }

    @Override
    public byte[] put(String path, byte[] content, String contentType) throws AnaplanAPITransportException {
        try {
            String binaryContent = "application/octet-stream";
            HttpPut httpPut = new HttpPut(this.getRequestPath(path));
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            if (contentType.equals("application/octet-stream")) {
                contentType = "application/x-gzip";
                content = this.compress(content, 0, content.length);
            }
            httpPut.setHeader("Content-Type", contentType);
            this.addHeaders((HttpRequestBase)httpPut);
            if (this.getDebugLevel() >= 1) {
                logger.info(httpPut.getRequestLine().toString());
            }
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(content));
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpPut, this.httpContext);
            this.checkResponse(httpResponse);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return this.readResponseBody(httpEntity.getContent());
            }
            return null;
        }
        catch (IOException ioException) {
            throw this.createTransportException(ioException);
        }
    }

    @Override
    public byte[] delete(String path, String acceptType) throws AnaplanAPITransportException {
        try {
            HttpDelete httpDelete = new HttpDelete(this.getRequestPath(path));
            if (acceptType != null) {
                httpDelete.setHeader("Accept", acceptType);
            }
            this.addHeaders((HttpRequestBase)httpDelete);
            if (this.getDebugLevel() >= 1) {
                logger.info(httpDelete.getRequestLine().toString());
            }
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpDelete, this.httpContext);
            this.checkResponse(httpResponse);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return this.readResponseBody(httpEntity.getContent());
            }
            throw new AnaplanAPITransportException(this.getMessage("noContent", new Object[0]), null);
        }
        catch (IOException ioException) {
            throw this.createTransportException(ioException);
        }
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    protected void checkResponse(HttpResponse httpResponse) throws AnaplanAPITransportException {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (this.getDebugLevel() >= 1) {
            logger.info(httpResponse.getStatusLine().toString());
        }
        if (200 > statusCode || statusCode > 299) {
            block7: {
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity != null) {
                    try {
                        Header contentTypeHeader = httpEntity.getContentType();
                        String entityContent = EntityUtils.toString((HttpEntity)httpEntity);
                        if (this.getDebugLevel() >= 2) {
                            logger.info(String.valueOf(contentTypeHeader));
                            logger.info(entityContent);
                        }
                        if (!entityContent.isEmpty() && contentTypeHeader != null && contentTypeHeader.getValue().startsWith("text/plain")) {
                            throw new AnaplanAPITransportException(entityContent);
                        }
                    }
                    catch (IOException ioException) {
                        if (this.getDebugLevel() < 1) break block7;
                        logger.warn("I/O exception whilst reading response", (Throwable)ioException);
                    }
                }
            }
            throw new AnaplanAPITransportException(this.getStatusMessage(statusCode, httpResponse.getStatusLine().getReasonPhrase()));
        }
    }

    private AnaplanAPITransportException createTransportException(IOException ioException) {
        return new AnaplanAPITransportException(this.getMessage("communicationFailure", new Object[0]), ioException);
    }

    private String extractCommonName(X509Certificate certificate) {
        try {
            String dn = certificate.getSubjectX500Principal().getName();
            LdapName ldapDN = new LdapName(dn);
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!"CN".equals(rdn.getType())) continue;
                return (String)rdn.getValue();
            }
            throw new RuntimeException("Could not load common name (CN) field from certificate");
        }
        catch (InvalidNameException e) {
            throw new RuntimeException("Could not load common name (CN) field from certificate");
        }
    }

    private void addHeaders(HttpRequestBase request) throws AnaplanAPITransportException, IOException {
        if (this.getServiceCredentials().getScheme() == Credentials.Scheme.USER_CERTIFICATE) {
            request.setHeader("Authorization", this.certificateAuthorizationHeader);
        }
    }

    private String convertToPEMFormat(X509Certificate cert) throws AnaplanAPITransportException, IOException {
        try {
            return "-----BEGIN CERTIFICATE-----\n" + new String(Base64.encodeBase64((byte[])cert.getEncoded()), "US-ASCII") + "\n-----END CERTIFICATE-----";
        }
        catch (CertificateEncodingException cee) {
            throw new AnaplanAPITransportException("Failed to encode user certificate", cee);
        }
    }

    public class ApacheCredentialsProvider
    implements CredentialsProvider {
        public void clear() {
        }

        public org.apache.http.auth.Credentials getCredentials(AuthScope authScope) {
            try {
                InetAddress authAddress = InetAddress.getByName(authScope.getHost());
                InetAddress serviceAddress = InetAddress.getByName(ApacheHttpProvider.this.httpHost.getHostName());
                URI proxyLocation = ApacheHttpProvider.this.getProxyLocation();
                if (serviceAddress.equals(authAddress) && (authScope.getPort() == -1 || authScope.getPort() == ApacheHttpProvider.this.httpHost.getPort())) {
                    Credentials serviceCredentials = ApacheHttpProvider.this.getServiceCredentials();
                    if (serviceCredentials == null) {
                        return null;
                    }
                    return new UsernamePasswordCredentials(serviceCredentials.getUserName(), serviceCredentials.getPassphrase());
                }
                if (proxyLocation != null) {
                    InetAddress proxyAddress = InetAddress.getByName(proxyLocation.getHost());
                    int proxyPort = ApacheHttpProvider.this.getPort(proxyLocation);
                    if (proxyAddress.equals(authAddress) && (authScope.getPort() == -1 || authScope.getPort() == proxyPort)) {
                        Credentials proxyCredentials = ApacheHttpProvider.this.getProxyCredentials();
                        if (proxyCredentials == null) {
                            return null;
                        }
                        if ("ntlm".equalsIgnoreCase(authScope.getScheme())) {
                            return new NTCredentials(proxyCredentials.getUserName(), proxyCredentials.getPassphrase(), proxyCredentials.getWorkstation(), proxyCredentials.getDomain());
                        }
                        return new UsernamePasswordCredentials(proxyCredentials.getUserName(), proxyCredentials.getPassphrase());
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (ApacheHttpProvider.this.getDebugLevel() >= 1) {
                    logger.warn("Failed to resolve hostname for authentication", (Throwable)unknownHostException);
                }
                throw new IllegalArgumentException(unknownHostException.getMessage());
            }
            return null;
        }

        public void setCredentials(AuthScope authScope, org.apache.http.auth.Credentials credentials) {
        }
    }
}

