/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.serialization;

import com.anaplan.client.serialization.AnaplanAPISerializationException;
import com.anaplan.client.serialization.SerializationHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SerializationHandlerFactory {
    private static final Logger logger = Logger.getLogger("anaplan-connect.serialization");
    private static SerializationHandlerFactory instance;
    private Map<String, SerializationHandler> handlers = new HashMap<String, SerializationHandler>();
    private SerializationHandler defaultHandler;

    public static synchronized SerializationHandlerFactory getInstance() throws AnaplanAPISerializationException {
        if (instance == null) {
            instance = new SerializationHandlerFactory();
        }
        return instance;
    }

    private SerializationHandlerFactory() throws AnaplanAPISerializationException {
        String defaultHandlerProperty = System.getProperty("anaplan.client.serialization.default");
        if (null != defaultHandlerProperty) {
            try {
                Class<?> defaultHandlerClass = Class.forName(defaultHandlerProperty);
                this.defaultHandler = defaultHandlerClass.asSubclass(SerializationHandler.class).newInstance();
                this.handlers.put(defaultHandlerClass.getSimpleName(), this.defaultHandler);
            }
            catch (Throwable thrown) {
                throw new AnaplanAPISerializationException("Cannot instatiate default handler " + defaultHandlerProperty, thrown);
            }
        }
        try {
            Class.forName("com.google.gson.Gson");
            SerializationHandler gsonHandler = (SerializationHandler)Class.forName("com.anaplan.client.serialization.GsonHandler").newInstance();
            this.handlers.put("GSON", gsonHandler);
            if (null == this.defaultHandler) {
                this.defaultHandler = gsonHandler;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.handlers.isEmpty()) {
            throw new AnaplanAPISerializationException("No serialization handlers available: try adding gson-1.7.1.jar to the classpath");
        }
    }

    public SerializationHandler getHandler(String name) {
        return this.handlers.get(name);
    }

    public SerializationHandler getDefaultHandler() {
        return this.defaultHandler;
    }
}

