/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.serialization;

import com.anaplan.client.serialization.AnaplanAPISerializationException;
import com.anaplan.client.serialization.SerializationHandler;
import com.anaplan.client.serialization.TypeWrapper;
import com.google.gson.Gson;

public class GsonHandler
implements SerializationHandler {
    private Gson gson = new Gson();

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public <T> byte[] serialize(T instance, TypeWrapper<T> typeWrapper) throws AnaplanAPISerializationException {
        try {
            String json = this.gson.toJson(instance, typeWrapper.getType());
            return json.getBytes("UTF-8");
        }
        catch (Throwable thrown) {
            throw new AnaplanAPISerializationException("Failed to serialize API request parameters using GSON", thrown);
        }
    }

    @Override
    public <T> T deserialize(byte[] data, TypeWrapper<T> typeWrapper) throws AnaplanAPISerializationException {
        try {
            String json = new String(data, "UTF-8");
            return (T)this.gson.fromJson(json, typeWrapper.getType());
        }
        catch (Throwable thrown) {
            throw new AnaplanAPISerializationException("Failed to deserialize API response result using GSON", thrown);
        }
    }
}

