/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.AnaplanApiClientObject;
import com.anaplan.client.Model;
import com.anaplan.client.Service;
import com.anaplan.client.serialization.TypeWrapper;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class Workspace
extends AnaplanApiClientObject {
    static final TypeWrapper<List<Data>> DATA_LIST_TYPE = new TypeWrapper<List<Data>>(){};
    private Service service;
    private Data data;
    private Map<Model.Data, Reference<Model>> modelCache = new WeakHashMap<Model.Data, Reference<Model>>();

    Workspace(Service service, Data data) {
        super(service);
        this.service = service;
        this.data = data;
    }

    Service getService() {
        return this.service;
    }

    @Override
    String getPath() {
        return this.getService().getPath() + "/workspaces/" + this.getId();
    }

    public String getId() {
        return this.data.guid;
    }

    public String getName() {
        return this.data.name;
    }

    public List<Model> getModels() throws AnaplanAPIException {
        List<Model.Data> response = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/models", this.getSerializationHandler().getContentType()), Model.DATA_LIST_TYPE);
        ArrayList<Model> result = new ArrayList<Model>(response.size());
        for (Model.Data modelData : response) {
            Model model;
            Reference<Model> modelReference = this.modelCache.get(modelData);
            Model model2 = model = modelReference == null ? null : modelReference.get();
            if (model == null) {
                model = new Model(this, modelData);
                this.modelCache.put(modelData, new WeakReference<Model>(model));
            }
            result.add(model);
        }
        return result;
    }

    public Model getModel(String modelId) throws AnaplanAPIException {
        List<Model> models = this.getModels();
        for (Model model : models) {
            if (!modelId.equals(model.getId())) continue;
            return model;
        }
        for (Model model : models) {
            if (!modelId.equalsIgnoreCase(model.getName())) continue;
            return model;
        }
        return null;
    }

    static final class Data {
        String guid;
        String name;

        Data() {
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            return this.guid.equals(data.guid) && this.name.equals(data.name);
        }

        public int hashCode() {
            return this.guid.hashCode() * 31 + this.name.hashCode();
        }
    }
}

