/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Model;
import com.anaplan.client.ServerFile;
import com.anaplan.client.TaskResultDetail;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TaskResult {
    private Model model;
    private String dumpFileId;
    private String dumpFilePath;
    private Data data;
    private List<TaskResultDetail> details;
    private List<TaskResult> nestedResults;

    TaskResult(Model model, String dumpFileId, String dumpFilePath, Data data) {
        this.model = model;
        this.dumpFileId = dumpFileId;
        this.dumpFilePath = dumpFilePath;
        this.data = data;
        ArrayList<TaskResultDetail> details = new ArrayList<TaskResultDetail>();
        if (null != data.details) {
            for (TaskResultDetail.Data detailData : data.details) {
                details.add(new TaskResultDetail(detailData));
            }
        }
        this.details = Collections.unmodifiableList(details);
        ArrayList<TaskResult> nestedResults = new ArrayList<TaskResult>();
        if (null != data.nestedResults) {
            for (Data nestedData : data.nestedResults) {
                nestedResults.add(new TaskResult(model, dumpFileId + "~" + nestedData.objectId, dumpFilePath + "s/" + nestedData.objectId, nestedData));
            }
        }
        this.nestedResults = Collections.unmodifiableList(nestedResults);
    }

    public String getObjectId() {
        return this.data.objectId;
    }

    public String getObjectName() {
        return this.data.objectName;
    }

    public boolean isSuccessful() {
        return this.data.successful;
    }

    public List<TaskResultDetail> getDetails() {
        return this.details;
    }

    public boolean isFailureDumpAvailable() {
        return this.data.failureDumpAvailable;
    }

    public ServerFile getFailureDump() {
        if (!this.isFailureDumpAvailable()) {
            return null;
        }
        ServerFile.Data serverFileData = new ServerFile.Data();
        serverFileData.id = this.dumpFileId;
        return new ServerFile(this.model, serverFileData){

            @Override
            String getPath() {
                return TaskResult.this.dumpFilePath;
            }

            @Override
            public void upLoad(File source, boolean deleteExisting) throws AnaplanAPIException {
                throw new AnaplanAPIException("Cannot upload to failure dump");
            }
        };
    }

    public List<TaskResult> getNestedResults() {
        return this.nestedResults;
    }

    public Appendable appendTo(Appendable out) throws IOException {
        for (TaskResultDetail detail : this.details) {
            detail.appendTo(out);
            out.append('\n');
        }
        for (TaskResult nestedResult : this.nestedResults) {
            nestedResult.appendTo(out);
            out.append('\n');
        }
        return out;
    }

    public String toString() {
        try {
            return this.appendTo(new StringBuilder()).toString();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    static class Data {
        String objectId;
        String objectName;
        boolean successful;
        List<TaskResultDetail.Data> details;
        boolean failureDumpAvailable;
        List<Data> nestedResults;

        Data() {
        }
    }
}

