/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.serialization.TypeWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TaskParameters {
    static final TypeWrapper<Data> DATA_TYPE = new TypeWrapper<Data>(){};
    Data data = new Data();

    public TaskParameters() {
        this.data.localeName = Locale.getDefault().toString();
    }

    public void setLocale(String language, String country) {
        this.data.localeName = language == null ? country.toUpperCase() : (country == null ? language.toLowerCase() : language.toLowerCase() + "_" + country.toUpperCase());
    }

    public void addConnectorParameter(String parameterId, String parameterValue) {
        this.addConnectorParameter((String)null, parameterId, parameterValue);
    }

    public void addConnectorParameter(ConnectorParameter connectorParameter, String parameterValue) {
        this.addConnectorParameter((String)null, connectorParameter.name(), parameterValue);
    }

    public void addConnectorParameter(SourceType sourceType, String parameterId, String parameterValue) {
        this.addConnectorParameter(sourceType.name(), parameterId, parameterValue);
    }

    public void addConnectorParameter(SourceType sourceType, ConnectorParameter connectorParameter, String parameterValue) {
        this.addConnectorParameter(sourceType.name(), connectorParameter.name(), parameterValue);
    }

    public void addConnectorParameter(String sourceIdOrType, ConnectorParameter connectorParameter, String parameterValue) {
        this.addConnectorParameter(sourceIdOrType, connectorParameter, parameterValue);
    }

    public void addConnectorParameter(String sourceIdOrType, String parameterId, String parameterValue) {
        if (this.data.connectorParameters == null) {
            this.data.connectorParameters = new ArrayList<ConnectorParameterData>();
        }
        ConnectorParameterData connectorParameterData = new ConnectorParameterData();
        connectorParameterData.sourceIdOrType = sourceIdOrType;
        connectorParameterData.parameterId = parameterId.toUpperCase();
        connectorParameterData.value = parameterValue;
        this.data.connectorParameters.add(connectorParameterData);
    }

    public void addMappingParameter(String entityType, String entityName) {
        this.addMappingParameter(null, entityType, entityName);
    }

    public void addMappingParameter(String importId, String entityType, String entityName) {
        if (this.data.mappingParameters == null) {
            this.data.mappingParameters = new ArrayList<MappingParameterData>();
        }
        MappingParameterData mappingParameterData = new MappingParameterData();
        mappingParameterData.importId = importId;
        mappingParameterData.entityType = entityType;
        mappingParameterData.entityName = entityName;
        this.data.mappingParameters.add(mappingParameterData);
    }

    public static enum ConnectorParameter {
        INSTANCE,
        USERID,
        PASSWORD,
        SECURITY_TOKEN;

    }

    public static enum SourceType {
        UPLOADED_FILE,
        MODEL_OBJECT,
        SALESFORCE_API;

    }

    static class MappingParameterData {
        String importId;
        String entityType;
        String entityName;

        MappingParameterData() {
        }
    }

    static class ConnectorParameterData {
        String sourceIdOrType;
        String parameterId;
        String value;

        ConnectorParameterData() {
        }
    }

    static class Data {
        String localeName;
        List<ConnectorParameterData> connectorParameters;
        List<MappingParameterData> mappingParameters;

        Data() {
        }
    }
}

