/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Model;
import com.anaplan.client.NamedObject;
import com.anaplan.client.Task;
import com.anaplan.client.TaskParameters;
import java.util.ArrayList;
import java.util.List;

public abstract class TaskFactory
extends NamedObject {
    protected TaskFactory(Model model, NamedObject.Data data) {
        super(model, data);
    }

    public Task createTask() throws AnaplanAPIException {
        return this.createTask(new TaskParameters());
    }

    public Task createTask(TaskParameters taskParameters) throws AnaplanAPIException {
        byte[] content = this.getSerializationHandler().serialize(taskParameters.data, TaskParameters.DATA_TYPE);
        String contentType = this.getSerializationHandler().getContentType();
        content = this.getTransportProvider().post(this.getPath() + "/tasks", content, contentType, contentType);
        Task.Data data = this.getSerializationHandler().deserialize(content, Task.DATA_TYPE);
        return new Task(this, data);
    }

    public List<Task> getTasks() throws AnaplanAPIException {
        List<Task.Data> response = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/tasks", this.getSerializationHandler().getContentType()), Task.DATA_LIST_TYPE);
        ArrayList<Task> result = new ArrayList<Task>(response.size());
        for (Task.Data taskData : response) {
            Task task = new Task(this, taskData);
            result.add(task);
        }
        return result;
    }
}

