/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.AnaplanApiClientObject;
import com.anaplan.client.NamedObject;
import com.anaplan.client.TaskStatus;
import com.anaplan.client.serialization.TypeWrapper;
import java.util.List;

public class Task
extends AnaplanApiClientObject {
    static final TypeWrapper<Data> DATA_TYPE = new TypeWrapper<Data>(){};
    static final TypeWrapper<List<Data>> DATA_LIST_TYPE = new TypeWrapper<List<Data>>(){};
    private NamedObject subject;
    private Data data;

    Task(NamedObject subject, Data data) {
        super(subject.getModel().getWorkspace().getService());
        this.subject = subject;
        this.data = data;
    }

    @Override
    String getPath() {
        return this.subject.getPath() + "/tasks/" + this.data.taskId;
    }

    NamedObject getSubject() {
        return this.subject;
    }

    String getId() {
        return this.data.taskId;
    }

    public TaskStatus cancel() throws AnaplanAPIException {
        TaskStatus.Data response = this.getSerializationHandler().deserialize(this.getTransportProvider().delete(this.getPath(), this.getSerializationHandler().getContentType()), TaskStatus.DATA_TYPE);
        return new TaskStatus(this, response);
    }

    public TaskStatus getStatus() throws AnaplanAPIException {
        byte[] content = this.getTransportProvider().get(this.getPath(), this.getSerializationHandler().getContentType());
        TaskStatus.Data taskStatusData = this.getSerializationHandler().deserialize(content, TaskStatus.DATA_TYPE);
        return new TaskStatus(this, taskStatusData);
    }

    static class Data {
        String taskId;

        Data() {
        }
    }
}

