/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.AnaplanApiClientObject;
import com.anaplan.client.Credentials;
import com.anaplan.client.Workspace;
import com.anaplan.client.serialization.SerializationHandler;
import com.anaplan.client.serialization.SerializationHandlerFactory;
import com.anaplan.client.transport.TransportProvider;
import com.anaplan.client.transport.TransportProviderFactory;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class Service
extends AnaplanApiClientObject
implements Closeable {
    private static final Logger logger = Logger.getLogger("anaplan-connect.service");
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 3;
    public static final int REVISION_VERSION = 6;
    public static final String RELEASE_VERSION = "-dev";
    private static final String PATH = "/1/3";
    public static final URI PRODUCTION_API_ROOT;
    @Deprecated
    public static final URI UAT_API_ROOT;
    private URI serviceLocation;
    private Credentials serviceCredentials;
    private URI proxyLocation;
    private boolean proxyLocationProvided;
    private Credentials proxyCredentials;
    private SerializationHandler serializationHandler;
    private TransportProvider transportProvider;
    private boolean transportProviderInitialized;
    private Map<Workspace.Data, Reference<Workspace>> workspaceCache = new WeakHashMap<Workspace.Data, Reference<Workspace>>();
    private int debugLevel = 0;

    @Override
    String getPath() {
        return PATH;
    }

    public Service(URI serviceLocation) {
        super(null);
        if (serviceLocation == null) {
            throw new IllegalArgumentException("Service location must be specified");
        }
        this.serviceLocation = serviceLocation;
    }

    public Service() {
        this(PRODUCTION_API_ROOT);
    }

    public void setProxyLocation(URI proxyLocation) throws AnaplanAPIException {
        this.proxyLocation = proxyLocation;
        this.proxyLocationProvided = true;
        if (this.transportProvider != null) {
            this.transportProvider.setProxyLocation(proxyLocation);
        }
    }

    public void setServiceCredentials(Credentials serviceCredentials) throws AnaplanAPIException {
        this.serviceCredentials = serviceCredentials;
        if (this.transportProvider != null) {
            this.transportProvider.setServiceCredentials(serviceCredentials);
        }
    }

    public void setProxyCredentials(Credentials proxyCredentials) throws AnaplanAPIException {
        this.proxyCredentials = proxyCredentials;
        if (this.transportProvider != null) {
            this.transportProvider.setProxyCredentials(proxyCredentials);
        }
    }

    public void setSerializationHandler(SerializationHandler serializationHandler) {
        this.serializationHandler = serializationHandler;
    }

    @Override
    SerializationHandler getSerializationHandler() throws AnaplanAPIException {
        if (this.serializationHandler == null) {
            SerializationHandlerFactory serializationHandlerFactory = SerializationHandlerFactory.getInstance();
            this.serializationHandler = serializationHandlerFactory.getDefaultHandler();
        }
        return this.serializationHandler;
    }

    public void setTransportProvider(TransportProvider transportProvider) {
        this.transportProvider = transportProvider;
        this.transportProviderInitialized = false;
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    synchronized TransportProvider getTransportProvider() throws AnaplanAPIException {
        if (this.transportProvider == null) {
            TransportProviderFactory transportProviderFactory = TransportProviderFactory.getInstance();
            this.transportProvider = transportProviderFactory.createDefaultProvider();
        }
        if (!this.transportProviderInitialized) {
            this.transportProvider.setDebugLevel(this.debugLevel);
            this.transportProvider.setServiceLocation(this.serviceLocation);
            this.transportProvider.setServiceCredentials(this.serviceCredentials);
            if (this.proxyLocationProvided) {
                this.transportProvider.setProxyLocation(this.proxyLocation);
            }
            if (this.proxyCredentials != null) {
                this.transportProvider.setProxyCredentials(this.proxyCredentials);
            }
            this.transportProviderInitialized = true;
            String userAgentIdentifier = this.buildUserAgentIdentifier();
            if (this.debugLevel > 0) {
                logger.info("UA: " + userAgentIdentifier);
            }
            this.transportProvider.setUserAgent(userAgentIdentifier);
        }
        return this.transportProvider;
    }

    protected String buildUserAgentIdentifier() throws AnaplanAPIException {
        StringBuilder result = new StringBuilder(this.getClass().getName());
        result.append("/").append(1).append(".").append(3);
        result.append(".").append(6).append(RELEASE_VERSION);
        result.append(" (").append(this.getTransportProvider().toString());
        result.append("; ").append(this.getSerializationHandler().toString());
        String vmIdentifier = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vendor") + ")/" + System.getProperty("java.vm.version") + " (" + System.getProperty("java.version") + ")";
        result.append("; ").append(vmIdentifier);
        String osIdentifier = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")/" + System.getProperty("os.version");
        result.append("; ").append(osIdentifier).append(')');
        return result.toString();
    }

    protected void checkInitialized() {
        if (this.serviceLocation == null) {
            throw new IllegalStateException("The Service instance is in a closed state. No further access is permitted.");
        }
        if (this.serviceCredentials == null) {
            throw new IllegalStateException("No credentials were provided");
        }
    }

    public List<Workspace> getWorkspaces() throws AnaplanAPIException {
        this.checkInitialized();
        List<Workspace.Data> response = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/workspaces/", this.getSerializationHandler().getContentType()), Workspace.DATA_LIST_TYPE);
        ArrayList<Workspace> result = new ArrayList<Workspace>(response.size());
        for (Workspace.Data workspaceData : response) {
            Workspace workspace;
            Reference<Workspace> workspaceReference = this.workspaceCache.get(workspaceData);
            Workspace workspace2 = workspace = workspaceReference == null ? null : workspaceReference.get();
            if (workspace == null) {
                workspace = new Workspace(this, workspaceData);
                this.workspaceCache.put(workspaceData, new WeakReference<Workspace>(workspace));
            }
            result.add(workspace);
        }
        return result;
    }

    public Workspace getWorkspace(String workspaceId) throws AnaplanAPIException {
        this.checkInitialized();
        List<Workspace> workspaces = this.getWorkspaces();
        for (Workspace workspace : workspaces) {
            if (!workspaceId.equals(workspace.getId())) continue;
            return workspace;
        }
        for (Workspace workspace : workspaces) {
            if (!workspaceId.equalsIgnoreCase(workspace.getName())) continue;
            return workspace;
        }
        return null;
    }

    @Override
    public void close() {
        this.serviceLocation = null;
        if (this.transportProvider != null) {
            this.transportProvider.close();
            this.transportProvider = null;
        }
    }

    static {
        try {
            PRODUCTION_API_ROOT = new URI("https://api.anaplan.com/");
            UAT_API_ROOT = new URI("https://api-uat.anaplan.com/");
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new ExceptionInInitializerError(uriSyntaxException);
        }
    }
}

