/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellReader;
import com.anaplan.client.CellWriter;
import com.anaplan.client.Model;
import com.anaplan.client.NamedObject;
import com.anaplan.client.serialization.TypeWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ServerFile
extends NamedObject {
    private static final Logger logger = Logger.getLogger(ServerFile.class.getName());
    static final TypeWrapper<Data> DATA_TYPE = new TypeWrapper<Data>(){};
    static final TypeWrapper<List<Data>> DATA_LIST_TYPE = new TypeWrapper<List<Data>>(){};
    static final TypeWrapper<List<Chunk>> CHUNK_LIST_TYPE = new TypeWrapper<List<Chunk>>(){};
    private Data data;

    ServerFile(Model model, Data data) {
        super(model, data);
        this.data = data;
    }

    @Override
    String getPath() {
        return this.getModel().getPath() + "/files/" + this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLoad(File target, boolean deleteExisting) throws AnaplanAPIException, IOException {
        if (target.exists()) {
            if (!target.isFile()) {
                throw new FileNotFoundException("Path \"" + target + "\" exists but is not a file");
            }
            if (!deleteExisting) {
                throw new IllegalStateException("File \"" + target + "\" already exists");
            }
            if (!target.canWrite()) {
                throw new FileNotFoundException("File \"" + target + "\" cannot be written to - check ownership and/or permissions");
            }
            target.delete();
        }
        File partial = new File(target.getParentFile(), ".partial." + target.getName());
        RandomAccessFile partialFile = new RandomAccessFile(partial, "rw");
        try {
            partialFile.setLength(0L);
            byte[] content = this.getTransportProvider().get(this.getPath() + "/chunks", this.getSerializationHandler().getContentType());
            List<Chunk> chunkList = this.getSerializationHandler().deserialize(content, CHUNK_LIST_TYPE);
            for (Chunk chunk : chunkList) {
                byte[] chunkContent = this.getTransportProvider().get(this.getPath() + "/chunks/" + chunk.id, null);
                partialFile.write(chunkContent);
            }
            partialFile.close();
            partialFile = null;
            partial.renameTo(target);
        }
        finally {
            if (partialFile != null) {
                try {
                    partialFile.close();
                }
                catch (IOException ioException) {
                    logger.warning("Warning: failed to close file " + partial + ": " + ioException.getMessage());
                }
            }
        }
    }

    public InputStream getDownloadStream() throws AnaplanAPIException, IOException {
        byte[] content = this.getTransportProvider().get(this.getPath() + "/chunks", this.getSerializationHandler().getContentType());
        final List<Chunk> chunkList = this.getSerializationHandler().deserialize(content, CHUNK_LIST_TYPE);
        return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < chunkList.size();
            }

            @Override
            public InputStream nextElement() {
                try {
                    byte[] chunkContent = ServerFile.this.getTransportProvider().get(ServerFile.this.getPath() + "/chunks/" + ((Chunk)chunkList.get((int)this.index++)).id, null);
                    return new ByteArrayInputStream(chunkContent);
                }
                catch (Exception thrown) {
                    throw new RuntimeException("Failed to read chunk from server", thrown);
                }
            }
        });
    }

    public CellReader getDownloadCellReader() throws AnaplanAPIException, IOException {
        final LineNumberReader lnr = new LineNumberReader(new InputStreamReader(this.getDownloadStream(), "UTF-8"));
        String headerLine = lnr.readLine();
        final String[] headerRow = headerLine == null ? new String[]{} : headerLine.split("\\t");
        return new CellReader(){

            @Override
            public String[] getHeaderRow() throws AnaplanAPIException, IOException {
                return headerRow;
            }

            @Override
            public String[] readDataRow() throws AnaplanAPIException, IOException {
                String dataLine = lnr.readLine();
                return dataLine == null ? null : dataLine.split("\\t");
            }

            @Override
            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upLoad(File source, boolean deleteExisting) throws AnaplanAPIException, IOException {
        if (!source.exists()) {
            throw new FileNotFoundException("Path \"" + source + "\" does not exist");
        }
        if (!source.isFile()) {
            throw new FileNotFoundException("Path \"" + source + "\" does not refer to a file");
        }
        if (!source.canRead()) {
            throw new FileNotFoundException("File \"" + source + "\" cannot be read - check ownership and/or permissions");
        }
        RandomAccessFile sourceFile = null;
        try {
            long length = source.length();
            int chunkSize = 0x100000;
            this.data.chunkCount = (int)((length - 1L) / 0x100000L) + 1;
            byte[] content = this.getSerializationHandler().serialize(this.data, DATA_TYPE);
            String contentType = this.getSerializationHandler().getContentType();
            content = this.getTransportProvider().post(this.getPath(), content, contentType, contentType);
            if (content != null) {
                this.data = this.getSerializationHandler().deserialize(content, DATA_TYPE);
            }
            content = this.getTransportProvider().get(this.getPath() + "/chunks", contentType);
            List<Chunk> chunkList = this.getSerializationHandler().deserialize(content, CHUNK_LIST_TYPE);
            Iterator<Chunk> chunkIterator = chunkList.iterator();
            byte[] buffer = new byte[0x100000];
            sourceFile = new RandomAccessFile(source, "r");
            long totalReadSoFar = 0L;
            while (chunkIterator.hasNext()) {
                Chunk chunk = chunkIterator.next();
                int size = 0x100000;
                if (!chunkIterator.hasNext()) {
                    size = (int)(length - totalReadSoFar);
                }
                if (size != buffer.length) {
                    buffer = new byte[size];
                }
                sourceFile.readFully(buffer, 0, size);
                totalReadSoFar += (long)size;
                this.getTransportProvider().put(this.getPath() + "/chunks/" + chunk.id, buffer, null);
            }
        }
        finally {
            if (sourceFile != null) {
                try {
                    sourceFile.close();
                }
                catch (IOException ioException) {
                    logger.warning("Warning: failed to close file " + source + ": " + ioException.getMessage());
                }
            }
        }
    }

    public OutputStream getUploadStream() throws AnaplanAPIException, IOException {
        int chunkSize = 0x100000;
        this.data.chunkCount = -1;
        byte[] content = this.getSerializationHandler().serialize(this.data, DATA_TYPE);
        String contentType = this.getSerializationHandler().getContentType();
        content = this.getTransportProvider().post(this.getPath(), content, contentType, contentType);
        if (content != null) {
            this.data = this.getSerializationHandler().deserialize(content, DATA_TYPE);
        }
        return new FilterOutputStream(new ByteArrayOutputStream(0x200000)){
            int chunkIndex;
            {
                this.chunkIndex = 0;
            }

            private ByteArrayOutputStream getBuffer() {
                return (ByteArrayOutputStream)this.out;
            }

            @Override
            public void write(int b) throws IOException {
                super.write(b);
                if (this.getBuffer().size() >= 0x100000) {
                    this.flush();
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                if (this.getBuffer().size() >= 0x100000) {
                    this.flush();
                }
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                try {
                    ServerFile.this.getTransportProvider().put(ServerFile.this.getPath() + "/chunks/" + this.chunkIndex++, this.getBuffer().toByteArray(), null);
                }
                catch (AnaplanAPIException apiException) {
                    throw new IOException(apiException);
                }
                this.getBuffer().reset();
            }

            @Override
            public void close() throws IOException {
                this.flush();
                try {
                    byte[] content = ServerFile.this.getSerializationHandler().serialize(ServerFile.this.data, DATA_TYPE);
                    String contentType = ServerFile.this.getSerializationHandler().getContentType();
                    content = ServerFile.this.getTransportProvider().post(ServerFile.this.getPath() + "/complete", content, contentType, contentType);
                    if (content != null) {
                        ServerFile.this.data = ServerFile.this.getSerializationHandler().deserialize(content, DATA_TYPE);
                    }
                }
                catch (AnaplanAPIException apiException) {
                    throw new IOException(apiException);
                }
            }
        };
    }

    public CellWriter getUploadCellWriter() throws AnaplanAPIException {
        return new CellWriter(){
            OutputStream output;

            @Override
            public void writeHeaderRow(Object[] row) throws AnaplanAPIException, IOException {
                this.output = ServerFile.this.getUploadStream();
                this.writeDataRow(row);
            }

            @Override
            public void writeDataRow(Object[] row) throws AnaplanAPIException, IOException {
                if (this.output == null) {
                    throw new AnaplanAPIException("Cell writer is no longer open");
                }
                StringBuilder buf = new StringBuilder();
                int col = 0;
                for (Object item : row) {
                    String text;
                    if (col++ != 0) {
                        buf.append('\t');
                    }
                    if ((text = item.toString()).indexOf(9) != -1) {
                        logger.info("TEXT IS: " + text);
                        throw new AnaplanAPIException("Cell text cannot contain tab character: >>" + text + "<<");
                    }
                    buf.append(text);
                }
                this.output.write(buf.append('\n').toString().getBytes("UTF-8"));
            }

            @Override
            public void close() throws IOException {
                if (this.output != null) {
                    this.change("format", "txt");
                    this.change("encoding", "UTF-8");
                    this.change("separator", "\t");
                    this.change("delimiter", "");
                    this.change("headerRow", 1);
                    this.change("firstDataRow", 2);
                    this.output.close();
                    this.output = null;
                }
            }

            private void change(String fieldName, Object newValue) {
                try {
                    Field field = ServerFile.this.data.getClass().getDeclaredField(fieldName);
                    Object originalValue = field.get(ServerFile.this.data);
                    if (null == originalValue && null != newValue || !originalValue.equals(newValue)) {
                        logger.warning("Changing " + fieldName + " from " + String.valueOf(originalValue).replace("\t", "<TAB>") + " to " + String.valueOf(newValue).replace("\t", "<TAB>"));
                        field.set(ServerFile.this.data, newValue);
                    }
                }
                catch (Throwable thrown) {
                    logger.warning("Failed to change " + fieldName + " to " + String.valueOf(newValue).replace("\t", "<TAB>") + ": " + thrown.getMessage());
                }
            }

            @Override
            public void abort() {
                this.output = null;
            }
        };
    }

    public void setFormat(Format format) {
        this.data.format = format == null ? null : String.valueOf((Object)format);
    }

    public Format getFormat() {
        return this.data.format == null ? null : Format.valueOf(this.data.format);
    }

    public void setLanguage(String language) {
        this.data.language = language;
    }

    public void setCountry(String country) {
        this.data.country = country;
    }

    public void setEncoding(String encoding) {
        this.data.encoding = encoding;
    }

    public void setSeparator(String separator) {
        this.data.separator = separator;
    }

    public void setDelimiter(String delimiter) {
        this.data.delimiter = delimiter;
    }

    public void setHeaderRow(Integer headerRow) {
        this.data.headerRow = headerRow;
    }

    public void setFirstDataRow(Integer firstDataRow) {
        this.data.firstDataRow = firstDataRow;
    }

    public String getLanguage() {
        return this.data.language;
    }

    public String getCountry() {
        return this.data.country;
    }

    public String getEncoding() {
        return this.data.encoding;
    }

    public String getSeparator() {
        return this.data.separator;
    }

    public String getDelimiter() {
        return this.data.delimiter;
    }

    public Integer getHeaderRow() {
        return this.data.headerRow;
    }

    public Integer getFirstDataRow() {
        return this.data.firstDataRow;
    }

    static class Chunk
    extends NamedObject.Data {
        Chunk() {
        }
    }

    static class Data
    extends NamedObject.Data {
        int chunkCount;
        String origin;
        String format;
        String language;
        String country;
        String encoding;
        String separator;
        String delimiter;
        Integer headerRow;
        Integer firstDataRow;

        Data() {
        }
    }

    public static enum Format {
        TXT;

    }
}

