/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.Action;
import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellReader;
import com.anaplan.client.CellWriter;
import com.anaplan.client.Credentials;
import com.anaplan.client.DataType;
import com.anaplan.client.EncodingUtils;
import com.anaplan.client.Export;
import com.anaplan.client.ExportMetadata;
import com.anaplan.client.Import;
import com.anaplan.client.JDBCCellReader;
import com.anaplan.client.Model;
import com.anaplan.client.Module;
import com.anaplan.client.Process;
import com.anaplan.client.ServerFile;
import com.anaplan.client.Service;
import com.anaplan.client.Task;
import com.anaplan.client.TaskFactory;
import com.anaplan.client.TaskParameters;
import com.anaplan.client.TaskResult;
import com.anaplan.client.TaskStatus;
import com.anaplan.client.View;
import com.anaplan.client.Workspace;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Properties;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Program {
    private static int debugLevel = 0;
    private static boolean quiet = false;
    private static Service service = null;
    private static URI serviceLocation = null;
    private static URI proxyLocation = null;
    private static boolean proxyLocationSet = false;
    private static String username = null;
    private static String passphrase = null;
    private static String proxyUsername = null;
    private static boolean proxyUsernameSet = false;
    private static String proxyPassphrase = null;
    private static String keyStorePath = null;
    private static String keyStoreAlias = null;
    private static String keyStorePassword = null;
    private static String certificatePath = null;
    private static boolean userCertificateAuthentication = false;
    private static String workspaceId = null;
    private static String modelId = null;
    private static String moduleId = null;
    private static String viewId = null;
    private static String fileId = null;
    private static String importId = null;
    private static String exportId = null;
    private static String actionId = null;
    private static String processId = null;
    private static TaskResult lastResult = null;
    private static boolean somethingDone = false;
    private static String jdbcUrl = null;
    private static Properties jdbcProps = null;
    private static Integer jdbcFetchSize = null;
    private static TaskParameters taskParameters = new TaskParameters();
    private static Task runningTask = null;
    private static Thread runningThread = null;
    private static boolean closingDown = false;
    private static final Logger logger = LogManager.getLogger((String)Program.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        try {
            if (args.length == 0) {
                Program.displayHelp();
                return;
            }
            int argi = 0;
            while (argi < args.length) {
                String[] propEntry;
                String auth;
                Object[] row;
                Model model;
                String arg;
                if ((arg = args[argi++].intern()) == "-h" || arg == "-help") {
                    Program.displayHelp();
                    somethingDone = true;
                    continue;
                }
                if (arg == "-version") {
                    Program.displayVersion();
                    somethingDone = true;
                    continue;
                }
                if (arg == "-d" || arg == "-debug") {
                    if (debugLevel++ != 0) continue;
                    Program.displayVersion();
                    continue;
                }
                if (arg == "-q" || arg == "-quiet") {
                    quiet = true;
                    continue;
                }
                if (arg == "-W" || arg == "-workspaces") {
                    somethingDone = true;
                    for (Workspace workspace : Program.getService().getWorkspaces()) {
                        logger.info(Program.formatTSV(workspace.getId(), workspace.getName()));
                    }
                    continue;
                }
                if (arg == "-M" || arg == "-models") {
                    somethingDone = true;
                    Workspace workspace = Program.getWorkspace(workspaceId);
                    if (workspace == null) continue;
                    for (Model model2 : workspace.getModels()) {
                        logger.info(Program.formatTSV(model2.getId(), model2.getName()));
                    }
                    continue;
                }
                if (arg == "-MO" || arg == "-modules") {
                    somethingDone = true;
                    model = Program.getModel(workspaceId, modelId);
                    if (model == null) continue;
                    for (Module module : model.getModules()) {
                        logger.info(Program.formatTSV(module.getId(), module.getCode(), module.getName()));
                    }
                    continue;
                }
                if (arg == "-VI" || arg == "-views") {
                    somethingDone = true;
                    Module module = Program.getModule(workspaceId, modelId, moduleId);
                    if (module == null) continue;
                    for (View view : module.getViews()) {
                        logger.info(Program.formatTSV(view.getId(), view.getCode(), view.getName()));
                    }
                    continue;
                }
                if (arg == "-F" || arg == "-files") {
                    somethingDone = true;
                    model = Program.getModel(workspaceId, modelId);
                    if (model == null) continue;
                    for (ServerFile serverFile : model.getServerFiles()) {
                        logger.info(Program.formatTSV(serverFile.getId(), serverFile.getCode(), serverFile.getName()));
                    }
                    continue;
                }
                if (arg == "-I" || arg == "-imports") {
                    somethingDone = true;
                    model = Program.getModel(workspaceId, modelId);
                    if (model == null) continue;
                    for (Import serverImport : model.getImports()) {
                        logger.info(Program.formatTSV(new Object[]{serverImport.getId(), serverImport.getCode(), serverImport.getName(), serverImport.getImportType(), serverImport.getSourceFileId()}));
                    }
                    continue;
                }
                if (arg == "-A" || arg == "-actions") {
                    somethingDone = true;
                    model = Program.getModel(workspaceId, modelId);
                    if (model == null) continue;
                    for (Action serverAction : model.getActions()) {
                        logger.info(Program.formatTSV(serverAction.getId(), serverAction.getCode(), serverAction.getName()));
                    }
                    continue;
                }
                if (arg == "-E" || arg == "-exports") {
                    somethingDone = true;
                    model = Program.getModel(workspaceId, modelId);
                    if (model == null) continue;
                    for (Export serverExport : model.getExports()) {
                        logger.info(Program.formatTSV(serverExport.getId(), serverExport.getCode(), serverExport.getName()));
                    }
                    continue;
                }
                if (arg == "-P" || arg == "-processes") {
                    somethingDone = true;
                    model = Program.getModel(workspaceId, modelId);
                    if (model == null) continue;
                    for (Process serverProcess : model.getProcesses()) {
                        logger.info(Program.formatTSV(serverProcess.getId(), serverProcess.getCode(), serverProcess.getName()));
                    }
                    continue;
                }
                if (arg == "-emd") {
                    somethingDone = true;
                    Export export = Program.getExport(workspaceId, modelId, exportId);
                    ExportMetadata emd = export.getExportMetadata();
                    String delimiter = emd.getDelimiter();
                    if ("\t".equals(delimiter)) {
                        delimiter = "\\t";
                    }
                    logger.info("Export: " + export.getName() + "\ncolumns: " + String.valueOf(emd.getColumnCount()) + "\nrows: " + String.valueOf(emd.getRowCount()) + "\nformat: " + emd.getExportFormat() + "\ndelimiter: " + delimiter + "\nencoding: " + emd.getEncoding() + "\nseparator: " + emd.getSeparator());
                    String[] headerNames = emd.getHeaderNames();
                    DataType[] dataTypes = emd.getDataTypes();
                    String[] listNames = emd.getListNames();
                    for (int i = 0; i < headerNames.length; ++i) {
                        logger.info(" col " + String.valueOf(i) + ":\n  name: " + headerNames[i] + "\n  type: " + dataTypes[i].toString() + "\n  list: " + listNames[i]);
                    }
                    continue;
                }
                if (arg == "-x" || arg == "-execute") {
                    TaskFactory taskFactory = null;
                    if (importId != null) {
                        somethingDone = true;
                        taskFactory = Program.getImport(workspaceId, modelId, importId);
                    } else if (exportId != null) {
                        somethingDone = true;
                        taskFactory = Program.getExport(workspaceId, modelId, exportId);
                    } else if (actionId != null) {
                        somethingDone = true;
                        taskFactory = Program.getAction(workspaceId, modelId, actionId);
                    } else if (processId != null) {
                        taskFactory = Program.getProcess(workspaceId, modelId, processId);
                    }
                    if (taskFactory != null) {
                        somethingDone = true;
                        lastResult = Program.runTask(taskFactory.createTask(taskParameters));
                        continue;
                    }
                    logger.error("An import, export, action or process must be specified before " + arg);
                    continue;
                }
                if (arg == "-gets" || arg == "-getc") {
                    ServerFile serverFile;
                    somethingDone = true;
                    String sourceId = null;
                    if (fileId != null) {
                        sourceId = fileId;
                    } else if (exportId != null) {
                        if (lastResult != null && lastResult.isSuccessful()) {
                            sourceId = exportId;
                        } else {
                            logger.error("Export failed - ignoring content");
                        }
                    }
                    if (null == sourceId || (serverFile = Program.getServerFile(workspaceId, modelId, sourceId, false)) == null) continue;
                    if (arg == "-gets") {
                        int read;
                        InputStream inputStream = serverFile.getDownloadStream();
                        byte[] buffer = new byte[4096];
                        do {
                            if (0 >= (read = inputStream.read(buffer))) continue;
                            System.out.write(buffer, 0, read);
                        } while (-1 != read);
                        System.out.flush();
                        inputStream.close();
                        continue;
                    }
                    CellReader cellReader = serverFile.getDownloadCellReader();
                    String[] row2 = cellReader.getHeaderRow();
                    do {
                        StringBuilder line = new StringBuilder();
                        for (int i = 0; i < row2.length; ++i) {
                            if (line.length() > 0) {
                                line.append('\t');
                            }
                            line.append(row2[i]);
                        }
                        logger.info((Object)line);
                    } while (null != (row2 = cellReader.readDataRow()));
                    continue;
                }
                if (arg == "-puts" || arg == "-putc") {
                    somethingDone = true;
                    ServerFile serverFile = Program.getServerFile(workspaceId, modelId, fileId, true);
                    if (serverFile == null) continue;
                    if (arg == "-puts") {
                        int read;
                        OutputStream uploadStream = serverFile.getUploadStream();
                        byte[] buf = new byte[4096];
                        do {
                            if (0 >= (read = System.in.read(buf))) continue;
                            uploadStream.write(buf, 0, read);
                        } while (-1 != read);
                        uploadStream.close();
                    } else {
                        String line;
                        CellWriter cellWriter = serverFile.getUploadCellWriter();
                        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(System.in));
                        while (null != (line = lnr.readLine())) {
                            row = line.split("\\t");
                            if (1 == lnr.getLineNumber()) {
                                cellWriter.writeHeaderRow(row);
                                continue;
                            }
                            cellWriter.writeDataRow(row);
                        }
                        cellWriter.close();
                    }
                    logger.info("Upload to " + fileId + " completed.");
                    continue;
                }
                if (argi >= args.length) {
                    Program.displayHelp();
                    return;
                }
                if (arg == "-s" || arg == "-service") {
                    serviceLocation = new URI(args[argi++]);
                    continue;
                }
                if (arg == "-u" || arg == "-user") {
                    int colonPosition;
                    if ((colonPosition = (auth = args[argi++]).indexOf(58)) != -1) {
                        Program.setUsername(auth.substring(0, colonPosition));
                        Program.setPassphrase(auth.substring(colonPosition + 1));
                        continue;
                    }
                    Program.setUsername(auth);
                    Program.setPassphrase("?");
                    continue;
                }
                if (arg == "-v" || arg == "-via") {
                    URI uri = new URI(args[argi++]);
                    Program.setProxyLocation(new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), null, null, null));
                    continue;
                }
                if (arg == "-vu" || arg == "-viauser") {
                    int colonPosition;
                    if ((colonPosition = (auth = args[argi++]).indexOf(58)) != -1) {
                        Program.setProxyUsername(auth.substring(0, colonPosition));
                        Program.setProxyPassphrase(auth.substring(colonPosition + 1));
                        continue;
                    }
                    Program.setProxyUsername(auth);
                    Program.setProxyPassphrase("?");
                    continue;
                }
                if (arg == "-c" || arg == "-certificate") {
                    String certificatePath = args[argi++];
                    Program.setCertificatePath(certificatePath);
                    continue;
                }
                if (arg == "-k" || arg == "-keystore") {
                    String keyStorePath = args[argi++];
                    Program.setKeyStorePath(keyStorePath);
                    continue;
                }
                if (arg == "-ka" || arg == "-keystorealias") {
                    String keyStoreAlias = args[argi++];
                    Program.setKeyStoreAlias(keyStoreAlias);
                    continue;
                }
                if (arg == "-kp" || arg == "-keystorepass") {
                    String keyStorePassword = args[argi++];
                    Program.setKeyStorePassword(keyStorePassword);
                    continue;
                }
                if (arg == "-w" || arg == "-workspace") {
                    workspaceId = args[argi++];
                    continue;
                }
                if (arg == "-m" || arg == "-model") {
                    modelId = args[argi++];
                    continue;
                }
                if (arg == "-mo" || arg == "-module") {
                    moduleId = args[argi++];
                    continue;
                }
                if (arg == "-vi" || arg == "-view") {
                    viewId = args[argi++];
                    continue;
                }
                if (arg == "-f" || arg == "-file") {
                    fileId = args[argi++];
                    continue;
                }
                if (arg == "-g" || arg == "-get") {
                    ServerFile serverFile;
                    String sourceId;
                    somethingDone = true;
                    File targetFile = new File(args[argi++]);
                    if (fileId != null) {
                        sourceId = fileId;
                    } else if (exportId != null) {
                        if (lastResult != null && lastResult.isSuccessful()) {
                            sourceId = exportId;
                        } else {
                            logger.error("Export failed - ignoring content");
                            sourceId = null;
                        }
                    } else {
                        sourceId = targetFile.getName();
                    }
                    if (sourceId == null || (serverFile = Program.getServerFile(workspaceId, modelId, sourceId, false)) == null) continue;
                    serverFile.downLoad(targetFile, true);
                    logger.info("The server file " + sourceId + " has been downloaded to " + targetFile);
                    continue;
                }
                if (arg == "-p" || arg == "-put") {
                    somethingDone = true;
                    File sourceFile = new File(args[argi++]);
                    String destId = fileId == null ? sourceFile.getName() : fileId;
                    ServerFile serverFile = Program.getServerFile(workspaceId, modelId, destId, true);
                    if (serverFile == null) continue;
                    serverFile.upLoad(sourceFile, true);
                    logger.info("The file \"" + sourceFile + "\" has been uploaded as " + destId + ".");
                    continue;
                }
                if (arg == "-i" || arg == "-import") {
                    importId = args[argi++];
                    exportId = null;
                    actionId = null;
                    processId = null;
                    continue;
                }
                if (arg == "-e" || arg == "-export") {
                    importId = null;
                    exportId = args[argi++];
                    actionId = null;
                    processId = null;
                    continue;
                }
                if (arg == "-a" || arg == "-action") {
                    importId = null;
                    exportId = null;
                    actionId = args[argi++];
                    processId = null;
                    continue;
                }
                if (arg == "-pr" || arg == "-process") {
                    importId = null;
                    exportId = null;
                    actionId = null;
                    processId = args[argi++];
                    continue;
                }
                if (arg == "-xl" || arg == "-locale") {
                    String[] localeName = args[argi++].split("_");
                    taskParameters.setLocale(localeName[0], localeName.length > 0 ? localeName[1] : null);
                    continue;
                }
                if (arg == "-xc" || arg == "-connectorproperty") {
                    if ((propEntry = args[argi++].split(":", 2)).length != 2) {
                        throw new IllegalArgumentException("expected " + arg + " [(<source>|<type>)/]property:(value|?)");
                    }
                    String[] propKey = propEntry[0].split("/", 2);
                    String prompt = propEntry[0];
                    if (propKey.length < 2) {
                        prompt = "Import source/" + prompt;
                    }
                    String property = propKey[propKey.length - 1];
                    String propValue = Program.promptForValue(prompt, propEntry[1], property.toLowerCase().endsWith("password"));
                    if (propKey.length == 2) {
                        taskParameters.addConnectorParameter(propKey[0], propKey[1], propValue);
                        continue;
                    }
                    taskParameters.addConnectorParameter(propKey[0], propValue);
                    continue;
                }
                if (arg == "-xm" || arg == "-mappingproperty") {
                    if ((propEntry = args[argi++].split(":", 2)).length != 2) {
                        throw new IllegalArgumentException("expected " + arg + " [(<import id>|<import name>)/]dimension" + ":(value|?)");
                    }
                    String[] propKey = propEntry[0].split("/", 2);
                    String propValue = Program.promptForValue(propEntry[0], propEntry[1], false);
                    if (propKey.length == 2) {
                        taskParameters.addMappingParameter(propKey[0], propKey[1], propValue);
                        continue;
                    }
                    taskParameters.addMappingParameter(propKey[0], propValue);
                    continue;
                }
                if (arg == "-o" || arg == "-output") {
                    File outputFile = new File(args[argi++]);
                    Program.retrieveOutput(lastResult, outputFile);
                    continue;
                }
                if (arg == "-loadclass") {
                    String className = args[argi++];
                    try {
                        Class.forName(className);
                    }
                    catch (Throwable thrown) {
                        if (debugLevel > 0) {
                            thrown.printStackTrace();
                            continue;
                        }
                        logger.error("Warning: -loadclass failed (" + Program.formatThrowable(thrown) + ")");
                    }
                    continue;
                }
                if (arg == "-jdbcurl") {
                    jdbcUrl = args[argi++];
                    jdbcProps = new Properties();
                    continue;
                }
                if (arg.startsWith("-jdbcuser")) {
                    String jdbcuser;
                    int colonIndex;
                    if (-1 == (colonIndex = (jdbcuser = args[argi++]).indexOf(":"))) {
                        jdbcuser = Program.promptForValue("JDBC user", jdbcuser, false);
                        jdbcProps.put("user", jdbcuser);
                        continue;
                    }
                    String jdbcpassword = jdbcuser.substring(1 + colonIndex);
                    jdbcuser = jdbcuser.substring(0, colonIndex);
                    jdbcuser = Program.promptForValue("JDBC User", jdbcuser, false);
                    jdbcpassword = Program.promptForValue("JDBC Password", jdbcpassword, true);
                    jdbcProps.put("user", jdbcuser);
                    jdbcProps.put("password", jdbcpassword);
                    continue;
                }
                if (arg.startsWith("-jdbcfetchsize")) {
                    try {
                        jdbcFetchSize = new Integer(args[argi++]);
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Warning: failed to parse jdbcfetchsize parameter");
                    }
                    continue;
                }
                if (arg.startsWith("-jdbcproperty")) {
                    String propertyName = args[argi++];
                    String propertyValue = null;
                    int colonIndex = propertyName.indexOf(":");
                    if (-1 != colonIndex) {
                        propertyValue = propertyName.substring(1 + colonIndex);
                        propertyName = propertyName.substring(0, colonIndex);
                    }
                    propertyValue = Program.promptForValue("JDBC " + propertyName, propertyValue, propertyName.equals("password"));
                    jdbcProps.put(propertyName, propertyValue);
                    continue;
                }
                if (arg == "-jdbcquery") {
                    ServerFile serverFile;
                    String query;
                    somethingDone = true;
                    if ((query = args[argi++]).startsWith("@")) {
                        String queryLine;
                        LineNumberReader queryFileReader = new LineNumberReader(new FileReader(query.substring(1)));
                        StringBuilder queryBuilder = new StringBuilder();
                        while (null != (queryLine = queryFileReader.readLine())) {
                            queryBuilder.append(queryLine).append('\n');
                        }
                        queryFileReader.close();
                        query = queryBuilder.toString();
                        if (debugLevel > 0) {
                            logger.error("JDBC query:");
                            logger.error(query);
                        }
                    }
                    if ((serverFile = Program.getServerFile(workspaceId, modelId, fileId, true)) == null) continue;
                    CellWriter cellWriter = null;
                    CellReader cellReader = null;
                    try {
                        cellWriter = serverFile.getUploadCellWriter();
                        cellReader = new JDBCCellReader(jdbcUrl, jdbcProps, query, jdbcFetchSize, debugLevel > 0);
                        row = cellReader.getHeaderRow();
                        cellWriter.writeHeaderRow(row);
                        int rowCount = 0;
                        do {
                            if (null == (row = cellReader.readDataRow())) continue;
                            cellWriter.writeDataRow(row);
                            ++rowCount;
                        } while (null != row);
                        cellWriter.close();
                        cellWriter = null;
                        logger.info("Transferred " + rowCount + " records");
                        continue;
                    }
                    finally {
                        if (cellReader != null) {
                            cellReader.close();
                        }
                        if (cellWriter != null) {
                            cellWriter.abort();
                        }
                        continue;
                    }
                }
                Program.displayHelp();
                return;
            }
            if (!somethingDone) {
                Program.displayHelp();
            }
            Program.closeDown();
        }
        catch (Throwable thrown) {
            if (debugLevel > 0) {
                Throwable cause = thrown;
                while (null != cause.getCause()) {
                    logger.error((Object)cause);
                    cause = cause.getCause();
                }
                cause.printStackTrace();
            } else if (!(thrown instanceof InterruptedException)) {
                logger.error(Program.formatThrowable(thrown));
            }
            Program.closeDown();
            System.exit(1);
        }
    }

    protected static synchronized void closeDown() {
        if (service != null && runningTask == null) {
            service.close();
            service = null;
        }
    }

    protected static synchronized TaskResult runTask(Task task) throws AnaplanAPIException, InterruptedException {
        runningTask = task;
        runningThread = Thread.currentThread();
        TaskResult result = Program.trackRunningTask(false);
        runningThread = null;
        runningTask = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void cancelRunningTask() {
        if (runningTask != null) {
            try {
                if (System.console() != null) {
                    System.console().printf("\rClient terminated, cancelling...", new Object[0]);
                }
                runningTask.cancel();
                Program.trackRunningTask(true);
            }
            catch (Throwable thrown) {
                if (debugLevel > 0) {
                    Throwable cause = thrown;
                    while (null != cause.getCause()) {
                        logger.error((Object)cause);
                        cause = cause.getCause();
                    }
                    cause.printStackTrace();
                } else {
                    logger.error(Program.formatThrowable(thrown));
                }
            }
            finally {
                runningTask = null;
                Program.closeDown();
            }
        }
    }

    private static synchronized TaskResult trackRunningTask(boolean wasClosingDown) throws AnaplanAPIException, InterruptedException {
        String message;
        TaskStatus status = null;
        int lastStatusLength = 4;
        int interval = 1000;
        int totalTime = 0;
        int failCount = 0;
        if (System.console() != null) {
            System.console().printf("\n", new Object[0]);
        }
        do {
            block23: {
                if (!wasClosingDown && closingDown) {
                    throw new InterruptedException();
                }
                if (interval > 0) {
                    Thread.sleep(interval);
                    totalTime += interval;
                }
                interval = wasClosingDown ? 500 : (totalTime > 60000 ? 60000 : (totalTime > 10000 ? 10000 : 1000));
                try {
                    status = runningTask.getStatus();
                    failCount = 0;
                }
                catch (AnaplanAPIException thrown) {
                    status = null;
                    if (++failCount > 30) {
                        throw new AnaplanAPIException("Task was started, but server cannot now be reached - giving up after 30 attempts", thrown);
                    }
                    if (quiet || System.console() == null) break block23;
                    String message2 = "";
                    message2 = debugLevel > 0 ? "Failed to get status (" + Program.formatThrowable(thrown) + "); retrying in " + interval / 1000 + "s\n" : "Checking in " + interval / 1000 + "s";
                    String format = "\r%-" + lastStatusLength + "s";
                    System.console().printf(format, message2);
                    lastStatusLength = message2.length();
                }
            }
            if (status == null || quiet || System.console() == null) continue;
            if (status.getCurrentStep() != null) {
                message = status.getCurrentStep();
            } else {
                switch (status.getTaskState()) {
                    case NOT_STARTED: {
                        message = "Waiting to start";
                        break;
                    }
                    case IN_PROGRESS: {
                        message = "In progress";
                        break;
                    }
                    case COMPLETE: {
                        message = "Complete";
                        break;
                    }
                    case CANCELLING: {
                        message = "Cancelling";
                        break;
                    }
                    case CANCELLED: {
                        message = "Cancelled";
                        break;
                    }
                    default: {
                        message = status.getTaskState().toString();
                        message = message.replace('_', ' ');
                        message = message.charAt(0) + message.substring(1).toLowerCase();
                    }
                }
            }
            if (status.getProgress() > 0.0) {
                message = message + " (" + Math.floor(status.getProgress() * 1000.0) / 10.0 + "%)";
            }
            String format = "\r%-" + lastStatusLength + "s";
            System.console().printf(format, message);
            lastStatusLength = message.length();
        } while ((!wasClosingDown || totalTime <= 1000) && (status == null || status.getTaskState() != TaskStatus.State.COMPLETE && status.getTaskState() != TaskStatus.State.CANCELLED));
        if (status.getTaskState() == TaskStatus.State.CANCELLED) {
            message = "The operation was cancelled";
            if (status.getCancelledBy() != null) {
                message = message + " by " + status.getCancelledBy();
            }
            message = status.getResult() != null ? message + "; some actions may have completed." : message + ".";
        } else {
            message = status.getResult() != null ? (status.getResult().isSuccessful() ? "The operation was successful." : "The operation failed.") : "No result was provided.";
        }
        if (System.console() != null) {
            System.console().printf("\r%-" + lastStatusLength + "s\n", message);
        } else {
            logger.info(message);
        }
        if (status.getResult() != null) {
            logger.info(status.getResult().toString());
        }
        return status.getResult();
    }

    protected static void retrieveOutput(TaskResult taskResult, File outputLocation) throws AnaplanAPIException, IOException {
        if (taskResult != null) {
            if (!taskResult.getNestedResults().isEmpty()) {
                if (outputLocation.exists() && !outputLocation.isDirectory()) {
                    throw new IllegalArgumentException("Process dumps require a directory, but path \"" + outputLocation.getPath() + " is not a directory");
                }
                if (!outputLocation.exists() && !outputLocation.mkdirs()) {
                    throw new AnaplanAPIException("Failed to create directory " + outputLocation.getPath());
                }
                int index = 0;
                for (TaskResult nestedResult : taskResult.getNestedResults()) {
                    ServerFile nestedDumpServerFile = nestedResult.getFailureDump();
                    if (nestedDumpServerFile != null) {
                        String fileName = "" + index;
                        if (nestedResult.getObjectId() != null) {
                            fileName = fileName + "-" + nestedResult.getObjectId();
                        }
                        if (nestedResult.getObjectName() != null) {
                            fileName = fileName + "-" + nestedResult.getObjectName();
                        }
                        File nestedFile = new File(outputLocation, fileName);
                        nestedDumpServerFile.downLoad(nestedFile, true);
                        logger.info("Dump file written to \"" + nestedFile + "\"");
                    }
                    ++index;
                }
            } else if (taskResult.isFailureDumpAvailable()) {
                ServerFile failureDump = taskResult.getFailureDump();
                failureDump.downLoad(outputLocation, true);
                logger.info("Dump file written to \"" + outputLocation + "\"");
            }
        } else {
            logger.info("No dump file is available.");
            if (outputLocation.exists() && !outputLocation.isDirectory()) {
                outputLocation.delete();
            }
        }
    }

    protected static String formatThrowable(Throwable thrown) {
        StringBuilder message = new StringBuilder(thrown instanceof AnaplanAPIException ? "AnaplanAPI" : thrown.getClass().getSimpleName());
        if (message.length() > 9 && message.toString().endsWith("Exception")) {
            message.delete(message.length() - 9, message.length());
        }
        for (int i = 1; i < message.length() - 1; ++i) {
            char pc = message.charAt(i - 1);
            char ch = message.charAt(i);
            char nc = message.charAt(i + 1);
            if (!Character.isUpperCase(ch)) continue;
            if (!Character.isUpperCase(nc)) {
                message.setCharAt(i, Character.toLowerCase(ch));
            }
            if (Character.isUpperCase(pc) && Character.isUpperCase(nc)) continue;
            message.insert(i++, ' ');
        }
        if (null != thrown.getMessage()) {
            message.append(": ").append(thrown.getMessage());
        }
        if (null != thrown.getCause()) {
            message.append(" (").append(Program.formatThrowable(thrown.getCause())).append(')');
        }
        return message.toString();
    }

    protected static String formatTSV(Object ... values) {
        StringBuilder tsv = new StringBuilder();
        for (Object value : values) {
            if (tsv.length() > 0) {
                tsv.append('\t');
            }
            if (value == null) continue;
            tsv.append(value.toString());
        }
        return tsv.toString();
    }

    protected static ServerFile getServerFile(String workspaceId, String modelId, String fileId, boolean create) throws AnaplanAPIException {
        Model model = Program.getModel(workspaceId, modelId);
        if (model == null) {
            return null;
        }
        if (fileId == null || fileId.isEmpty()) {
            logger.error("A file ID must be provided");
            return null;
        }
        ServerFile serverFile = model.getServerFile(fileId);
        if (serverFile == null) {
            if (create) {
                serverFile = model.createServerFileImportDataSource(fileId, "Anaplan Connect");
            } else {
                logger.error("File \"" + fileId + "\" not found in workspace " + workspaceId + ", model " + modelId);
            }
        }
        return serverFile;
    }

    protected static Import getImport(String workspaceId, String modelId, String importId) throws AnaplanAPIException {
        Import serverImport;
        Model model = Program.getModel(workspaceId, modelId);
        if (model == null) {
            return null;
        }
        if (importId == null || importId.isEmpty()) {
            logger.error("An import ID, code or name must be provided");
        }
        if ((serverImport = model.getImport(importId)) == null) {
            logger.error("Import \"" + importId + "\" not found in workspace " + workspaceId + ", model " + modelId);
        }
        return serverImport;
    }

    protected static Export getExport(String workspaceId, String modelId, String exportId) throws AnaplanAPIException {
        Export serverExport;
        Model model = Program.getModel(workspaceId, modelId);
        if (model == null) {
            return null;
        }
        if (exportId == null || exportId.isEmpty()) {
            logger.error("An export ID, code or name must be provided");
        }
        if ((serverExport = model.getExport(exportId)) == null) {
            logger.error("Export \"" + exportId + "\" not found in workspace " + workspaceId + ", model " + modelId);
        }
        return serverExport;
    }

    protected static Action getAction(String workspaceId, String modelId, String actionId) throws AnaplanAPIException {
        Action serverAction;
        Model model = Program.getModel(workspaceId, modelId);
        if (model == null) {
            return null;
        }
        if (actionId == null || actionId.isEmpty()) {
            logger.error("An action ID, code or name must be provided");
        }
        if ((serverAction = model.getAction(actionId)) == null) {
            logger.error("Action \"" + actionId + "\" not found in workspace " + workspaceId + ", model " + modelId);
        }
        return serverAction;
    }

    protected static Process getProcess(String workspaceId, String modelId, String processId) throws AnaplanAPIException {
        Process serverProcess;
        Model model = Program.getModel(workspaceId, modelId);
        if (model == null) {
            return null;
        }
        if (processId == null || processId.isEmpty()) {
            logger.error("A process ID, code or name must be provided");
        }
        if ((serverProcess = model.getProcess(processId)) == null) {
            logger.error("Process \"" + processId + "\" not found in workspace " + workspaceId + ", model " + modelId);
        }
        return serverProcess;
    }

    protected static View getView(String workspaceId, String modelId, String moduleId, String viewId) throws AnaplanAPIException {
        Module module = Program.getModule(workspaceId, modelId, moduleId);
        if (module == null) {
            return null;
        }
        if (viewId == null || viewId.isEmpty()) {
            logger.error("A view ID must be provided");
            return null;
        }
        View view = module.getView(viewId);
        if (view == null) {
            logger.error("View \"" + viewId + "\" not found in workspace \"" + workspaceId + "\", model \"" + modelId + "\", module \"" + moduleId + "\"");
        }
        return view;
    }

    protected static Module getModule(String workspaceId, String modelId, String moduleId) throws AnaplanAPIException {
        Model model = Program.getModel(workspaceId, modelId);
        if (model == null) {
            return null;
        }
        if (moduleId == null || moduleId.isEmpty()) {
            logger.error("A module ID must be provided");
            return null;
        }
        Module module = model.getModule(moduleId);
        if (module == null) {
            logger.error("Module \"" + moduleId + "\" not found in workspace \"" + workspaceId + "\", model \"" + modelId + "\"");
        }
        return module;
    }

    protected static Model getModel(String workspaceId, String modelId) throws AnaplanAPIException {
        Workspace workspace = Program.getWorkspace(workspaceId);
        if (workspace == null) {
            return null;
        }
        if (modelId == null || modelId.isEmpty()) {
            logger.error("A model ID must be provided");
            return null;
        }
        Model model = workspace.getModel(modelId);
        if (model == null) {
            logger.error("Model \"" + modelId + "\" not found in workspace \"" + workspaceId + "\"");
        }
        return model;
    }

    protected static Workspace getWorkspace(String workspaceId) throws AnaplanAPIException {
        if (workspaceId == null || workspaceId.isEmpty()) {
            logger.error("A workspace ID must be provided");
            return null;
        }
        Workspace result = Program.getService().getWorkspace(workspaceId);
        if (result == null) {
            logger.error("Workspace \"" + workspaceId + "\" does not exist or is not available to this user");
        }
        return result;
    }

    protected static Service getService() throws AnaplanAPIException {
        if (service == null) {
            service = serviceLocation != null ? new Service(serviceLocation) : new Service();
            service.setDebugLevel(debugLevel);
            service.setServiceCredentials(Program.getServiceCredentials());
            if (proxyLocationSet) {
                service.setProxyLocation(proxyLocation);
                Credentials proxyCredentials = Program.getProxyCredentials();
                if (proxyCredentials != null) {
                    service.setProxyCredentials(proxyCredentials);
                }
            }
        }
        return service;
    }

    protected static Credentials getServiceCredentials() throws AnaplanAPIException {
        if (userCertificateAuthentication) {
            try {
                return new Credentials(Program.getCertificate());
            }
            catch (Exception e) {
                throw new AnaplanAPIException("Could not initialise service credentials", e);
            }
        }
        return new Credentials(Program.getUsername(), Program.getPassphrase());
    }

    protected static Credentials getProxyCredentials() {
        if (!proxyUsernameSet) {
            return null;
        }
        String[] parts = Program.getProxyUsername().split("\\\\");
        if (parts.length > 1) {
            String domain = parts[0];
            String workstation = null;
            String user = parts[1];
            if (parts.length > 2) {
                workstation = user;
                user = parts[2];
            }
            return new Credentials(user, Program.getProxyPassphrase(), domain, workstation);
        }
        return new Credentials(parts[0], Program.getProxyPassphrase());
    }

    protected static String getUsername() {
        if (username == null || username.isEmpty()) {
            Console console = System.console();
            if (console != null) {
                username = console.readLine("Username:", new Object[0]);
            } else {
                throw new UnsupportedOperationException("Username must be specified");
            }
        }
        return username;
    }

    protected static String getPassphrase() {
        if (passphrase == null || passphrase.isEmpty() || passphrase.equals("?")) {
            Console console = System.console();
            if (console != null) {
                passphrase = new String(console.readPassword("Password:", new Object[0]));
            } else {
                throw new UnsupportedOperationException("Password must be specified");
            }
        }
        return passphrase;
    }

    protected static void setServiceLocation(URI serviceLocation) {
        Program.serviceLocation = serviceLocation;
    }

    protected static void setProxyLocation(URI proxyLocation) {
        Program.proxyLocation = proxyLocation;
        proxyLocationSet = true;
    }

    protected static String getProxyUsername() {
        if ("?".equals(proxyUsername)) {
            Console console = System.console();
            if (console != null) {
                proxyUsername = console.readLine("Proxy username:", new Object[0]);
            } else {
                throw new UnsupportedOperationException("Proxy username must be specified");
            }
        }
        return proxyUsername;
    }

    protected static String getProxyPassphrase() {
        if ("?".equals(proxyPassphrase)) {
            Console console = System.console();
            if (console != null) {
                proxyPassphrase = new String(console.readPassword("Proxy password:", new Object[0]));
            } else {
                throw new UnsupportedOperationException("Proxy password must be specified");
            }
        }
        return proxyPassphrase;
    }

    protected static void setDebugLevel(int debugLevel) {
        Program.debugLevel = debugLevel;
    }

    protected static void setUsername(String username) {
        Program.username = username;
    }

    protected static void setPassphrase(String passphrase) {
        Program.passphrase = passphrase;
    }

    protected static void setProxyUsername(String username) {
        proxyUsername = username;
        proxyUsernameSet = true;
    }

    protected static void setProxyPassphrase(String passphrase) {
        proxyPassphrase = passphrase;
    }

    protected static X509Certificate getCertificate() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        String certificatePath = Program.getCertificatePath();
        String keyStorePath = Program.getKeyStorePath();
        if (certificatePath != null) {
            File certificateFile = new File(certificatePath);
            if (certificateFile.isFile()) {
                return Program.loadCertificateFromFile(certificateFile);
            }
            throw new RuntimeException("The specified certificate path '" + certificatePath + "' is invalid");
        }
        if (keyStorePath != null) {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            File clientKeyStoreLocation = new File(keyStorePath);
            if (clientKeyStoreLocation.isFile()) {
                FileInputStream keystoreInput = new FileInputStream(clientKeyStoreLocation);
                String keyStorePassword = Program.getKeyStorePassword();
                keyStore.load(keystoreInput, keyStorePassword.toCharArray());
                String alias = Program.getKeyStoreAlias();
                return (X509Certificate)keyStore.getCertificate(alias);
            }
            throw new IllegalArgumentException("The specified key store path '" + keyStorePath + "' is invalid");
        }
        throw new RuntimeException("Could not load a certificate for authentication");
    }

    protected static String getCertificatePath() {
        return certificatePath;
    }

    protected static void setCertificatePath(String certificatePath) {
        Program.certificatePath = certificatePath;
        userCertificateAuthentication = true;
    }

    protected static String getKeyStorePath() {
        return keyStorePath;
    }

    protected static void setKeyStorePath(String keyStorePath) {
        Program.keyStorePath = keyStorePath;
        userCertificateAuthentication = true;
    }

    protected static String getKeyStoreAlias() {
        return keyStoreAlias;
    }

    protected static void setKeyStoreAlias(String keyStoreAlias) {
        Program.keyStoreAlias = keyStoreAlias;
    }

    protected static String getKeyStorePassword() {
        if ("?".equals(keyStorePassword)) {
            Program.promptForKeystorePassword();
        } else if (keyStorePassword == null || keyStorePassword.isEmpty()) {
            File userHomeDirectory = new File(System.getProperty("user.home"));
            File passwordFile = new File(userHomeDirectory, ".anaplan/api-client/keystore-access.txt");
            if (passwordFile.isFile()) {
                try {
                    String rawPassword = Program.readFileContents(passwordFile);
                    return EncodingUtils.decodeAndXor(rawPassword);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Password file could not be read");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Password file could not be read");
                }
            }
            Program.promptForKeystorePassword();
        }
        return keyStorePassword;
    }

    protected static void setKeyStorePassword(String keyStorePassword) {
        Program.keyStorePassword = keyStorePassword;
    }

    protected static String promptForValue(String propertyName, String propertyValue, boolean password) {
        if (null == propertyValue || 0 == propertyValue.length() || propertyValue.equals("?")) {
            Console console = System.console();
            if (console != null) {
                propertyValue = password ? new String(console.readPassword(propertyName + ":", new Object[0])) : new String(console.readLine(propertyName + ":", new Object[0]));
            } else {
                throw new UnsupportedOperationException("Value for " + propertyName + " must be specified");
            }
        }
        return propertyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileContents(File file) throws FileNotFoundException {
        StringBuilder fileContents = new StringBuilder((int)file.length());
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNext()) {
                fileContents.append(scanner.next());
            }
            String string = fileContents.toString();
            return string;
        }
    }

    private static X509Certificate loadCertificateFromFile(File certificateFile) throws CertificateException, FileNotFoundException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        FileInputStream certificateStream = new FileInputStream(certificateFile);
        Collection<? extends Certificate> c = certificateFactory.generateCertificates(certificateStream);
        Certificate[] certs = new Certificate[c.toArray().length];
        if (c.size() == 1) {
            return (X509Certificate)c.iterator().next();
        }
        throw new RuntimeException("Certificate file must contain only one certificate (chain length was " + certs.length + ")");
    }

    private static void promptForKeystorePassword() {
        Console console = System.console();
        if (console == null) {
            throw new UnsupportedOperationException("Key store password must be specified");
        }
        keyStorePassword = new String(console.readPassword("Key store password:", new Object[0]));
    }

    private static void displayHelp() {
        File passwordFile = new File(System.getProperty("user.dir"), ".anaplan/api-client/keystore-access.txt");
        logger.error("Options are:\n\nGeneral:\n--------\n(-h|-help): display this help\n(-version): display version information\n(-d|-debug): Show more detailed output\n(-q|-quiet): Show less detailed output\n\nConnection:\n-----------\n(-s|-service) <service URI>: API service endpoint (defaults to https://api.anaplan.com/)\n(-u|-user) <username>[:<password>]: Anaplan user name + (optional) password\n(-c|-certificate) <certificate path>: Path to user certificate used for authentication (an alternative to using a key store)\n(-k|-keystore) <keystore path>: Path to local key store containing user certificate(s) for authentication\n(-kp|-keystorepass) <keystore password>: Password for the key store (if not provided, password is read from obfuscated file '" + passwordFile.getAbsolutePath() + "', or prompted for)\n" + "(-ka|-keystorealias) <keystore alias>" + ": Alias of the public certificate in the specified key store\n" + "(-v|-via) <proxy URI>: use specified proxy\n" + "(-vu|-viauser) [<domain>[\\<workstation>]\\]<username>[:<password>]: use proxy credentials\n" + "\n" + "Workspace Contents:\n" + "-------------------\n" + "(-W|-workspaces): list available workspaces\n" + "(-w|-workspace) (<id>|<name>): select a workspace by id/name\n" + "(-M|-models): list available models in selected workspace\n" + "(-m|-model) (<id>|<name>): select a model by id/name\n" + "(-MO|-modules): list available modules in selected model\n" + "(-mo|-module): (<id>|<name>): select a module by id/name\n" + "(-VI|-views): list available views in selected module\n" + "(-vi|-view): (<id>|<name>): select a view by id/name\n" + "(-F|-files): list available server files in selected model\n" + "(-f|-file) (<id>|<name>): select a server file by id/name\n" + "\n" + "Data Transfer:\n" + "--------------\n" + "(-g|-get) <local path>: Download specified server file to local file\n" + "-gets Write specified server file to standard output\n" + "-getc Write tab-separated server file to standard output\n" + "(-p|-put) <local path>: Upload to specified server file from local file\n" + "-puts Upload to specified server file from standard input\n" + "-putc Upload to specified server file from tab-separated standard input\n" + "\n" + "Server Actions:\n" + "---------------\n" + "(-I|-imports): list available imports in selected model\n" + "(-i|-import) (<id>|<name>): select an import by id/name\n" + "(-E|-exports): list available exports in selected model\n" + "(-e|-export) (<id>|<name>): select an export by id/name\n" + "(-A|-actions): list available actions in selected model\n" + "(-a|-action) (<id>|<name>): select an action by id/name\n" + "(-P|-processes): list available processes in selected model\n" + "(-pr|-process) <id/name>: select a process by id/name\n" + "(-xl|-locale) <locale> Specify locale (eg en_US) to perform server opertion\n" + "(-xc|-connectorproperty) [(<source>|<type>)/]property:(value|?):\n" + "    specify import data source connection property\n" + "(-xm|-mappingproperty) [(<import id>|<import name>)/]dimension:(value|?):\n" + "    specify prompt-at-runtime import mapping value" + "(-x|-execute): Run the selected import/export/action/process\n" + "\n" + "Action Information:\n" + "-------------------\n" + "(-o|-output) <local path>: Retrieve dump file(s) for completed import/process\n" + "-emd: Describe layout of an export (metadata)\n" + "\n" + "JDBC:\n" + "-----\n" + "-loadclass <class name>: Load a Java class\n" + "-jdbcurl: JDBC URL for -jdbcquery to connect to\n" + "-jdbcuser (<username>|?)[:(<password>|?)]: JDBC username and password\n" + "-jdbcproperty <propname>:(<propval>|?): set JDBC connection property\n" + "-jdbcquery (<query>|@<queryfile>): retrieve data from JDBC data source\n" + "-jdbcfetchsize <size>: hint to transfer <size> records at a time\n");
    }

    private static void displayVersion() {
        logger.info("Anaplan Connect 1.3.6-dev");
        logger.info(System.getProperty("java.vm.name") + " (" + System.getProperty("java.vendor") + ")/" + System.getProperty("java.vm.version") + " (" + System.getProperty("java.version") + ")");
        logger.info(System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")/" + System.getProperty("os.version"));
    }

    static {
        try {
            Thread cancelThread = new Thread(){

                @Override
                public void run() {
                    block3: {
                        closingDown = true;
                        Thread runner = runningThread;
                        if (runner != null) {
                            try {
                                runner.interrupt();
                            }
                            catch (Throwable thrown) {
                                if (debugLevel <= 0) break block3;
                                thrown.printStackTrace();
                            }
                        }
                    }
                    Program.cancelRunningTask();
                }
            };
            cancelThread.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(cancelThread);
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
        }
    }
}

