/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.Action;
import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.AnaplanApiClientObject;
import com.anaplan.client.Export;
import com.anaplan.client.Import;
import com.anaplan.client.Module;
import com.anaplan.client.Process;
import com.anaplan.client.ServerFile;
import com.anaplan.client.Workspace;
import com.anaplan.client.serialization.TypeWrapper;
import java.util.ArrayList;
import java.util.List;

public class Model
extends AnaplanApiClientObject {
    static final TypeWrapper<List<Data>> DATA_LIST_TYPE = new TypeWrapper<List<Data>>(){};
    private final Workspace workspace;
    private final Data data;

    Model(Workspace workspace, Data data) {
        super(workspace.getService());
        this.workspace = workspace;
        this.data = data;
    }

    final Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    final String getPath() {
        return this.getWorkspace().getPath() + "/models/" + this.getId();
    }

    public String getId() {
        return this.data.id;
    }

    public String getName() {
        return this.data.name;
    }

    public List<Module> getModules() throws AnaplanAPIException {
        List<Module.Data> response = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/modules", this.getSerializationHandler().getContentType()), Module.DATA_LIST_TYPE);
        ArrayList<Module> result = new ArrayList<Module>(response.size());
        for (Module.Data moduleData : response) {
            Module module = new Module(this, moduleData);
            result.add(module);
        }
        return result;
    }

    public Module getModule(String identifier) throws AnaplanAPIException {
        for (Module module : this.getModules()) {
            if (!identifier.equals(module.getId()) && !identifier.equalsIgnoreCase(module.getCode()) && !identifier.equalsIgnoreCase(module.getName())) continue;
            return module;
        }
        return null;
    }

    public List<ServerFile> getServerFiles() throws AnaplanAPIException {
        List<ServerFile.Data> response = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/files", this.getSerializationHandler().getContentType()), ServerFile.DATA_LIST_TYPE);
        ArrayList<ServerFile> result = new ArrayList<ServerFile>(response.size());
        for (ServerFile.Data serverFileData : response) {
            ServerFile serverFile = new ServerFile(this, serverFileData);
            result.add(serverFile);
        }
        return result;
    }

    public ServerFile getServerFile(String identifier) throws AnaplanAPIException {
        for (ServerFile serverFile : this.getServerFiles()) {
            if (!identifier.equals(serverFile.getId()) && !identifier.equalsIgnoreCase(serverFile.getCode()) && !identifier.equalsIgnoreCase(serverFile.getName())) continue;
            return serverFile;
        }
        return null;
    }

    public ServerFile createServerFileImportDataSource(String name, String origin) throws AnaplanAPIException {
        ServerFile.Data data = new ServerFile.Data();
        data.name = name;
        data.chunkCount = -1;
        data.origin = origin;
        byte[] content = this.getSerializationHandler().serialize(data, ServerFile.DATA_TYPE);
        String contentType = this.getSerializationHandler().getContentType();
        content = this.getTransportProvider().post(this.getPath() + "/files/" + name, content, contentType, contentType);
        if (content != null) {
            data = this.getSerializationHandler().deserialize(content, ServerFile.DATA_TYPE);
        }
        ServerFile serverFile = new ServerFile(this, data);
        return serverFile;
    }

    public List<Import> getImports() throws AnaplanAPIException {
        List<Import.Data> response = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/imports", this.getSerializationHandler().getContentType()), Import.DATA_LIST_TYPE);
        ArrayList<Import> result = new ArrayList<Import>(response.size());
        for (Import.Data importData : response) {
            result.add(new Import(this, importData));
        }
        return result;
    }

    public Import getImport(String identifier) throws AnaplanAPIException {
        for (Import serverImport : this.getImports()) {
            if (!identifier.equals(serverImport.getId()) && !identifier.equalsIgnoreCase(serverImport.getCode()) && !identifier.equalsIgnoreCase(serverImport.getName())) continue;
            return serverImport;
        }
        return null;
    }

    public List<Export> getExports() throws AnaplanAPIException {
        List<Export.Data> response = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/exports", this.getSerializationHandler().getContentType()), Export.DATA_LIST_TYPE);
        ArrayList<Export> result = new ArrayList<Export>(response.size());
        for (Export.Data exportData : response) {
            result.add(new Export(this, exportData));
        }
        return result;
    }

    public Export getExport(String identifier) throws AnaplanAPIException {
        for (Export serverExport : this.getExports()) {
            if (!identifier.equals(serverExport.getId()) && !identifier.equalsIgnoreCase(serverExport.getCode()) && !identifier.equalsIgnoreCase(serverExport.getName())) continue;
            return serverExport;
        }
        return null;
    }

    public List<Action> getActions() throws AnaplanAPIException {
        List<Action.Data> response = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/actions", this.getSerializationHandler().getContentType()), Action.DATA_LIST_TYPE);
        ArrayList<Action> result = new ArrayList<Action>(response.size());
        for (Action.Data actionData : response) {
            result.add(new Action(this, actionData));
        }
        return result;
    }

    public Action getAction(String identifier) throws AnaplanAPIException {
        for (Action serverAction : this.getActions()) {
            if (!identifier.equals(serverAction.getId()) && !identifier.equalsIgnoreCase(serverAction.getCode()) && !identifier.equalsIgnoreCase(serverAction.getName())) continue;
            return serverAction;
        }
        return null;
    }

    public List<Process> getProcesses() throws AnaplanAPIException {
        List<Process.Data> response = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/processes", this.getSerializationHandler().getContentType()), Process.DATA_LIST_TYPE);
        ArrayList<Process> result = new ArrayList<Process>(response.size());
        for (Process.Data actionData : response) {
            result.add(new Process(this, actionData));
        }
        return result;
    }

    public Process getProcess(String identifier) throws AnaplanAPIException {
        for (Process serverProcess : this.getProcesses()) {
            if (!identifier.equals(serverProcess.getId()) && !identifier.equalsIgnoreCase(serverProcess.getCode()) && !identifier.equalsIgnoreCase(serverProcess.getName())) continue;
            return serverProcess;
        }
        return null;
    }

    public byte[] doRefresh(byte[] request) throws AnaplanAPIException {
        String contentType = this.getSerializationHandler().getContentType();
        byte[] response = this.getTransportProvider().post(this.getPath() + "/refresh", request, contentType, contentType);
        return response;
    }

    static final class Data {
        String id;
        String name;

        Data() {
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            return this.id.equals(data.id) && this.name.equals(data.name);
        }

        public int hashCode() {
            return this.id.hashCode() * 31 + this.name.hashCode();
        }
    }
}

