/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;

public class JDBCCellReader
implements CellReader {
    private static final Logger logger = Logger.getLogger("anaplan-connect.jdbc");
    private Connection connection;
    private boolean autoCommit;
    private Statement statement;
    private ResultSet resultSet;
    private int columnCount;
    private String[] headerRow;
    private int[] columnTypes;
    private boolean debug;

    public JDBCCellReader(String jdbcUrl, Properties jdbcProperties, String query) throws SQLException {
        this(jdbcUrl, jdbcProperties, query, null, false);
    }

    public JDBCCellReader(String jdbcUrl, Properties jdbcProperties, String query, Integer fetchSize, boolean debug) throws SQLException {
        block7: {
            block6: {
                this.connection = DriverManager.getConnection(jdbcUrl, jdbcProperties);
                try {
                    this.connection.setAutoCommit(false);
                    this.autoCommit = false;
                }
                catch (SQLException sqle) {
                    this.autoCommit = true;
                    if (!debug) break block6;
                    logger.warning("Warning: setAutoCommit failed(" + sqle + ")");
                }
            }
            this.statement = this.connection.createStatement(1003, 1007);
            if (fetchSize != null) {
                try {
                    this.statement.setFetchSize(fetchSize);
                }
                catch (SQLException sqle) {
                    if (!debug) break block7;
                    logger.warning("Warning: setFetchSize failed(" + sqle + ")");
                }
            }
        }
        this.resultSet = this.statement.executeQuery(query);
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        this.columnCount = resultSetMetaData.getColumnCount();
        this.headerRow = new String[this.columnCount];
        this.columnTypes = new int[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.headerRow[i] = resultSetMetaData.getColumnLabel(i + 1);
            this.columnTypes[i] = resultSetMetaData.getColumnType(i + 1);
        }
    }

    @Override
    public String[] getHeaderRow() {
        return this.headerRow;
    }

    @Override
    public String[] readDataRow() throws AnaplanAPIException {
        try {
            if (this.resultSet == null || !this.resultSet.next()) {
                return null;
            }
            String[] dataRow = new String[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                Object val = this.resultSet.getObject(i + 1);
                dataRow[i] = val == null ? "" : val.toString();
            }
            return dataRow;
        }
        catch (SQLException sqle) {
            throw new AnaplanAPIException("Failed to retrieve result data", sqle);
        }
    }

    @Override
    public void close() {
        block17: {
            if (this.resultSet != null) {
                block14: {
                    try {
                        this.resultSet.close();
                    }
                    catch (SQLException sqle) {
                        if (!this.debug) break block14;
                        logger.warning("Warning: failed to close result set: " + sqle);
                    }
                }
                this.resultSet = null;
            }
            if (this.statement != null) {
                block15: {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException sqle) {
                        if (!this.debug) break block15;
                        logger.warning("Warning: failed to close prepared statement: " + sqle);
                    }
                }
                this.statement = null;
            }
            boolean closed = false;
            try {
                closed = this.connection.isClosed();
            }
            catch (SQLException sqle) {
                logger.warning("Warning: failed to determine if JDBC connection closed: " + sqle);
            }
            if (this.connection != null && !closed) {
                block16: {
                    if (!this.autoCommit) {
                        try {
                            this.connection.commit();
                        }
                        catch (SQLException sqle) {
                            if (!this.debug) break block16;
                            logger.warning("Warning: failed to commit JDBC connection: " + sqle);
                        }
                    }
                }
                try {
                    this.connection.close();
                }
                catch (SQLException sqle) {
                    if (!this.debug) break block17;
                    logger.warning("Warning: failed to close JDBC connection: " + sqle);
                }
            }
        }
        this.connection = null;
    }
}

