/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class EncodingUtils {
    private static final String CHARSET = "UTF-8";

    public static String encodeAndXor(String value) throws UnsupportedEncodingException {
        String xored = EncodingUtils.convertViaXOR(value);
        return URLEncoder.encode(xored, CHARSET);
    }

    public static String decodeAndXor(String value) throws UnsupportedEncodingException {
        String urlDecoded = URLDecoder.decode(value, CHARSET);
        return EncodingUtils.convertViaXOR(urlDecoded);
    }

    private static String convertViaXOR(String value) {
        int key = 129;
        StringBuilder outSb = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            c = (char)(c ^ 0x81);
            outSb.append(c);
        }
        return outSb.toString();
    }
}

