/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import java.util.HashMap;
import java.util.Map;

public class UserMessages {
    private static Map<String, String> messages = new HashMap<String, String>();

    private static void addMessage(String messageKey, String message) {
        if (messageKey == null) {
            throw new IllegalArgumentException("message key cannot be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("message body cannot be null");
        }
        messages.put(messageKey, message);
    }

    public static String getMessage(String messageKey) {
        if (messageKey == null) {
            throw new IllegalArgumentException("message key cannot be null");
        }
        String messageBody = messages.get(messageKey);
        if (messageBody == null) {
            throw new IllegalArgumentException("no message found for key " + messageKey);
        }
        return messageBody;
    }

    public static String getMessage(String messageKey, String detail) {
        String message = UserMessages.getMessage(messageKey);
        return message + ": " + detail;
    }

    static {
        UserMessages.addMessage("modelSuccess", "Successfully connected to Anaplan Model");
        UserMessages.addMessage("importSuccess", "Import completed successfully");
        UserMessages.addMessage("noInput", "Cannot import to Anaplan: no input data provided");
        UserMessages.addMessage("streamUnsupported", "Cannot import multiple documents to Anaplan.");
        UserMessages.addMessage("invalidModel", "Invalid model Id");
        UserMessages.addMessage("invalidWorkspace", "Invalid workspace Id");
        UserMessages.addMessage("invalidImport", "Invalid import Id");
        UserMessages.addMessage("invalidExport", "Invalid export Id");
        UserMessages.addMessage("invalidFile", "Invalid file Id");
        UserMessages.addMessage("invalidApiUri", "Error: Invalid URI syntax in specified endpoint");
        UserMessages.addMessage("exportStartWrite", "Export processing complete, starting write");
        UserMessages.addMessage("exportRetrieveError", "Could not retrieve processed export data");
        UserMessages.addMessage("missingFile", "Nothing to write: data file could not be retrieved");
        UserMessages.addMessage("accessFail", "Wrong username or password, or no workspaces accessible");
        UserMessages.addMessage("apiConnectFail", "Error accessing Anaplan API");
        UserMessages.addMessage("workspaceAccessFail", "Error accessing Anaplan Workspace");
        UserMessages.addMessage("modelAccessFail", "Error accessing Anaplan Model");
        UserMessages.addMessage("workspaceOrModelAccessFail", "Error accessing Anaplan Workspace or Model");
        UserMessages.addMessage("failureDump", "Failed records report available");
        UserMessages.addMessage("noFailureDump", "No failed records report available");
        UserMessages.addMessage("importBadData", "Some records were not imported: check connector output data for details");
        UserMessages.addMessage("executeActionSuccess", "Successfully executed delete Action");
        UserMessages.addMessage("invalidProcess", "Invalid Process ID provided");
    }
}

