/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Model;
import com.anaplan.client.Process;
import com.anaplan.client.Task;
import com.anaplan.client.TaskStatus;
import com.anaplan.connector.MulesoftAnaplanResponse;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.AnaplanUtil;
import com.anaplan.connector.utils.BaseAnaplanOperation;
import com.anaplan.connector.utils.UserMessages;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnaplanProcessOperation
extends BaseAnaplanOperation {
    private static Logger logger = LogManager.getLogger((String)AnaplanProcessOperation.class.getName());

    public AnaplanProcessOperation(AnaplanConnection apiConn) {
        super(apiConn);
    }

    private MulesoftAnaplanResponse runProcessTask(Model model, String processId) throws AnaplanAPIException {
        Process process = model.getProcess(processId);
        if (process == null) {
            String msg = UserMessages.getMessage("invalidProcess", processId);
            return MulesoftAnaplanResponse.runProcessFailure(msg, null);
        }
        Task task = process.createTask();
        TaskStatus status = AnaplanUtil.runServerTask(task);
        if (status.getTaskState() == TaskStatus.State.COMPLETE && status.getResult().isSuccessful()) {
            logger.info("Process ran successfully!");
            AnaplanProcessOperation.setRunStatusDetails(AnaplanProcessOperation.collectTaskLogs(status));
            return MulesoftAnaplanResponse.runProcessSuccess(status.getTaskState().name());
        }
        return MulesoftAnaplanResponse.runProcessFailure("Run Process failed!", null);
    }

    public String runProcess(String workspaceId, String modelId, String processId) throws AnaplanOperationException {
        logger.info("<< Starting Process >>");
        logger.info("Workspace-ID: {}", new Object[]{workspaceId});
        logger.info("Model-ID: {}", new Object[]{modelId});
        logger.info("Process-ID: {}", new Object[]{processId});
        this.validateInput(workspaceId, modelId);
        try {
            logger.info("Starting process: {}", new Object[]{processId});
            MulesoftAnaplanResponse anaplanResponse = this.runProcessTask(this.model, processId);
            logger.info("Process ran successfully: {}, Response message: {}", new Object[]{anaplanResponse.getStatus(), anaplanResponse.getResponseMessage()});
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException(e.getMessage(), e);
        }
        finally {
            this.apiConn.closeConnection();
        }
        String statusMsg = "[" + processId + "] completed successfully!";
        logger.info(statusMsg);
        return statusMsg + "\n\n" + AnaplanProcessOperation.getRunStatusDetails();
    }
}

