/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellWriter;
import com.anaplan.client.Import;
import com.anaplan.client.Model;
import com.anaplan.client.ServerFile;
import com.anaplan.client.Task;
import com.anaplan.client.TaskResult;
import com.anaplan.client.TaskStatus;
import com.anaplan.connector.MulesoftAnaplanResponse;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.AnaplanUtil;
import com.anaplan.connector.utils.BaseAnaplanOperation;
import com.anaplan.connector.utils.UserMessages;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnaplanImportOperation
extends BaseAnaplanOperation {
    private static Logger logger = LogManager.getLogger((String)AnaplanImportOperation.class.getName());

    public AnaplanImportOperation(AnaplanConnection apiConn) {
        super(apiConn);
    }

    public static CSVFormat getCsvFormat(String columnSeparator, String textDelimiter) throws AnaplanOperationException {
        if (columnSeparator.isEmpty()) {
            throw new AnaplanOperationException("Column-Separator needs to be specified!");
        }
        switch (columnSeparator) {
            case ",": {
                if (textDelimiter.isEmpty()) {
                    throw new AnaplanOperationException("Text-Delimiter needs to be specified!");
                }
                return CSVFormat.RFC4180.withDelimiter(columnSeparator.charAt(0)).withQuote(textDelimiter.charAt(0));
            }
            case "\\t": {
                return CSVFormat.TDF;
            }
        }
        throw new AnaplanOperationException("Only commas and tabs are supported column-separators!");
    }

    private static List<String[]> parseImportData(String data, String columnSeparator, String delimiter) throws AnaplanOperationException {
        if (columnSeparator.length() > 1 && !columnSeparator.equals("\\t")) {
            throw new IllegalArgumentException("Multi-character Column-Separator not supported!");
        }
        if (delimiter.length() > 1) {
            throw new IllegalArgumentException("Multi-character Text Delimiter string not supported!");
        }
        CSVFormat csvFormat = AnaplanImportOperation.getCsvFormat(columnSeparator, delimiter);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        try {
            CSVParser csvParser = CSVParser.parse((String)data, (CSVFormat)csvFormat);
            for (CSVRecord record : csvParser.getRecords()) {
                Iterator cellIter = record.iterator();
                String[] cellTokens = new String[record.size()];
                int cellIdx = 0;
                while (cellIter.hasNext()) {
                    cellTokens[cellIdx++] = (String)cellIter.next();
                }
                rows.add(cellTokens);
            }
        }
        catch (IOException e) {
            throw new AnaplanOperationException("Error parsing data:", e);
        }
        return rows;
    }

    private static MulesoftAnaplanResponse runImportCsv(String data, Model model, String importId, String columnSeparator, String delimiter) throws AnaplanOperationException {
        TaskStatus status;
        ServerFile serverFile;
        Import imp;
        int rowsProcessed = 0;
        try {
            imp = model.getImport(importId);
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException("Error fetching Import action:", e);
        }
        if (imp == null) {
            throw new AnaplanOperationException(MessageFormat.format("Invalid import ID provided: {0}", importId));
        }
        try {
            serverFile = model.getServerFile(imp.getSourceFileId());
            if (serverFile == null) {
                throw new AnaplanOperationException("Could not fetch server-file!");
            }
            serverFile.setSeparator(columnSeparator);
            serverFile.setDelimiter(delimiter);
            List<String[]> rows = AnaplanImportOperation.parseImportData(data, columnSeparator, delimiter);
            CellWriter dataWriter = serverFile.getUploadCellWriter();
            dataWriter.writeHeaderRow((Object[])rows.get(0));
            logger.info("import header is:\n{}", new Object[]{AnaplanUtil.debugOutput(rows.get(0))});
            for (Object[] objectArray : rows) {
                dataWriter.writeDataRow(objectArray);
                ++rowsProcessed;
            }
            dataWriter.close();
        }
        catch (AnaplanAPIException | IOException e) {
            throw new AnaplanOperationException("Error encountered while importing data: ", e);
        }
        try {
            Task task = imp.createTask();
            status = AnaplanUtil.runServerTask(task);
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException("Error running Import action:", e);
        }
        String taskDetailsMsg = AnaplanImportOperation.collectTaskLogs(status) + "Import completed successfully: (" + rowsProcessed + " records processed)";
        AnaplanImportOperation.setRunStatusDetails(taskDetailsMsg);
        logger.info(AnaplanImportOperation.getRunStatusDetails());
        TaskResult taskResult = status.getResult();
        if (taskResult.isFailureDumpAvailable()) {
            logger.info(UserMessages.getMessage("failureDump"));
            ServerFile failDump = taskResult.getFailureDump();
            return MulesoftAnaplanResponse.importWithFailureDump(UserMessages.getMessage("importBadData", importId), failDump);
        }
        logger.info(UserMessages.getMessage("noFailureDump"));
        if (taskResult.isSuccessful()) {
            return MulesoftAnaplanResponse.importSuccess(AnaplanImportOperation.getRunStatusDetails(), serverFile);
        }
        return MulesoftAnaplanResponse.importFailure(AnaplanImportOperation.getRunStatusDetails(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runImport(String data, String workspaceId, String modelId, String importId, String columnSeparator, String delimiter) throws AnaplanOperationException {
        logger.info("<< Starting import >>");
        logger.info("Workspace-ID: {}", new Object[]{workspaceId});
        logger.info("Model-ID: {}", new Object[]{modelId});
        logger.info("Import-ID: {}", new Object[]{importId});
        this.validateInput(workspaceId, modelId);
        MulesoftAnaplanResponse anaplanResponse = null;
        try {
            logger.info("Starting import: {}", new Object[]{importId});
            anaplanResponse = AnaplanImportOperation.runImportCsv(data, this.model, importId, columnSeparator, delimiter);
            logger.info("Import complete: Status: {}, Response message: {}", new Object[]{anaplanResponse.getStatus(), anaplanResponse.getResponseMessage()});
        }
        catch (JsonSyntaxException e) {
            MulesoftAnaplanResponse.responseEpicFail(this.apiConn, e, null);
        }
        finally {
            this.apiConn.closeConnection();
        }
        return this.createResponse(anaplanResponse);
    }
}

